/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AReplicateableObjectImpl;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.resources.ID;
import com.mayastudios.fred.client.resources.StringFunctions;
import de.sopra06.domainmodel.Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class CPersonImpl
extends AReplicateableObjectImpl
implements Person,
IXMLizable,
Comparable<CPersonImpl> {
    public static final char ID_PREFIX = 'M';
    public static final char ID_SECURTIY_PREFIX = 'S';
    public static final String XML_TAG_NAME = "person";
    private static final String XML_ATT_ID = "id";
    private static final String XML_ATT_FIRSTNAME = "firstName";
    private static final String XML_ATT_NAME = "name";
    private static final String XML_ATT_INITIALS = "initials";
    private static final String XML_ATT_SECURITYID = "securityid";
    private static final Logger LOGGER = LoggerFactory.getLogger(CPersonImpl.class);
    private String m_strSecurityID = null;
    private String m_strName = null;
    private String m_strFirstName = null;
    private String m_strInitials = null;
    private String m_strToString = "";

    CPersonImpl(String string) {
        this.setID(string);
    }

    public static CPersonImpl create() {
        CPersonImpl cPersonImpl = ObjectFactoryImpl.createPersonImpl(ID.createNewID('M'));
        cPersonImpl.setSecurityID(ID.createNewID('S'));
        return cPersonImpl;
    }

    public String getName() {
        return StringFunctions.readNullString(this.m_strName);
    }

    public void setName(String string) {
        this.m_strName = StringFunctions.storeNullString(string);
        this._refreshToString();
    }

    public String getFirstName() {
        return StringFunctions.readNullString(this.m_strFirstName);
    }

    public void setFirstName(String string) {
        this.m_strFirstName = StringFunctions.storeNullString(string);
        this._refreshToString();
    }

    public String getFullName() {
        String string = this.getFirstName();
        String string2 = this.getName();
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 1);
        stringBuffer.append(string);
        if (string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getInitials() {
        return StringFunctions.readNullString(this.m_strInitials);
    }

    public void setInitials(String string) {
        String string2 = StringFunctions.isPersonShortNameValid(string);
        if (string2 == null) {
            this.m_strInitials = StringFunctions.storeNullString(string);
        } else {
            LOGGER.error("{}#setInitials: \"" + string + "\" not okay: {}", (Object)this.getClass().getName(), (Object)string2);
        }
        this._refreshToString();
    }

    public String getSecurityID() {
        return StringFunctions.readNullString(this.m_strSecurityID);
    }

    public void setSecurityID(String string) {
        this.m_strSecurityID = StringFunctions.storeNullString(string);
    }

    @Override
    public int compareTo(CPersonImpl cPersonImpl) {
        int n = this.getName().compareTo(cPersonImpl.getName());
        if (n == 0) {
            n = this.getFirstName().compareTo(cPersonImpl.getFirstName());
            if (n == 0) {
                n = this.getInitials().compareTo(cPersonImpl.getInitials());
                if (n == 0) {
                    if (this.equals(cPersonImpl)) {
                        return 0;
                    }
                    n = this.getID().compareTo(cPersonImpl.getID());
                    if (n == 0) {
                        LOGGER.error("{}#compareTo: getID() == p_oOther.getID() && !equals(p_oOther)", (Object)this.getClass().getName());
                    }
                    return n;
                }
                return n;
            }
            return n;
        }
        return n;
    }

    public String toString() {
        return this.m_strToString;
    }

    private void _refreshToString() {
        String string = this.getFirstName();
        String string2 = this.getName();
        String string3 = this.getInitials();
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + string3.length() + 4);
        stringBuffer.append(string);
        if (string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string2);
        }
        if (string3.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" (" + string3 + ")");
            } else {
                stringBuffer.append(string3);
            }
        }
        this.m_strToString = stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_ID, this.getID());
        cSimpleXMLStream.addAttribute(XML_ATT_FIRSTNAME, this.getFirstName());
        cSimpleXMLStream.addAttribute(XML_ATT_NAME, this.getName());
        cSimpleXMLStream.addAttribute(XML_ATT_INITIALS, this.getInitials());
        cSimpleXMLStream.addAttribute(XML_ATT_SECURITYID, this.getSecurityID());
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static class CPersonContainer
    extends AChildlessXMLObjectContainer<CPersonImpl> {
        @Override
        protected CPersonImpl createContainedObject(Attributes attributes, int n) {
            String string = attributes.getValue(CPersonImpl.XML_ATT_ID);
            CPersonImpl cPersonImpl = ObjectFactoryImpl.createPersonImpl(string);
            cPersonImpl.setFirstName(attributes.getValue(CPersonImpl.XML_ATT_FIRSTNAME));
            cPersonImpl.setName(attributes.getValue(CPersonImpl.XML_ATT_NAME));
            cPersonImpl.setInitials(attributes.getValue(CPersonImpl.XML_ATT_INITIALS));
            cPersonImpl.setSecurityID(attributes.getValue(CPersonImpl.XML_ATT_SECURITYID));
            return cPersonImpl;
        }
    }
}

