/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.AReplicateableObjectImpl;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CEffortTree;
import com.mayastudios.fred.client.model.CEffortVector;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CStatistic;
import com.mayastudios.fred.client.model.DefaultTask;
import com.mayastudios.fred.client.model.ObjectFactoryImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.resources.DateTime;
import com.mayastudios.fred.client.resources.ID;
import com.mayastudios.fred.client.resources.StringFunctions;
import de.sopra06.domainmodel.Project;
import de.sopra06.domainmodel.Task;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class CTaskImpl
extends AReplicateableObjectImpl
implements Task,
IXMLizable,
Comparable<CTaskImpl> {
    public static final char ID_PREFIX = 'T';
    public static final String XML_TAG_NAME = "task";
    private static final String XML_ATT_ID = "id";
    private static final String XML_ATT_NAME = "name";
    private static final String XML_ATT_SHORTNAME = "shortname";
    private static final String XML_ATT_DESCRIPTION = "description";
    private static final String XML_ATT_DEFAULT_CATEGORY = "defaultcategory";
    private static final String XML_ATT_IS_TEAMTASK = "isteamtask";
    private static final String XML_ATT_CREATED_AT = "createdat";
    private static final String XML_ATT_SUBSCRIBED_AT = "subscribedat";
    private static final Logger LOGGER = LoggerFactory.getLogger(CTaskImpl.class);
    private String m_strName = null;
    private String m_strShortName = null;
    private String m_strDescription;
    private CProjectImpl m_oProject = null;
    private CategoryList.CCategory m_oDefaultCategory = null;
    Calendar m_oCreatedAt = null;
    Calendar m_oSubscribedAt = null;
    private boolean m_bTeamTask = false;
    private CEffortTree m_oEffortTree;
    CStatistic m_oStatistic;
    private String m_strToString = "";
    private boolean m_bCheckForNameChanges;

    CTaskImpl(String string) {
        this.setID(string);
        this.m_oEffortTree = new CEffortTree();
        this.m_oStatistic = new CStatistic(null);
        this.m_bCheckForNameChanges = false;
    }

    public static CTaskImpl create() {
        CTaskImpl cTaskImpl = ObjectFactoryImpl.createTaskImpl(ID.createNewID('T'));
        cTaskImpl.setCreatedNow();
        return cTaskImpl;
    }

    public String getName() {
        return StringFunctions.readNullString(this.m_strName);
    }

    public void setName(String string) {
        if (!this.m_bCheckForNameChanges || this.m_oProject.isTaskNameValid(this, string)) {
            String string2 = StringFunctions.isNameValid(string);
            if (string2 == null) {
                this.m_strName = StringFunctions.storeNullString(string);
                this._refreshToString();
            } else {
                LOGGER.error("{}#setName: \"{}\" not okay: " + string2, (Object)this.getClass().getName(), (Object)string);
            }
        } else if (this.m_bCheckForNameChanges) {
            LOGGER.error("{}#setName: Task \"{}\" already exists", (Object)this.getClass().getName(), (Object)string);
        }
    }

    public String getShortName() {
        return StringFunctions.readNullString(this.m_strShortName);
    }

    public void setShortName(String string) {
        if (!this.m_bCheckForNameChanges || this.m_oProject.isTaskShortNameValid(this, string)) {
            String string2 = StringFunctions.isTaskShortNameValid(string);
            if (string2 == null) {
                this.m_strShortName = StringFunctions.storeNullString(string);
                this._refreshToString();
            } else {
                LOGGER.error("{}#setShortName: \"{}\" not okay: " + string2, (Object)this.getClass().getName(), (Object)string);
            }
        } else if (this.m_bCheckForNameChanges) {
            LOGGER.error("{}#setShortName: Task \"{}\" already exists", (Object)this.getClass().getName(), (Object)string);
        }
    }

    public String getDescription() {
        return StringFunctions.readNullString(this.m_strDescription);
    }

    public void setDescription(String string) {
        this.m_strDescription = StringFunctions.storeNullString(string);
    }

    public CProjectImpl getProject() {
        return this.m_oProject;
    }

    public void setProject(Project project) {
        this.m_oProject = (CProjectImpl)project;
    }

    public int getDefaultCategory() {
        if (this.m_oDefaultCategory == null) {
            return -1;
        }
        return this.m_oDefaultCategory.getID();
    }

    public CategoryList.CCategory getDefaultCCategory() {
        return this.m_oDefaultCategory;
    }

    public void setDefaultCategory(int n) {
        this.m_oDefaultCategory = CategoryList.getCategoryByID(n);
    }

    public void setDefaultCategory(CategoryList.CCategory cCategory) {
        this.m_oDefaultCategory = cCategory;
    }

    public Calendar getCreatedAt() {
        return this.m_oCreatedAt;
    }

    public void setCreatedNow() {
        this.m_oCreatedAt = Calendar.getInstance();
    }

    public Calendar getSubscribedAt() {
        return this.m_oSubscribedAt;
    }

    public void setSubscribedNow() {
        this.m_oSubscribedAt = Calendar.getInstance();
    }

    public boolean isTeamTask() {
        return this.m_bTeamTask;
    }

    public void setTeamTask(boolean bl) {
        this.m_bTeamTask = bl;
    }

    public boolean isSubscibed() {
        return this.isTeamTask() && !this.getProject().isUserProjectLeader();
    }

    public boolean isBroadcasted() {
        return this.isTeamTask() && this.getProject().isUserProjectLeader();
    }

    public boolean isDefaultTask() {
        return DefaultTask.get() == this;
    }

    public CStatistic getStatistic() {
        return this.m_oStatistic;
    }

    public void setCheckForNameChanges(boolean bl) {
        this.m_bCheckForNameChanges = bl;
    }

    public boolean addEffort(CEffortImpl cEffortImpl, boolean bl, boolean bl2) {
        if (this.m_oEffortTree.add(cEffortImpl)) {
            cEffortImpl.setTask(this);
            cEffortImpl.setUpdateStatistic(true);
            if (bl) {
                this._updateStatisticByEffort(cEffortImpl);
            }
            if (bl2) {
                ProjectList.getInstance().discoverSemanticConflicts(cEffortImpl);
            }
            return true;
        }
        return false;
    }

    private void _updateStatisticByEffort(CEffortImpl cEffortImpl) {
        this.m_oStatistic.updateEffortsOfPerson(cEffortImpl.getPerson(), 1);
        this.m_oStatistic.updateEffortsOfCategory(cEffortImpl.getCCategory(), 1);
        this.m_oStatistic.updateFieldValue(0, 1);
        this.m_oStatistic.updateFieldValue(1, cEffortImpl.getDuration());
        if (cEffortImpl.isReplicated()) {
            this.m_oStatistic.updateFieldValue(2, 1);
        }
        if (cEffortImpl.getAccepted() == CEffortImpl.EAccepted.Accepted) {
            this.m_oStatistic.updateFieldValue(3, 1);
        } else if (cEffortImpl.getAccepted() == CEffortImpl.EAccepted.NotAccepted) {
            this.m_oStatistic.updateFieldValue(4, 1);
        }
    }

    public void repositionEffort(CEffortImpl cEffortImpl, Calendar calendar, int n, int n2) {
        if (this.m_oEffortTree.remove(cEffortImpl)) {
            cEffortImpl.removeAllCollidations();
            cEffortImpl.setBegin(calendar);
            cEffortImpl.setDuration(n);
            cEffortImpl.setPauseDuration(n2);
            ProjectList.getInstance().discoverSemanticConflicts(cEffortImpl);
            this.m_oEffortTree.add(cEffortImpl);
        } else {
            LOGGER.error("{}#repositionEffort: !this.m_oEffortTree.remove(p_oEffort)", (Object)this.getClass().getName());
        }
    }

    public boolean removeEffort(CEffortImpl cEffortImpl) {
        if (this.m_oEffortTree.remove(cEffortImpl)) {
            cEffortImpl.setUpdateStatistic(false);
            this.m_oStatistic.updateEffortsOfPerson(cEffortImpl.getPerson(), -1);
            this.m_oStatistic.updateEffortsOfCategory(cEffortImpl.getCCategory().getIndex(), -1);
            this.m_oStatistic.updateFieldValue(0, -1);
            this.m_oStatistic.updateFieldValue(1, -1 * cEffortImpl.getDuration());
            if (cEffortImpl.isReplicated()) {
                this.m_oStatistic.updateFieldValue(2, -1);
            }
            if (cEffortImpl.getAccepted() == CEffortImpl.EAccepted.Accepted) {
                this.m_oStatistic.updateFieldValue(3, -1);
            } else if (cEffortImpl.getAccepted() == CEffortImpl.EAccepted.NotAccepted) {
                this.m_oStatistic.updateFieldValue(4, -1);
            }
            cEffortImpl.removeAllCollidations();
            return true;
        }
        return false;
    }

    public Vector<CTaskImpl> toVector() {
        Vector<CTaskImpl> vector = new Vector<CTaskImpl>(1);
        vector.add(this);
        return vector;
    }

    Iterator<CEffortImpl> getEffortIterator() {
        return this.m_oEffortTree.iteratorUpAll();
    }

    SortedSet<CEffortImpl> getEffortTree() {
        return Collections.unmodifiableSortedSet(this.m_oEffortTree);
    }

    void checkTree(PrintWriter printWriter) {
        this.m_oEffortTree.checkTree(printWriter);
    }

    public void getContainedEffortsFiltered(AFilter aFilter, CEffortVector cEffortVector, AFilter.EFilterMode eFilterMode) {
        this.m_oEffortTree.getContainedEffortsFiltered(aFilter, cEffortVector, eFilterMode);
    }

    @Override
    public int compareTo(CTaskImpl cTaskImpl) {
        int n = this.getName().compareTo(cTaskImpl.getName());
        if (n == 0) {
            if (this.equals(cTaskImpl)) {
                return 0;
            }
            n = this.getID().compareTo(cTaskImpl.getID());
            if (n == 0) {
                LOGGER.error("{}#compareTo: getID() == p_oOtherTask.getID() && !equals(p_oOther)", (Object)this.getClass().getName());
            }
            return n;
        }
        return n;
    }

    public String toString() {
        if (this.isDefaultTask()) {
            return this.m_strToString + " *";
        }
        return this.m_strToString;
    }

    private void _refreshToString() {
        String string = this.getName();
        String string2 = this.getShortName();
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 3);
        stringBuffer.append(string);
        if (string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" (" + string2 + ")");
            } else {
                stringBuffer.append(string2);
            }
        }
        this.m_strToString = stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void discoverSemanticConflicts(CEffortImpl cEffortImpl) {
        this.m_oEffortTree.discoverSemanticConflicts(cEffortImpl);
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_ID, String.valueOf(this.getID()));
        cSimpleXMLStream.addAttribute(XML_ATT_NAME, this.getName());
        cSimpleXMLStream.addAttribute(XML_ATT_SHORTNAME, this.getShortName());
        cSimpleXMLStream.addAttribute(XML_ATT_DESCRIPTION, this.getDescription());
        cSimpleXMLStream.addAttribute(XML_ATT_DEFAULT_CATEGORY, String.valueOf(this.getDefaultCategory()));
        cSimpleXMLStream.addAttribute(XML_ATT_IS_TEAMTASK, String.valueOf(this.isTeamTask()));
        if (this.getCreatedAt() != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_CREATED_AT, DateTime.getXMLDateTime(this.getCreatedAt()));
        }
        if (this.getSubscribedAt() != null) {
            cSimpleXMLStream.addAttribute(XML_ATT_SUBSCRIBED_AT, DateTime.getXMLDateTime(this.getSubscribedAt()));
        }
        this.m_oStatistic.xmlize(cSimpleXMLStream);
        this.m_oEffortTree.xmlize(cSimpleXMLStream);
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static class CTaskStoreContainer
    extends AXMLObjectContainer<CTaskImpl> {
        private static final CEffortImpl.CEffortStoreContainer EFFORT_CONTAINER = new CEffortImpl.CEffortStoreContainer();
        private static final CStatistic.CStatisticStoreContainer STATISTIC_CONTAINER = new CStatistic.CStatisticStoreContainer();

        @Override
        protected CTaskImpl createContainedObject(Attributes attributes, int n) {
            String string;
            String string2 = attributes.getValue(CTaskImpl.XML_ATT_ID);
            CTaskImpl cTaskImpl = ObjectFactoryImpl.createTaskImpl(string2);
            cTaskImpl.setName(attributes.getValue(CTaskImpl.XML_ATT_NAME));
            cTaskImpl.setShortName(attributes.getValue(CTaskImpl.XML_ATT_SHORTNAME));
            cTaskImpl.setDescription(attributes.getValue(CTaskImpl.XML_ATT_DESCRIPTION));
            cTaskImpl.setDefaultCategory(Integer.parseInt(attributes.getValue(CTaskImpl.XML_ATT_DEFAULT_CATEGORY)));
            cTaskImpl.setTeamTask(Boolean.parseBoolean(attributes.getValue(CTaskImpl.XML_ATT_IS_TEAMTASK)));
            String string3 = attributes.getValue(CTaskImpl.XML_ATT_CREATED_AT);
            if (string3 != null) {
                cTaskImpl.m_oCreatedAt = DateTime.parseXMLDateTime(string3);
            }
            if ((string = attributes.getValue(CTaskImpl.XML_ATT_SUBSCRIBED_AT)) != null) {
                cTaskImpl.m_oSubscribedAt = DateTime.parseXMLDateTime(string);
            }
            return cTaskImpl;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("statistic")) {
                return STATISTIC_CONTAINER;
            }
            if (string.equals("effort")) {
                return EFFORT_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals("statistic")) {
                ((CTaskImpl)this.getContainedObject()).m_oStatistic = (CStatistic)object;
            } else if (string.equals("effort")) {
                ((CTaskImpl)this.getContainedObject()).addEffort((CEffortImpl)object, false, false);
            }
        }

        @Override
        protected void completeContainedObject(int n) {
            CTaskImpl cTaskImpl = (CTaskImpl)this.getContainedObject();
            if (cTaskImpl.getStatistic().getFieldValue(0) != cTaskImpl.getEffortTree().size()) {
                cTaskImpl.m_oStatistic = new CStatistic(null);
                for (CEffortImpl cEffortImpl : cTaskImpl.getEffortTree()) {
                    cTaskImpl._updateStatisticByEffort(cEffortImpl);
                }
            }
        }
    }
}

