/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.exceptions.CModelException;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.resources.CURLComparer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.xml.sax.Attributes;

public class CURLList
extends TreeSet<URL>
implements IXMLizable {
    public static final String XML_TAG_NAME = "urllist";
    private static final String XML_URL_TAG_NAME = "url";
    private static final String XML_URL_ATT_URL = "external";

    public CURLList() {
        super(new CURLComparer());
    }

    public Vector<URL> getURLVector() {
        Vector<URL> vector = new Vector<URL>(super.size());
        vector.addAll(this);
        return vector;
    }

    public DefaultComboBoxModel getComboBoxModel() {
        return new DefaultComboBoxModel<URL>(this.getURLVector());
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            cSimpleXMLStream.startElement(XML_URL_TAG_NAME);
            cSimpleXMLStream.addAttribute(XML_URL_ATT_URL, ((URL)iterator.next()).toExternalForm());
            cSimpleXMLStream.endElement(XML_URL_TAG_NAME);
        }
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    private static class CURLContainer
    extends AChildlessXMLObjectContainer<URL> {
        @Override
        protected URL createContainedObject(Attributes attributes, int n) throws CModelException {
            String string = attributes.getValue(CURLList.XML_URL_ATT_URL);
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CModelException(malformedURLException);
            }
        }
    }

    public static class CFactory
    extends AXMLObjectContainer<CURLList> {
        private static final CURLContainer URL_CONTAINER = new CURLContainer();

        @Override
        protected CURLList createContainedObject(Attributes attributes, int n) {
            return new CURLList();
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals(CURLList.XML_URL_TAG_NAME)) {
                return URL_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals(CURLList.XML_URL_TAG_NAME)) {
                ((CURLList)this.m_oObject).add((URL)object);
            }
        }
    }
}

