/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.exceptions.CDuplicateProjectNameException;
import com.mayastudios.fred.client.exceptions.CFredRuntimeException;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AFilter;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CEffortTree;
import com.mayastudios.fred.client.model.CEffortVector;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CStatistic;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.resources.CategoryList;
import com.mayastudios.fred.client.view.CProjectTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.Attributes;

public class ProjectList
implements IXMLizable,
Iterable<CProjectImpl> {
    private static ProjectList s_oInstance = null;
    public static final String XML_TAG_NAME = "projectlist";
    private static final String XML_ATT_PROJECT_COUNT = "projectcount";
    private Vector<CProjectImpl> m_oProjectVector;
    private CStatistic m_oStatistic;
    private static int s_iSubscribedProjectCount = 0;
    private static int s_iTaskCount = 0;
    private static int s_iSubscribedTaskCount = 0;

    private ProjectList(int n) {
        this.m_oProjectVector = new Vector(n + 2, 2);
        this.m_oStatistic = new CStatistic(null);
    }

    public static ProjectList getInstance() {
        return s_oInstance;
    }

    public static void createInstance() {
        ProjectList.createInstance(10);
    }

    public static void createInstance(int n) {
        if (s_oInstance != null) {
            throw new Error("ProjectList does alredy exist");
        }
        s_oInstance = new ProjectList(n);
    }

    public static void clearInstance() {
        s_oInstance = null;
    }

    public void addProject(CProjectImpl cProjectImpl, boolean bl) throws CDuplicateProjectNameException {
        if (this.isProjectNameValid(cProjectImpl, cProjectImpl.getName()) && this.m_oProjectVector.indexOf(cProjectImpl) == -1) {
            this.m_oProjectVector.add(cProjectImpl);
            cProjectImpl.getStatistic().setParentStatistic(this.m_oStatistic);
            cProjectImpl.setCheckForNameChanges(true);
            if (bl) {
                this.m_oStatistic.addStatistic(cProjectImpl.getStatistic());
            }
        } else {
            throw new CDuplicateProjectNameException("Projectname \"" + cProjectImpl.getName() + "\" already used in this Projektlist");
        }
    }

    public boolean contains(CProjectImpl cProjectImpl) {
        return this.m_oProjectVector.contains(cProjectImpl);
    }

    public void removeProject(CProjectImpl cProjectImpl) {
        this.m_oProjectVector.remove(cProjectImpl);
        cProjectImpl.getStatistic().setParentStatistic(null);
        this.m_oStatistic.subtractStatistic(cProjectImpl.getStatistic());
        cProjectImpl.setCheckForNameChanges(false);
    }

    public void deleteContained(Vector<CProjectImpl> vector) {
        vector.removeAll(this.m_oProjectVector);
    }

    public boolean addEffort(CEffortImpl cEffortImpl) {
        CTaskImpl cTaskImpl = cEffortImpl.getTask();
        return cTaskImpl.addEffort(cEffortImpl, true, true);
    }

    public void removeEffort(CEffortImpl cEffortImpl) {
        CTaskImpl cTaskImpl = cEffortImpl.getTask();
        cTaskImpl.removeEffort(cEffortImpl);
    }

    public void discoverSemanticConflicts(CEffortImpl cEffortImpl) {
        Iterator<CProjectImpl> iterator = this.m_oProjectVector.iterator();
        while (iterator.hasNext()) {
            iterator.next().discoverSemanticConflicts(cEffortImpl);
        }
    }

    public CStatistic getStatistic() {
        return this.m_oStatistic;
    }

    public int getProjectCount() {
        return this.m_oProjectVector.size();
    }

    public int getSubscribedProjectCount() {
        ProjectList._refreshLocalStatistic();
        return s_iSubscribedProjectCount;
    }

    public int getTaskCount() {
        ProjectList._refreshLocalStatistic();
        return s_iTaskCount;
    }

    public int getSubscribedTaskCount() {
        ProjectList._refreshLocalStatistic();
        return s_iSubscribedTaskCount;
    }

    private static void _refreshLocalStatistic() {
        s_iSubscribedProjectCount = 0;
        s_iTaskCount = 0;
        s_iSubscribedTaskCount = 0;
        Iterator<CProjectImpl> iterator = s_oInstance.iterator();
        CProjectImpl cProjectImpl = null;
        CTaskImpl cTaskImpl = null;
        while (iterator.hasNext()) {
            cProjectImpl = iterator.next();
            if (cProjectImpl.isSubscibed()) {
                ++s_iSubscribedProjectCount;
            }
            Iterator<CTaskImpl> iterator2 = cProjectImpl.getTaskIterator();
            while (iterator2.hasNext()) {
                cTaskImpl = iterator2.next();
                ++s_iTaskCount;
                if (!cTaskImpl.isSubscibed()) continue;
                ++s_iSubscribedTaskCount;
            }
        }
    }

    public boolean isUnclosedTaskAvailableExcTask(CTaskImpl cTaskImpl) {
        Iterator<CProjectImpl> iterator = s_oInstance.iterator();
        CProjectImpl cProjectImpl = null;
        while (iterator.hasNext()) {
            cProjectImpl = iterator.next();
            if (cProjectImpl.isClosed()) continue;
            if (cTaskImpl == null && cProjectImpl.getTaskCount() > 0) {
                return true;
            }
            Iterator<CTaskImpl> iterator2 = cProjectImpl.getTaskIterator();
            while (iterator2.hasNext()) {
                if (iterator2.next() == cTaskImpl) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator<CProjectImpl> getProjectIterator() {
        ArrayList<CProjectImpl> arrayList = new ArrayList<CProjectImpl>(this.m_oProjectVector.size());
        arrayList.addAll(this.m_oProjectVector);
        Collections.sort(arrayList);
        return arrayList.iterator();
    }

    @Override
    public Iterator<CProjectImpl> iterator() {
        return this.getProjectIterator();
    }

    public DefaultComboBoxModel getProjectComboBoxModel() {
        DefaultComboBoxModel<CProjectImpl> defaultComboBoxModel = new DefaultComboBoxModel<CProjectImpl>();
        Iterator<CProjectImpl> iterator = this.iterator();
        while (iterator.hasNext()) {
            defaultComboBoxModel.addElement(iterator.next());
        }
        return defaultComboBoxModel;
    }

    public CProjectImpl getProjectForTaskCreation() {
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (cProjectImpl.isClosed() || !cProjectImpl.isUserProjectLeader()) continue;
            return cProjectImpl;
        }
        return null;
    }

    public DefaultComboBoxModel getProjectsForTaskCreation() {
        DefaultComboBoxModel<CProjectImpl> defaultComboBoxModel = new DefaultComboBoxModel<CProjectImpl>();
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (cProjectImpl.isClosed() || !cProjectImpl.isUserProjectLeader()) continue;
            defaultComboBoxModel.addElement(cProjectImpl);
        }
        return defaultComboBoxModel;
    }

    public DefaultComboBoxModel getEditableProjectComboBoxModel() {
        DefaultComboBoxModel<CProjectImpl> defaultComboBoxModel = new DefaultComboBoxModel<CProjectImpl>();
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (!cProjectImpl.isUserProjectLeader() || cProjectImpl.isClosed()) continue;
            defaultComboBoxModel.addElement(cProjectImpl);
        }
        return defaultComboBoxModel;
    }

    public DefaultComboBoxModel getSubscribedProjectComboBoxModel() {
        DefaultComboBoxModel<CProjectImpl> defaultComboBoxModel = new DefaultComboBoxModel<CProjectImpl>();
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (cProjectImpl.isClosed() || !cProjectImpl.isSubscibed()) continue;
            defaultComboBoxModel.addElement(cProjectImpl);
        }
        return defaultComboBoxModel;
    }

    public boolean existsBroadcastableProject() {
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (cProjectImpl.isClosed() || cProjectImpl.isTeamProject()) continue;
            return true;
        }
        return false;
    }

    public Vector<CProjectImpl> getBroadcastableProjects() {
        Vector<CProjectImpl> vector = new Vector<CProjectImpl>(this.m_oProjectVector.size());
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (cProjectImpl.isClosed() || cProjectImpl.isTeamProject()) continue;
            vector.addElement(cProjectImpl);
        }
        return vector;
    }

    public boolean existsBroadcastedUnclosedProject() {
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (cProjectImpl.isClosed() || !cProjectImpl.isBroadcasted()) continue;
            return true;
        }
        return false;
    }

    public Vector<CProjectImpl> getBroadcastedProjects() {
        Vector<CProjectImpl> vector = new Vector<CProjectImpl>(this.m_oProjectVector.size());
        for (CProjectImpl cProjectImpl : this.m_oProjectVector) {
            if (cProjectImpl.isClosed() || !cProjectImpl.isBroadcasted()) continue;
            vector.addElement(cProjectImpl);
        }
        return vector;
    }

    public boolean existsBroadcastedUnclosedTask() {
        Iterator<CProjectImpl> iterator = s_oInstance.iterator();
        CProjectImpl cProjectImpl = null;
        while (iterator.hasNext()) {
            cProjectImpl = iterator.next();
            if (cProjectImpl.isClosed() || !cProjectImpl.isBroadcasted() || !cProjectImpl.isUserProjectLeader()) continue;
            Iterator<CTaskImpl> iterator2 = cProjectImpl.getTaskIterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().isTeamTask()) continue;
                return true;
            }
        }
        return false;
    }

    public DefaultMutableTreeNode getTree(CProjectTree.ETreeType eTreeType) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(CProjectTree.ROOT_NODE_NAME);
        Iterator<CProjectImpl> iterator = this.iterator();
        switch (eTreeType) {
            case ShowTasks: {
                while (iterator.hasNext()) {
                    CProjectImpl cProjectImpl = iterator.next();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(cProjectImpl);
                    Iterator<CTaskImpl> iterator2 = cProjectImpl.getTaskIterator();
                    while (iterator2.hasNext()) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(iterator2.next());
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    }
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                break;
            }
            case ShowCategories: {
                while (iterator.hasNext()) {
                    CProjectImpl cProjectImpl = iterator.next();
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(cProjectImpl);
                    for (int i = 0; i < CategoryList.getCategoryCount(); ++i) {
                        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(CategoryList.getCategory(i));
                        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                    }
                    defaultMutableTreeNode.add(defaultMutableTreeNode4);
                }
                break;
            }
        }
        return defaultMutableTreeNode;
    }

    public CEffortVector getContainedEfforts(AFilter aFilter) {
        AFilter.EFilterMode eFilterMode;
        int n;
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = 0;
        ConcurrentLinkedQueue<Object> concurrentLinkedQueue = new ConcurrentLinkedQueue<Object>();
        if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            object2 = aFilter.getTaskIterator();
            while (object2.hasNext()) {
                object = (CTaskImpl)object2.next();
                n = aFilter.useThisFilter() ? ((CTaskImpl)object).getStatistic().estimateFittingEffortCount(aFilter, (CTaskImpl)object) : ((CTaskImpl)object).getStatistic().getFieldValue(0);
                if (n <= 0) continue;
                n2 += n;
                concurrentLinkedQueue.add(object);
                ++n3;
            }
        } else if (aFilter instanceof AFilter.CCategoriesInTreeFilter) {
            object2 = this.iterator();
            while (object2.hasNext()) {
                object = ((CProjectImpl)object2.next()).getTaskIterator();
                while (object.hasNext()) {
                    CTaskImpl cTaskImpl = (CTaskImpl)object.next();
                    n = aFilter.useThisFilter() ? cTaskImpl.getStatistic().estimateFittingEffortCount(aFilter, cTaskImpl) : cTaskImpl.getStatistic().getFieldValue(0);
                    if (n <= 0) continue;
                    n2 += n;
                    concurrentLinkedQueue.add(cTaskImpl);
                    ++n3;
                }
            }
        }
        if (n2 == 0) {
            return new CEffortVector(1);
        }
        object2 = new CEffortVector(n2);
        if (aFilter.useThisFilter()) {
            eFilterMode = aFilter.isColidingReferenceSet() ? AFilter.EFilterMode.CollidingFilter : AFilter.EFilterMode.FullFilter;
        } else if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            eFilterMode = AFilter.EFilterMode.TaskFilter;
        } else if (aFilter instanceof AFilter.CCategoriesInTreeFilter) {
            eFilterMode = AFilter.EFilterMode.CategoryFilter;
        } else {
            throw new CFredRuntimeException("unreachable FilterMode");
        }
        while (!concurrentLinkedQueue.isEmpty()) {
            ((CTaskImpl)concurrentLinkedQueue.poll()).getContainedEffortsFiltered(aFilter, (CEffortVector)object2, eFilterMode);
        }
        ((CEffortVector)object2).sort();
        return object2;
    }

    public boolean isProjectNameValid(CProjectImpl cProjectImpl, String string) {
        for (CProjectImpl cProjectImpl2 : this.m_oProjectVector) {
            if (!cProjectImpl2.getName().equals(string)) continue;
            return cProjectImpl2 == cProjectImpl;
        }
        return true;
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_PROJECT_COUNT, String.valueOf(this.m_oProjectVector.size()));
        this.getStatistic().xmlize(cSimpleXMLStream);
        Iterator<CProjectImpl> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next().xmlize(cSimpleXMLStream);
        }
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public static DefaultListModel getTasksListModel() {
        DefaultListModel<CTaskImpl> defaultListModel = new DefaultListModel<CTaskImpl>();
        Iterator<CProjectImpl> iterator = s_oInstance.iterator();
        CProjectImpl cProjectImpl = null;
        CTaskImpl cTaskImpl = null;
        while (iterator.hasNext()) {
            cProjectImpl = iterator.next();
            Iterator<CTaskImpl> iterator2 = cProjectImpl.getTaskIterator();
            while (iterator2.hasNext()) {
                cTaskImpl = iterator2.next();
                defaultListModel.addElement(cTaskImpl);
            }
        }
        return defaultListModel;
    }

    @Deprecated
    public static void updateTasksListModel(DefaultListModel defaultListModel, AFilter aFilter) {
        if (aFilter instanceof AFilter.CCategoriesInTreeFilter) {
            AFilter.CCategoriesInTreeFilter cCategoriesInTreeFilter = (AFilter.CCategoriesInTreeFilter)aFilter;
            Vector<Object> vector = new Vector<Object>();
            Vector<CTaskImpl> vector2 = new Vector<CTaskImpl>();
            Iterator<CProjectImpl> iterator = cCategoriesInTreeFilter.getProjectIterator();
            while (iterator.hasNext()) {
                vector2.clear();
                CProjectImpl cProjectImpl = iterator.next();
                Iterator<CTaskImpl> iterator2 = cProjectImpl.getTaskIterator();
                while (iterator2.hasNext()) {
                    vector2.add(iterator2.next());
                }
                Collections.sort(vector2);
                Iterator iterator3 = vector2.iterator();
                while (iterator3.hasNext()) {
                    vector.addElement(iterator3.next());
                }
            }
            ProjectList._updateListModel(defaultListModel, vector);
        } else {
            defaultListModel.removeAllElements();
        }
    }

    @Deprecated
    public static void updateCategoriesListModel(DefaultListModel defaultListModel, AFilter aFilter) {
        if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            int n;
            AFilter.CTasksInTreeFilter cTasksInTreeFilter = (AFilter.CTasksInTreeFilter)aFilter;
            Vector<Object> vector = new Vector<Object>();
            boolean[] blArray = new boolean[CategoryList.getCategoryCount()];
            Iterator<CTaskImpl> iterator = cTasksInTreeFilter.getTaskIterator();
            while (iterator.hasNext()) {
                boolean[] blArray2 = iterator.next().getStatistic().getUsedCategories();
                for (n = 0; n < blArray.length; ++n) {
                    blArray[n] = blArray[n] || blArray2[n];
                }
            }
            int n2 = CategoryList.getCategoryCount();
            for (n = 0; n < n2; ++n) {
                if (!blArray[n]) continue;
                vector.addElement(CategoryList.getCategory(n));
            }
            ProjectList._updateListModel(defaultListModel, vector);
        } else {
            defaultListModel.removeAllElements();
        }
    }

    @Deprecated
    public static void updatePersonsListModel(DefaultListModel defaultListModel, AFilter aFilter) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        if (aFilter instanceof AFilter.CTasksInTreeFilter) {
            AFilter.CTasksInTreeFilter cTasksInTreeFilter = (AFilter.CTasksInTreeFilter)aFilter;
            Iterator<CTaskImpl> iterator = cTasksInTreeFilter.getTaskIterator();
            while (iterator.hasNext()) {
                CTaskImpl cTaskImpl = iterator.next();
                Iterator<CPersonImpl> iterator2 = cTaskImpl.getStatistic().getContainedPersons();
                while (iterator2.hasNext()) {
                    treeSet.add(iterator2.next());
                }
            }
        } else if (aFilter instanceof AFilter.CCategoriesInTreeFilter) {
            AFilter.CCategoriesInTreeFilter cCategoriesInTreeFilter = (AFilter.CCategoriesInTreeFilter)aFilter;
            Iterator<CProjectImpl> iterator = cCategoriesInTreeFilter.getProjectIterator();
            while (iterator.hasNext()) {
                CProjectImpl cProjectImpl = iterator.next();
                Iterator<CPersonImpl> iterator3 = cProjectImpl.getStatistic().getContainedPersons();
                while (iterator3.hasNext()) {
                    treeSet.add(iterator3.next());
                }
            }
        }
        ProjectList._updateListModel(defaultListModel, treeSet);
    }

    private static void _updateListModel(DefaultListModel defaultListModel, Collection<Object> collection) {
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            if (collection.contains(defaultListModel.getElementAt(i))) continue;
            defaultListModel.removeElementAt(i);
        }
        for (Object object : collection) {
            if (defaultListModel.contains(object)) continue;
            defaultListModel.addElement(object);
        }
    }

    public static class CEffortTreeStoreContainer
    extends AXMLObjectContainer<CEffortTree> {
        private static final CEffortImpl.CEffortStoreContainer EFFORT_CONTAINER = new CEffortImpl.CEffortStoreContainer();

        @Override
        protected CEffortTree createContainedObject(Attributes attributes, int n) {
            return new CEffortTree();
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("effort")) {
                return EFFORT_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals("effort")) {
                ((CEffortTree)this.getContainedObject()).add((CEffortImpl)object);
            }
        }
    }

    public static class CProjectListStoreContainer
    extends AXMLObjectContainer<ProjectList> {
        private static final CProjectImpl.CProjectStoreContainer PROJECT_CONTAINER = new CProjectImpl.CProjectStoreContainer();
        private static final CStatistic.CStatisticStoreContainer STATISTIC_CONTAINER = new CStatistic.CStatisticStoreContainer();

        @Override
        protected ProjectList createContainedObject(Attributes attributes, int n) {
            int n2 = Integer.parseInt(attributes.getValue(ProjectList.XML_ATT_PROJECT_COUNT));
            ProjectList.createInstance(n2);
            return ProjectList.getInstance();
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("statistic")) {
                return STATISTIC_CONTAINER;
            }
            if (string.equals("project")) {
                return PROJECT_CONTAINER;
            }
            return null;
        }

        @Override
        protected void childContainerCompleted(String string, Object object, int n) {
            if (string.equals("statistic")) {
                ((ProjectList)this.getContainedObject()).m_oStatistic = (CStatistic)object;
            }
            if (string.equals("project")) {
                ((ProjectList)this.getContainedObject()).addProject((CProjectImpl)object, false);
            }
        }

        @Override
        protected void completeContainedObject(int n) {
            ProjectList projectList = ProjectList.getInstance();
            int n2 = 0;
            for (Object object : projectList) {
                n2 += ((CProjectImpl)object).getStatistic().getFieldValue(0);
            }
            if (projectList.getStatistic().getFieldValue(0) != n2) {
                CStatistic cStatistic = new CStatistic(null);
                for (CProjectImpl cProjectImpl : projectList) {
                    cStatistic.addStatistic(cProjectImpl.getStatistic());
                    cProjectImpl.getStatistic().setParentStatistic(cStatistic);
                }
                projectList.m_oStatistic = cStatistic;
            }
        }
    }
}

