/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.ixml.common.CommonsVersionInfo;
import com.mayastudios.ixml.misc.IxmlVersionInfo;
import com.mayastudios.ixml.misc.LabelsVersionInfo;
import com.mayastudios.mscl.MsclVersionInfo;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mayastudios.mscl.mwt.trayicon.TrayIconInfo;

public class FredInfo {
    public static final String PROGRAMM_NAME = "Fred 2009";
    public static final String[] COPYRIGHTS = new String[]{"Copyright \u00a9 2006  SoPra 2006 Group 5 - University of Stuttgart", "Copyright \u00a9 2006-2009  Sebastian Krysmanski, Christoph M\u00fcller"};
    public static final String ADDITIONAL_CONTRIBUTERS = "Wolfgang Bischoff (long gone team member), Julien Boucachard (French translation)";
    public static final String VERSION_NUMBER = PackageVersionInfo._VERSION;
    public static final String REVISION_NUMBER = PackageVersionInfo._REVISION;
    public static final Calendar REVISION_DATE = PackageVersionInfo._REVISION_DATE;
    public static final Calendar BUILD_DATE = PackageVersionInfo._BUILD_DATE;
    public static final String HOMEPAGE = "http://fred.mayastudios.com";
    public static final String BUGTRACKER_URL = "http://fred.mayastudios.com/bugtracking/";
    public static final CExternalPackageInfo TRAY_ICON_INFO = new CExternalPackageInfo("JDIC Tray-Icon", TrayIconInfo.getVersionString());
    public static final CExternalPackageInfo BROWSER_LAUNCHER_INFO = new CExternalPackageInfo("BrowserLauncher2", "1.3");
    public static final CExternalPackageInfo MSCL4J_INFO = new CExternalPackageInfo("MSCL4j", "Rev." + MsclVersionInfo.LIBRARY_REVISION);
    public static final CExternalPackageInfo IXML_INFO = new CExternalPackageInfo("InterfaceXML", String.format("Commons Rev. %d / Labels Rev. %d / IXML Rev. %d", CommonsVersionInfo.LIBRARY_REVISION, LabelsVersionInfo.LIBRARY_REVISION, IxmlVersionInfo.LIBRARY_REVISION));

    public static enum VersionControlSystem {
        None("none"),
        CVS("cvs"),
        Subversion("svn"),
        Mercurial("hg"),
        Git("git"),
        Bazaar("bzr"),
        UnknownVCS("");

        private final String m_propName;

        private VersionControlSystem(String string2) {
            this.m_propName = string2;
        }

        public String getPropName() {
            return this.m_propName;
        }
    }

    private static final class PackageVersionInfo {
        public static final String _VERSION;
        public static final Calendar _BUILD_DATE;
        public static final String _BUILD_DATE_STRING;
        public static final VersionControlSystem _VERSION_CONTROL_SYSTEM;
        public static final String _REVISION;
        public static final Calendar _REVISION_DATE;
        public static final String _REVISION_DATE_STRING;
        private static final String VERSION_PROPERTIES_FILENAME = "version.properties";
        private static final Pattern DATE_PATTERN;

        private PackageVersionInfo() {
        }

        private static VersionControlSystem parseVCS(String string) {
            if (string == null) {
                return VersionControlSystem.UnknownVCS;
            }
            for (VersionControlSystem versionControlSystem : VersionControlSystem.values()) {
                if (!versionControlSystem.getPropName().equals(string)) continue;
                return versionControlSystem;
            }
            return VersionControlSystem.UnknownVCS;
        }

        private static Calendar parseDate(String string) {
            if (string == null) {
                return null;
            }
            Matcher matcher = DATE_PATTERN.matcher(string);
            if (!matcher.matches()) {
                return null;
            }
            try {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)));
                gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT" + matcher.group(7)));
                return gregorianCalendar;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        static {
            DATE_PATTERN = Pattern.compile("[ ]*(\\d{4})-(\\d{2})-(\\d{2}) (\\d{2}):(\\d{2}):(\\d{2}) ([+-]\\d{4})[ ]*");
            Properties properties = new Properties();
            URL uRL = PackageVersionInfo.class.getResource(VERSION_PROPERTIES_FILENAME);
            if (uRL != null) {
                try {
                    properties.load(uRL.openStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 3);
            _VERSION = properties.getProperty("version", "");
            _BUILD_DATE = PackageVersionInfo.parseDate(properties.getProperty("build-date"));
            _BUILD_DATE_STRING = _BUILD_DATE != null ? dateFormat.format(_BUILD_DATE.getTime()) : "";
            _VERSION_CONTROL_SYSTEM = PackageVersionInfo.parseVCS(properties.getProperty("vcs"));
            _REVISION = properties.getProperty("revision", "");
            _REVISION_DATE = PackageVersionInfo.parseDate(properties.getProperty("revision-date"));
            _REVISION_DATE_STRING = _REVISION_DATE != null ? dateFormat.format(_REVISION_DATE.getTime()) : "";
        }
    }

    public static class CExternalPackageInfo {
        private final String m_name;
        private final String m_version;

        public CExternalPackageInfo(String string, String string2) {
            this.m_name = string;
            this.m_version = string2;
        }

        public String getName() {
            return this.m_name;
        }

        public String getVersion() {
            return this.m_version;
        }
    }
}

