/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources.configfile;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;

public class ConfigFile
implements Iterable<String> {
    protected final Properties m_settings = new Properties();

    public String getAsString(String string) {
        return this.getAsString(string, true);
    }

    public String getAsString(String string, boolean bl) {
        String string2 = this.m_settings.getProperty(string);
        if (!bl && string2 == null) {
            return "";
        }
        return string2;
    }

    public String set(String string, String string2) {
        if (string2 == null) {
            return (String)this.m_settings.remove(string);
        }
        return (String)this.m_settings.setProperty(string, string2);
    }

    public long getLong(String string) {
        return Long.parseLong(this.getAsString(string, false));
    }

    public void set(String string, long l) {
        this.set(string, Long.toString(l));
    }

    public boolean getAsBoolean(String string) {
        return Boolean.parseBoolean(this.getAsString(string, false));
    }

    public void set(String string, boolean bl) {
        this.set(string, Boolean.toString(bl));
    }

    public int size() {
        return this.m_settings.size();
    }

    @Override
    public Iterator<String> iterator() {
        return new SettingsIterator(this.m_settings);
    }

    private static class SettingsIterator
    implements Iterator<String> {
        private final Enumeration<Object> m_enumeration;

        public SettingsIterator(Properties properties) {
            this.m_enumeration = properties.keys();
        }

        @Override
        public boolean hasNext() {
            return this.m_enumeration.hasMoreElements();
        }

        @Override
        public String next() {
            return (String)this.m_enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

