/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.controller.CommandController;
import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.view.CMenuBar;
import com.mayastudios.fred.client.view.CStartScreen;
import com.mayastudios.fred.client.view.CView;
import com.mayastudios.fred.client.view.CViewContainer;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.dockpane.ADockableTab;
import com.mayastudios.mscl.mwt.dockpane.ATabPanel;
import com.mayastudios.mscl.mwt.dockpane.CDockableTab;
import com.mayastudios.mscl.mwt.dockpane.ITabStateListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public class CMainWindow
extends JFrame {
    public static final int DEFAULT_WIDTH = 1010;
    public static final int DEFAULT_HEIGHT = 650;
    public static final ImageIcon MAIN_ICON;
    private CViewContainer m_oViewContainer = new CViewContainer(this);
    private CStartScreen m_oStartScreen = new CStartScreen();
    private EWindowContent m_eWindowContent = null;
    private final CMenuBar mf_oMenuBar;

    public CMainWindow() {
        Container container = super.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)((Object)this.m_oStartScreen), "Center");
        try {
            this.mf_oMenuBar = CommandController.createMenuBar();
            this.setJMenuBar((JMenuBar)((Object)this.mf_oMenuBar));
        }
        catch (Exception exception) {
            throw new RuntimeException("The menu bar could not be loaded!", exception);
        }
        MainController.getInstance().addObserver(this.mf_oMenuBar);
        MainController.getInstance().addObserver(this.m_oViewContainer.getToolbar());
        GUIHelper.setApplicationIcon((JFrame)this, (ImageIcon)MAIN_ICON);
        MainController.getInstance().prepareSplashScreenClose(this);
        GUIHelper.initWindow((Window)this, (String)"Fred 2009", (int)1010, (int)650, (boolean)true, (boolean)true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width <= 1010 && dimension.height <= 650) {
            this.setExtendedState(6);
        }
    }

    public EWindowContent getContent() {
        return this.m_eWindowContent;
    }

    public void setContent(EWindowContent eWindowContent) {
        if (this.m_eWindowContent == eWindowContent) {
            return;
        }
        this.m_eWindowContent = eWindowContent;
        if (this.m_eWindowContent == EWindowContent.StartScreen) {
            this.m_oViewContainer.disablePane();
            this.m_oViewContainer.closeAllTabs();
        } else if (this.m_eWindowContent == EWindowContent.Views) {
            this.m_oViewContainer.enablePane();
        }
    }

    public void addView(CView cView, String string) {
        CDockableTab cDockableTab = new CDockableTab((ATabPanel)cView, null, string, null, cView.getToolbar());
        cDockableTab.setStateListener((ITabStateListener)cView.getViewController());
        this.m_oViewContainer.addTab((ADockableTab)cDockableTab);
    }

    public void removeView(CView cView) {
        cView.getAssociatedTab().closeTab();
    }

    public final CMenuBar getCMenuBar() {
        return this.mf_oMenuBar;
    }

    public final CViewContainer getViewContainer() {
        return this.m_oViewContainer;
    }

    public CView getCurrentView() {
        if (this.m_eWindowContent == EWindowContent.Views) {
            return this.m_oViewContainer.getCurrentView();
        }
        return null;
    }

    static {
        try {
            switch (SystemInfo.OSTYPE) {
                case Windows: {
                    MAIN_ICON = MainController.getResLoader().getIconExcpt("images/fred-main-icon-16x16.png");
                    break;
                }
                case Linux: 
                case Solaris: {
                    MAIN_ICON = MainController.getResLoader().getIconExcpt("images/fred-main-icon-24x24.png");
                    break;
                }
                default: {
                    MAIN_ICON = MainController.getResLoader().getIconExcpt("images/fred-main-icon-big.png");
                    break;
                }
            }
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            throw new ExceptionInInitializerError(resourceLoadException);
        }
    }

    public static enum EWindowContent {
        StartScreen,
        Views;

    }
}

