/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.DefaultTask;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.FredMessageBox;
import com.mayastudios.fred.client.view.dialogs.effort.CDlgEffortEditEffort;
import com.mayastudios.fred.client.view.dialogs.quickbar.CDlgQuickbarReallocate;
import com.mayastudios.ixml.common.BaseEventManager;
import com.mayastudios.ixml.labels.LString;
import com.mayastudios.ixml.labels.LabelsCore;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.grafics.GrafixFactory;
import com.mayastudios.mscl.mwt.CClockTimer;
import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.widgets.APaintHelperPanel;
import com.mayastudios.mscl.mwt.widgets.DockedWindow;
import com.mayastudios.mscl.mwt.widgets.button.CButtonEvent;
import com.mayastudios.mscl.mwt.widgets.button.CFramelessButton;
import com.mayastudios.mscl.mwt.widgets.button.IButtonListener;
import com.mayastudios.systeminfo.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Calendar;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class QuickBar
extends DockedWindow {
    private static final Dimension VISIBLE_BORDER_SIZE = new Dimension(7, 3);
    private static final QuickBar INSTANCE = new QuickBar();
    private final CQuickbarContent mf_oQuickbarContent;
    private EState m_eState = EState.STOP;
    private Calendar m_oStartTime;
    private int m_iPauseStartTime = 0;
    private int m_iPauseDuration = 0;

    private QuickBar() {
        super((Component)((Object)new CQuickbarFrame(new CQuickbarContent())), DockedWindow.DockingBorder.TOP, VISIBLE_BORDER_SIZE);
        this.mf_oQuickbarContent = ((CQuickbarFrame)((Object)this.getContent())).getContent();
    }

    public static final QuickBar getInstance() {
        return INSTANCE;
    }

    public void startRecording() {
        if (this.m_eState == EState.WORK) {
            return;
        }
        if (this.m_eState == EState.STOP) {
            assert (this.m_oStartTime == null);
            this.m_oStartTime = Calendar.getInstance();
            this.m_iPauseDuration = 0;
        } else if (this.m_eState == EState.PAUSE) {
            assert (this.m_oStartTime != null);
            this.m_iPauseDuration = (int)((long)this.m_iPauseDuration + (Calendar.getInstance().getTimeInMillis() / 1000L - (long)this.m_iPauseStartTime));
        }
        this.m_iPauseStartTime = 0;
        this.m_eState = EState.WORK;
        this.mf_oQuickbarContent.setState(this.m_eState);
    }

    public void pauseRecording() {
        if (this.m_eState == EState.PAUSE || this.m_oStartTime == null) {
            return;
        }
        this.m_iPauseStartTime = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);
        this.m_eState = EState.PAUSE;
        this.mf_oQuickbarContent.setState(this.m_eState);
    }

    public boolean stopRecording(boolean bl) {
        return this._handleEffort(bl, false, false);
    }

    public boolean isRecording() {
        return this.m_eState != EState.STOP;
    }

    public boolean quickSplit(boolean bl) {
        return this._handleEffort(false, true, bl);
    }

    private boolean _discardUnsaveableEffort() {
        return FredMessageBox.showOptionDlg(Labels.get("INFORMATION_QUICKBAR_STOP", new Object[0]), Labels.get("TITLE_QUICKBAR_STOP", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO) != MessageBox.EButton.NO;
    }

    private boolean _handleEffort(boolean bl, boolean bl2, boolean bl3) {
        if (this.m_eState == EState.STOP) {
            return true;
        }
        if (!bl) {
            if (!DefaultTask.isSet()) {
                if (bl3) {
                    return false;
                }
                if (!this._discardUnsaveableEffort()) {
                    return false;
                }
            } else {
                CEffortImpl cEffortImpl = CEffortImpl.create();
                cEffortImpl.setBegin(this.m_oStartTime);
                int n = QuickBar.calcPauseDuration(this.m_iPauseStartTime, this.m_iPauseDuration);
                int n2 = QuickBar.calcWorkDuration(this.m_oStartTime, n);
                cEffortImpl.setDuration(n2 / 60);
                cEffortImpl.setPauseDuration(n / 60);
                if (bl2) {
                    ProjectList.getInstance().addEffort(cEffortImpl);
                    if (bl3) {
                        return true;
                    }
                    MainController.getInstance().notifyControllers(MainController.EUpdateMessage.EffortsCreated, Collections.singleton(cEffortImpl));
                } else {
                    this.mf_oQuickbarContent.setState(EState.STOP);
                    CDlgEffortEditEffort cDlgEffortEditEffort = new CDlgEffortEditEffort(cEffortImpl, true, true);
                    switch (cDlgEffortEditEffort.showDialog()) {
                        case OK: {
                            cEffortImpl.setTask(cDlgEffortEditEffort.getNewTask());
                            cEffortImpl.setBegin(cDlgEffortEditEffort.getBegin());
                            cEffortImpl.setDuration(cDlgEffortEditEffort.getWorkDuration());
                            cEffortImpl.setPauseDuration(cDlgEffortEditEffort.getPauseDuration());
                            ProjectList.getInstance().addEffort(cEffortImpl);
                            MainController.getInstance().notifyControllers(MainController.EUpdateMessage.EffortsCreated, Collections.singleton(cEffortImpl));
                            break;
                        }
                        case CANCEL: {
                            this.mf_oQuickbarContent.setState(this.m_eState);
                            return false;
                        }
                    }
                }
            }
        }
        this.m_oStartTime = null;
        this.m_eState = EState.STOP;
        this.mf_oQuickbarContent.setState(this.m_eState);
        this.mf_oQuickbarContent.clearData();
        if (bl2 && DefaultTask.isSet()) {
            this.startRecording();
        }
        return true;
    }

    public int getCurrentWorkDuration() {
        if (this.m_oStartTime == null) {
            return 0;
        }
        return QuickBar.calcWorkDuration(this.m_oStartTime, this.getCurrentPauseDuration());
    }

    public int getCurrentPauseDuration() {
        if (this.m_oStartTime == null) {
            return 0;
        }
        return QuickBar.calcPauseDuration(this.m_iPauseStartTime, this.m_iPauseDuration);
    }

    public static int calcWorkDuration(Calendar calendar, int n) {
        return (int)((Calendar.getInstance().getTimeInMillis() - calendar.getTimeInMillis()) / 1000L) - n;
    }

    public static int calcPauseDuration(int n, int n2) {
        if (n != 0) {
            n2 += (int)(Calendar.getInstance().getTimeInMillis() / 1000L) - n;
        }
        return n2;
    }

    private static class CQuickbarContent
    extends APaintHelperPanel
    implements IButtonListener,
    ActionListener {
        private static final BufferedImage QUICKBAR_IMAGE;
        private static final ImageIcon BUTTON_START;
        private static final ImageIcon BUTTON_PAUSE;
        private static final ImageIcon BUTTON_STOP;
        private static final ImageIcon BUTTON_CUT;
        private static final ImageIcon BUTTON_REALLOCATE;
        private static final ImageIcon BUTTON_MAINWINDOW;
        private static final ImageIcon INDICATOR_WORK;
        private static final ImageIcon INDICATOR_PAUSE;
        private static final ImageIcon INDICATOR_STOP;
        private static final Point INDICATOR_POS;
        private static final Point START_PAUSE_POS;
        private static final Point STOP_POS;
        private static final Point CUT_POS;
        private static final Point RESPLIT_POS;
        private static final Point MAINWND_POS;
        private static final Dimension START_PAUSE_DIM;
        private static final Dimension STOP_DIM;
        private static final Dimension CUT_DIM;
        private static final Dimension RESPLIT_DIM;
        private static final Dimension MAINWND_DIM;
        private static final Font DURATION_FONT;
        private static final Point WORK_TEXT_POS;
        private static final Point BREAK_TEXT_POS;
        private static final Dimension MAX_TEXT_SIZE;
        private final CFramelessButtonEx mf_oStartButton;
        private final CFramelessButtonEx mf_oPauseButton;
        private final CFramelessButtonEx mf_oStopButton;
        private final CFramelessButtonEx mf_oCutButton;
        private final CFramelessButtonEx mf_oResplitButton;
        private final CFramelessButtonEx mf_oMainWndButton;
        private EState m_eState = null;
        private final JLabel mf_oIndicator = new JLabel();
        private final CClockTimer mf_oDurationTimer = new CClockTimer((ActionListener)this);
        private long m_lCurDuration = 0L;
        private long m_lCurPauseDuration = 0L;

        CQuickbarContent() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(QUICKBAR_IMAGE.getWidth(), QUICKBAR_IMAGE.getHeight()));
            this.setFont(DURATION_FONT);
            this.mf_oStartButton = this._initButton(BUTTON_START, START_PAUSE_DIM, START_PAUSE_POS, "Quickbar.Start");
            this.mf_oPauseButton = this._initButton(BUTTON_PAUSE, START_PAUSE_DIM, START_PAUSE_POS, "Quickbar.Pause");
            this.mf_oStopButton = this._initButton(BUTTON_STOP, STOP_DIM, STOP_POS, "Quickbar.Stop");
            this.mf_oCutButton = this._initButton(BUTTON_CUT, CUT_DIM, CUT_POS, "Quickbar.Quicksplit");
            this.mf_oResplitButton = this._initButton(BUTTON_REALLOCATE, RESPLIT_DIM, RESPLIT_POS, "Quickbar.Reallocate");
            this.mf_oMainWndButton = this._initButton(BUTTON_MAINWINDOW, MAINWND_DIM, MAINWND_POS, "Quickbar.MainWnd");
            this.mf_oIndicator.setBounds(CQuickbarContent.INDICATOR_POS.x, CQuickbarContent.INDICATOR_POS.y, INDICATOR_WORK.getIconWidth(), INDICATOR_WORK.getIconHeight());
            this.add(this.mf_oIndicator);
            this.setState(EState.STOP);
        }

        void setState(EState eState) {
            if (eState == this.m_eState) {
                return;
            }
            this.m_eState = eState;
            if (this.m_eState == EState.STOP) {
                this.mf_oDurationTimer.stop();
            } else {
                this.mf_oDurationTimer.start();
            }
            switch (this.m_eState) {
                case WORK: {
                    this.mf_oIndicator.setIcon(INDICATOR_WORK);
                    this.mf_oStartButton.setVisible(false);
                    this.mf_oPauseButton.setVisible(true);
                    this.mf_oStopButton.setEnabled(true);
                    this.mf_oCutButton.setEnabled(true);
                    this.mf_oResplitButton.setEnabled(true);
                    break;
                }
                case PAUSE: {
                    this.mf_oIndicator.setIcon(INDICATOR_PAUSE);
                    this.mf_oStartButton.setVisible(true);
                    this.mf_oPauseButton.setVisible(false);
                    this.mf_oStopButton.setEnabled(true);
                    this.mf_oCutButton.setEnabled(true);
                    this.mf_oResplitButton.setEnabled(true);
                    break;
                }
                case STOP: {
                    this.mf_oIndicator.setIcon(INDICATOR_STOP);
                    this.mf_oStartButton.setVisible(true);
                    this.mf_oPauseButton.setVisible(false);
                    this.mf_oStopButton.setEnabled(false);
                    this.mf_oCutButton.setEnabled(false);
                    this.mf_oResplitButton.setEnabled(false);
                }
            }
            this.repaint();
        }

        void clearData() {
            this.m_lCurDuration = 0L;
            this.m_lCurPauseDuration = 0L;
            this._repaintCounter();
        }

        protected void paintComponent(Graphics2D graphics2D) {
            graphics2D.drawImage((Image)QUICKBAR_IMAGE, 0, 0, (ImageObserver)((Object)this));
            if (this.m_eState != EState.STOP) {
                this.m_lCurDuration = QuickBar.getInstance().getCurrentWorkDuration();
                this.m_lCurPauseDuration = QuickBar.getInstance().getCurrentPauseDuration();
            }
            String string = String.format("%2d:%02d:%02d", this.m_lCurDuration / 3600L, this.m_lCurDuration % 3600L / 60L, this.m_lCurDuration % 60L);
            String string2 = String.format("%2d:%02d:%02d", this.m_lCurPauseDuration / 3600L, this.m_lCurPauseDuration % 3600L / 60L, this.m_lCurPauseDuration % 60L);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.drawString(string, CQuickbarContent.WORK_TEXT_POS.x, CQuickbarContent.WORK_TEXT_POS.y);
            graphics2D.drawString(string2, CQuickbarContent.BREAK_TEXT_POS.x, CQuickbarContent.BREAK_TEXT_POS.y);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._repaintCounter();
        }

        private boolean isDesktopLocked() {
            if (SystemInfo.OSTYPE == SystemInfo.OperatationSystemType.Windows) {
                return MouseInfo.getPointerInfo() == null;
            }
            return false;
        }

        public void buttonActionPerformed(CButtonEvent cButtonEvent) {
            if (cButtonEvent.getSource() == this.mf_oStartButton) {
                QuickBar.getInstance().startRecording();
            } else if (cButtonEvent.getSource() == this.mf_oPauseButton) {
                QuickBar.getInstance().pauseRecording();
            }
            if (cButtonEvent.getSource() == this.mf_oStopButton) {
                QuickBar.getInstance().stopRecording(false);
            }
            if (cButtonEvent.getSource() == this.mf_oCutButton) {
                if (WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.ConfirmQuickSplit)) {
                    if (FredMessageBox.showOptionDlg(Labels.get("OPTION_QUICKBAR_QUICKSPLIT", new Object[0]), Labels.get("TITLE_QUICKBAR_QUICKSPLIT", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO) == MessageBox.EButton.YES) {
                        QuickBar.getInstance().quickSplit(false);
                    }
                } else {
                    QuickBar.getInstance().quickSplit(false);
                }
            } else if (cButtonEvent.getSource() == this.mf_oResplitButton) {
                QuickBar quickBar = QuickBar.getInstance();
                int n = QuickBar.calcPauseDuration(quickBar.m_iPauseStartTime, quickBar.m_iPauseDuration);
                CDlgQuickbarReallocate cDlgQuickbarReallocate = new CDlgQuickbarReallocate(this.m_eState == EState.WORK, QuickBar.getInstance().m_oStartTime, n);
                if (cDlgQuickbarReallocate.showDialog() == ADialogEx.EReturnValue.OK) {
                    quickBar.m_iPauseDuration = cDlgQuickbarReallocate.getPauseDuration();
                    quickBar.m_oStartTime = cDlgQuickbarReallocate.getStartTime();
                    if (quickBar.m_iPauseStartTime > 0) {
                        quickBar.m_iPauseStartTime = (int)(Calendar.getInstance().getTimeInMillis() / 1000L);
                    }
                    this._repaintCounter();
                }
            } else if (cButtonEvent.getSource() == this.mf_oMainWndButton) {
                MainController.bringMainWindowToFront();
            }
        }

        private void _repaintCounter() {
            this.repaint(CQuickbarContent.WORK_TEXT_POS.x, 0, CQuickbarContent.MAX_TEXT_SIZE.width, CQuickbarContent.MAX_TEXT_SIZE.height);
        }

        private CFramelessButtonEx _initButton(ImageIcon imageIcon, Dimension dimension, Point point, String string) {
            CFramelessButtonEx cFramelessButtonEx = new CFramelessButtonEx(imageIcon, 35, string);
            cFramelessButtonEx.addButtonListener(this, BaseEventManager.ERefType.REGULAR);
            cFramelessButtonEx.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.add((Component)((Object)cFramelessButtonEx));
            return cFramelessButtonEx;
        }

        static {
            INDICATOR_POS = new Point(181, 13);
            START_PAUSE_POS = new Point(6, 4);
            STOP_POS = new Point(53, 4);
            CUT_POS = new Point(88, 4);
            RESPLIT_POS = new Point(117, 4);
            MAINWND_POS = new Point(346, 0);
            START_PAUSE_DIM = new Dimension(44, 19);
            STOP_DIM = new Dimension(26, 19);
            CUT_DIM = new Dimension(26, 19);
            RESPLIT_DIM = new Dimension(26, 19);
            MAINWND_DIM = new Dimension(24, 27);
            DURATION_FONT = new Font("Dialog", 1, 10);
            WORK_TEXT_POS = new Point(231, 18);
            BREAK_TEXT_POS = new Point(297, 18);
            try {
                QUICKBAR_IMAGE = MainController.getResLoader().getBufferedImageExcpt("images/quickbar.png");
                BUTTON_START = MainController.getResLoader().getIconExcpt("images/quickbar-button-start.png");
                BUTTON_PAUSE = MainController.getResLoader().getIconExcpt("images/quickbar-button-pause.png");
                BUTTON_STOP = MainController.getResLoader().getIconExcpt("images/quickbar-button-stop.png");
                BUTTON_CUT = MainController.getResLoader().getIconExcpt("images/quickbar-button-cut.png");
                BUTTON_REALLOCATE = MainController.getResLoader().getIconExcpt("images/quickbar-button-reallocate.png");
                INDICATOR_WORK = MainController.getResLoader().getIconExcpt("images/quickbar-indicator-work.gif");
                INDICATOR_PAUSE = MainController.getResLoader().getIconExcpt("images/quickbar-indicator-pause.gif");
                INDICATOR_STOP = MainController.getResLoader().getIconExcpt("images/quickbar-indicator-stop.gif");
                BUTTON_MAINWINDOW = MainController.getResLoader().getIconExcpt("images/quickbar-button-mainwnd.png");
            }
            catch (ResourceLoader.ResourceLoadException resourceLoadException) {
                throw new ExceptionInInitializerError(resourceLoadException);
            }
            MAX_TEXT_SIZE = new Dimension(QUICKBAR_IMAGE.getWidth() - CQuickbarContent.WORK_TEXT_POS.x, QUICKBAR_IMAGE.getHeight());
        }

        private static class CFramelessButtonEx
        extends CFramelessButton
        implements LabelsCore.ILabelsChangeListener {
            private final LString mf_oTooltipLabel;

            public CFramelessButtonEx(ImageIcon imageIcon, int n, String string) {
                super(imageIcon, n);
                this.mf_oTooltipLabel = Labels.getLS(string);
                this.labelsChanged(false);
                LabelsCore.addLabelsChangeListener((LabelsCore.ILabelsChangeListener)this, (BaseEventManager.ERefType)BaseEventManager.ERefType.WEAK);
            }

            @Deprecated
            public void setToolTipText(String string) {
                super.setToolTipText(string);
            }

            public void labelsChanged(boolean bl) {
                super.setToolTipText(this.mf_oTooltipLabel.toString());
            }
        }
    }

    private static class CQuickbarFrame
    extends APaintHelperPanel {
        private static final int GRIPPER_VERT_COUNT = 7;
        private static final int GRIPPER_HORZ_COUNT = 3;
        private static final int PADDING = 2;
        private static final Color GRADIENT_UPPER_COLOR = new Color(238, 238, 238);
        private static final Color GRADIENT_LOWER_COLOR = new Color(208, 208, 208);
        BufferedImage m_oComponentImage;
        CQuickbarContent m_oContent;

        CQuickbarFrame(CQuickbarContent cQuickbarContent) {
            this.m_oContent = cQuickbarContent;
            this.setLayout(null);
            this.add((Component)((Object)this.m_oContent));
            this._init();
        }

        CQuickbarContent getContent() {
            return this.m_oContent;
        }

        protected void paintComponent(Graphics2D graphics2D) {
            graphics2D.drawImage((Image)this.m_oComponentImage, 0, 0, (ImageObserver)((Object)this));
        }

        private void _init() {
            Graphics2D graphics2D = null;
            BufferedImage bufferedImage = CQuickbarFrame._createGripperImage();
            Dimension dimension = this.m_oContent.getPreferredSize();
            Rectangle rectangle = new Rectangle(dimension);
            Dimension dimension2 = new Dimension(dimension);
            dimension2.width += 6 + bufferedImage.getWidth() + 4;
            dimension2.height += 8;
            this.setPreferredSize(dimension2);
            this.m_oComponentImage = new BufferedImage(dimension2.width, dimension2.height, 1);
            graphics2D = (Graphics2D)this.m_oComponentImage.getGraphics();
            GrafixFactory.paintFlatButtonBorder((Graphics2D)graphics2D, (Rectangle)new Rectangle(dimension2), (boolean)true);
            graphics2D.setPaint(new GradientPaint(0.0f, 1.0f, GRADIENT_UPPER_COLOR, 0.0f, dimension2.height - 1, GRADIENT_LOWER_COLOR));
            graphics2D.fillRect(1, 1, dimension2.width - 2, dimension2.height - 2);
            graphics2D.drawImage((Image)bufferedImage, 3, 3, (ImageObserver)((Object)this));
            rectangle.x = 6 + bufferedImage.getWidth();
            rectangle.y = 4;
            this.m_oContent.setBounds(rectangle);
            rectangle.grow(1, 1);
            GrafixFactory.paintFlatButtonBorder((Graphics2D)graphics2D, (Rectangle)rectangle, (boolean)false);
        }

        private static BufferedImage _createGripperImage() {
            int n = GrafixFactory.GRIPPER_POINT_SIZE.width + 1;
            int n2 = GrafixFactory.GRIPPER_POINT_SIZE.height + 1;
            BufferedImage bufferedImage = new BufferedImage(n * 3, n2 * 7 + 1, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            for (int i = 0; i < 3; ++i) {
                int n3 = i % 2 * 2;
                for (int j = 0; j < 7; ++j) {
                    GrafixFactory.paintGripperPoint((Graphics2D)graphics2D, (int)(i * n), (int)n3);
                    n3 += n2;
                }
            }
            return bufferedImage;
        }
    }

    public static enum EState {
        WORK,
        PAUSE,
        STOP;

    }
}

