/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.textfields.CDateTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CNonEmptyTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CTimeDurationTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CTimeTextfield;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.ResourceLoaderInstance;
import com.mayastudios.mscl.mwt.GUIHelper;
import com.mayastudios.mscl.mwt.widgets.inputcontols.CTextFieldEx;
import com.mayastudios.mscl.mwt.windowcloser.CWindowCloser;
import com.mayastudios.mscl.mwt.windowcloser.IWindowCloseListener;
import de.wb.control.IValidable;
import de.wb.view.CNonEmptyList;
import de.wb.view.CSelectedList;
import de.wb.view.CURLComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ADialog
extends JDialog {
    private static final String DEFAULT_ERROR_MESSAGE = Labels.get("INVALID_INPUT_NOTIFICATION", new Object[0]);
    public static final Logger LOGGER = LoggerFactory.getLogger(ADialog.class);
    protected boolean m_bSuccessful = false;
    protected boolean m_bDialogContainsValidInput = false;
    private JPanel m_oBasePanel;
    private JPanel m_oContent;
    private JPanel m_oSouthPanel = null;
    private JPanel m_oErrorMessagePanel;
    private JPanel m_oButtonPanel = null;
    protected GridBagLayout m_oGBLayout;
    protected GridBagConstraints m_oGBConstraints;
    private JLabel m_oErrorMessageLabel;
    private final String m_sSubmitButtonText;
    private final String m_sCancelButtonText;
    private final String m_sDiscardButtonText;
    protected Vector<IValidable> m_oValidationList;

    public ADialog(JFrame jFrame, String string, String string2, String string3, String string4, EShowButtons eShowButtons, boolean bl, Dimension dimension) {
        this(jFrame, string, string2, string3, string4, eShowButtons, bl, dimension, true);
    }

    public ADialog(JFrame jFrame, String string, String string2, String string3, String string4, EShowButtons eShowButtons, boolean bl, Dimension dimension, boolean bl2) {
        super(jFrame, string, bl2);
        this.m_sSubmitButtonText = string3;
        this.m_sCancelButtonText = string4;
        this.m_sDiscardButtonText = Labels.get("BUTTON_DISCARD", new Object[0]);
        CWindowCloser.initObservation((Window)this, (IWindowCloseListener)new IWindowCloseListener(){

            public boolean windowClosingPerformed() {
                ADialog.this.incomingAbort();
                return false;
            }

            public boolean terminateApp() {
                return false;
            }

            public int getExitCode() {
                return 0;
            }
        });
        this._createDialog(string2, eShowButtons, bl, dimension);
        this.m_oValidationList = new Vector();
    }

    public void addToValidationList(IValidable iValidable) {
        this.m_oValidationList.add(iValidable);
    }

    public void removeFromValidationList(IValidable iValidable) {
        this.m_oValidationList.removeElement(iValidable);
    }

    protected IValidable.EErrorStatus evaluateValidationList(boolean bl, boolean bl2) {
        IValidable.EErrorStatus eErrorStatus = null;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < this.m_oValidationList.size(); ++i) {
            IValidable iValidable = this.m_oValidationList.elementAt(i);
            boolean bl5 = iValidable.evaluateContent();
            if (bl) {
                iValidable.highlightControl(!bl5);
            }
            if (bl5 || bl3) continue;
            IValidable.EErrorStatus eErrorStatus2 = iValidable.getErrorStatus();
            if (eErrorStatus2 == IValidable.EErrorStatus.UNSPECIFIC) {
                bl4 = true;
                continue;
            }
            if (bl2) {
                this.setErrorText(Labels.get(eErrorStatus2.name(), new Object[0]));
            }
            if (!bl) {
                return eErrorStatus2;
            }
            eErrorStatus = eErrorStatus2;
            bl3 = true;
        }
        if (!bl4 && !bl3) {
            if (bl2) {
                this.setErrorText(null);
            }
        } else if (bl4 && !bl3) {
            if (bl2) {
                this.setErrorText(DEFAULT_ERROR_MESSAGE);
            }
            eErrorStatus = IValidable.EErrorStatus.UNSPECIFIC;
        }
        return eErrorStatus;
    }

    private void _createDialog(String string, EShowButtons eShowButtons, boolean bl, Dimension dimension) {
        if (bl) {
            JPanel jPanel = new JPanel();
            TitledBorder titledBorder = null;
            titledBorder = BorderFactory.createTitledBorder(string);
            jPanel.setBorder(titledBorder);
            this.add((Component)jPanel, "Center");
            this.setBasePanel(jPanel);
        } else {
            this.setBasePanel((JPanel)this.getContentPane());
        }
        this.getBasePanel().setLayout(new BorderLayout());
        this.m_oContent = new JPanel();
        this.m_oContent.setLayout(null);
        this.getBasePanel().add((Component)this.m_oContent, "Center");
        this.setButtons(eShowButtons);
        GUIHelper.centerWindow((Window)this, (int)dimension.width, (int)dimension.height);
        this.setResizable(false);
    }

    protected void setButtons(EShowButtons eShowButtons) {
        switch (eShowButtons) {
            case OK: {
                if (this.m_oSouthPanel == null) {
                    this.m_oSouthPanel = new JPanel();
                    this.m_oGBLayout = new GridBagLayout();
                    this.m_oSouthPanel.setLayout(new BorderLayout());
                    this.m_oBasePanel.add((Component)this.m_oSouthPanel, "South");
                } else {
                    this.m_oSouthPanel.removeAll();
                }
                if (this.m_oButtonPanel == null) {
                    this.m_oButtonPanel = new JPanel();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add((Component)this.createSubmitButton(this.m_sSubmitButtonText), "East");
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                } else {
                    this.m_oButtonPanel.removeAll();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add(this.createSubmitButton(this.m_sSubmitButtonText));
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                }
                this.setErrorMessagePanel();
                break;
            }
            case CANCEL: {
                if (this.m_oSouthPanel == null) {
                    this.m_oSouthPanel = new JPanel();
                    this.m_oSouthPanel.setLayout(new BorderLayout());
                    this.m_oBasePanel.add((Component)this.m_oSouthPanel, "South");
                } else {
                    this.m_oSouthPanel.removeAll();
                }
                if (this.m_oButtonPanel == null) {
                    this.m_oButtonPanel = new JPanel();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add((Component)this.createCancelButton(this.m_sCancelButtonText), "East");
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                } else {
                    this.m_oButtonPanel.removeAll();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add(this.createCancelButton(this.m_sCancelButtonText));
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                }
                this.removeErrorMessagePanel();
                break;
            }
            case OKCANCEL: {
                if (this.m_oSouthPanel == null) {
                    this.m_oSouthPanel = new JPanel();
                    this.m_oSouthPanel.setLayout(new BorderLayout());
                    this.m_oBasePanel.add((Component)this.m_oSouthPanel, "South");
                } else {
                    this.m_oSouthPanel.removeAll();
                }
                if (this.m_oButtonPanel == null) {
                    this.m_oButtonPanel = new JPanel();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add(this.createSubmitButton(this.m_sSubmitButtonText));
                    this.m_oButtonPanel.add(this.createCancelButton(this.m_sCancelButtonText));
                    this.m_oSouthPanel.add(this.m_oButtonPanel);
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                } else {
                    this.m_oButtonPanel.removeAll();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add(this.createSubmitButton(this.m_sSubmitButtonText));
                    this.m_oButtonPanel.add(this.createCancelButton(this.m_sCancelButtonText));
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                }
                this.setErrorMessagePanel();
                break;
            }
            case OKCANCELDISCARD: {
                if (this.m_oSouthPanel == null) {
                    this.m_oSouthPanel = new JPanel();
                    this.m_oGBLayout = new GridBagLayout();
                    this.m_oSouthPanel.setLayout(new BorderLayout());
                    this.m_oBasePanel.add((Component)this.m_oSouthPanel, "South");
                } else {
                    this.m_oSouthPanel.removeAll();
                }
                if (this.m_oButtonPanel == null) {
                    this.m_oButtonPanel = new JPanel();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add(this.createSubmitButton(this.m_sSubmitButtonText));
                    this.m_oButtonPanel.add(this.createCancelButton(this.m_sCancelButtonText));
                    this.m_oButtonPanel.add(this.createDiscardButton(this.m_sDiscardButtonText));
                    this.m_oSouthPanel.add(this.m_oButtonPanel);
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                } else {
                    this.m_oButtonPanel.removeAll();
                    this.m_oButtonPanel.setLayout(new FlowLayout());
                    this.m_oButtonPanel.add(this.createSubmitButton(this.m_sSubmitButtonText));
                    this.m_oButtonPanel.add(this.createCancelButton(this.m_sCancelButtonText));
                    this.m_oButtonPanel.add(this.createDiscardButton(this.m_sDiscardButtonText));
                    this.m_oSouthPanel.add((Component)this.m_oButtonPanel, "East");
                }
                this.setErrorMessagePanel();
                break;
            }
            case NONE: {
                if (this.m_oSouthPanel == null) break;
                this.removeErrorMessagePanel();
                this.getBasePanel().remove(this.m_oSouthPanel);
                this.m_oSouthPanel = null;
                this.m_oButtonPanel = null;
                this.m_oErrorMessagePanel = null;
            }
        }
        this.repaint();
    }

    public void setErrorMessagePanel() {
        if (this.m_oErrorMessagePanel == null) {
            this.m_oErrorMessagePanel = new JPanel();
            this.m_oErrorMessageLabel = new JLabel();
            this.m_oErrorMessageLabel.setText("");
            this.m_oErrorMessageLabel.setVisible(true);
            this.m_oErrorMessageLabel.setHorizontalAlignment(0);
            this.m_oErrorMessageLabel.setForeground(Color.RED);
            this.m_oErrorMessagePanel.setPreferredSize(new Dimension(30, 30));
            this.m_oErrorMessagePanel.setLayout(new BorderLayout());
            this.m_oErrorMessagePanel.add((Component)this.m_oErrorMessageLabel, "Center");
            this.m_oSouthPanel.add((Component)this.m_oErrorMessagePanel, "North");
        } else {
            this.m_oSouthPanel.add((Component)this.m_oErrorMessagePanel, "North");
        }
    }

    public void removeErrorMessagePanel() {
        if (this.m_oSouthPanel == null) {
            return;
        }
        if (this.m_oErrorMessagePanel != null) {
            this.m_oSouthPanel.remove(this.m_oErrorMessagePanel);
            this.m_oErrorMessageLabel = null;
            this.m_oErrorMessagePanel = null;
            this.repaint();
        }
    }

    private void setBasePanel(JPanel jPanel) {
        this.m_oBasePanel = jPanel;
    }

    private JPanel getBasePanel() {
        return this.m_oBasePanel;
    }

    private JButton createSubmitButton(String string) {
        int n = 0;
        JButton jButton = new JButton(string);
        jButton.addActionListener(new SubmitListener());
        n = jButton.getPreferredSize().height;
        if (string.length() < 9) {
            jButton.setPreferredSize(new Dimension(100, n));
        }
        return jButton;
    }

    private JButton createCancelButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(new CancelListener());
        return jButton;
    }

    private JButton createDiscardButton(String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(new DiscardListener());
        return jButton;
    }

    public void setErrorText(String string) {
        this.m_oErrorMessageLabel.setText(string);
        this.m_oErrorMessageLabel.setVisible(true);
        this.repaint();
    }

    public boolean wasSuccessful() {
        return this.m_bSuccessful;
    }

    protected abstract void incomingAbort();

    protected abstract void incomingSubmit();

    protected void incomingDiscard() {
        LOGGER.warn("Diese Methode aus ADialog wurde nicht \u00fcberschrieben. ({})", (Object)this.getClass().getName());
    }

    protected JPanel getContentPanel() {
        return this.m_oContent;
    }

    protected void setContentPanel(JPanel jPanel) {
        this.m_oContent = jPanel;
    }

    protected JScrollPane addScrollPane(JPanel jPanel, JComponent jComponent, int n, int n2, int n3, int n4) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add(jScrollPane);
        jScrollPane.setBounds(n, n2, n3, n4);
        return jScrollPane;
    }

    protected JButton addButton(String string, String string2, ActionListener actionListener, JPanel jPanel, int n, int n2, int n3) {
        JButton jButton = null;
        ResourceLoaderInstance resourceLoaderInstance = null;
        ImageIcon imageIcon = null;
        if (string != "") {
            jButton = new JButton(string);
        } else {
            resourceLoaderInstance = MainController.getResLoader();
            try {
                imageIcon = resourceLoaderInstance.getIconExcpt(string2);
            }
            catch (ResourceLoader.ResourceLoadException resourceLoadException) {
                resourceLoadException.printStackTrace();
            }
            jButton = new JButton(imageIcon);
        }
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        jPanel.add(jButton);
        jButton.setBounds(n, n2, n3, jButton.getPreferredSize().height);
        return jButton;
    }

    protected JButton addButtonWithIcon(String string, String string2, ActionListener actionListener, JPanel jPanel, int n, int n2, int n3) {
        JButton jButton = null;
        ResourceLoaderInstance resourceLoaderInstance = null;
        ImageIcon imageIcon = null;
        jButton = new JButton(string2);
        resourceLoaderInstance = MainController.getResLoader();
        try {
            imageIcon = resourceLoaderInstance.getIconExcpt(string);
            jButton = new JButton(imageIcon);
        }
        catch (ResourceLoader.ResourceLoadException resourceLoadException) {
            LOGGER.error("{}#addButtonWithIcon: {} not found", (Object)this.getClass().getName(), (Object)string);
        }
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        jPanel.add(jButton);
        jButton.setBounds(n, n2, n3, jButton.getPreferredSize().height);
        return jButton;
    }

    protected JCheckBox addCheckBox(ActionListener actionListener, JPanel jPanel, JLabel jLabel, int n, int n2) {
        JCheckBox jCheckBox = new JCheckBox();
        if (actionListener != null) {
            jCheckBox.addActionListener(actionListener);
        }
        jPanel.add(jCheckBox);
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setBounds(n, n2, 15, 14);
        return jCheckBox;
    }

    protected JCheckBox addCheckBox(String string, JPanel jPanel, int n, int n2, int n3, int n4) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jPanel.add(jCheckBox);
        jCheckBox.setBounds(n, n2, n3, n4);
        return jCheckBox;
    }

    protected JLabel addLabel(String string, JPanel jPanel, boolean bl, int n, int n2, int n3, int n4) {
        return this.addLabel(string, jPanel, bl, n, n2, n3, n4, true);
    }

    protected JLabel addLabel(String string, JPanel jPanel, boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        JLabel jLabel = bl ? new JLabel(string + ":") : new JLabel(string);
        jLabel.setHorizontalAlignment(2);
        if (bl2) {
            jLabel.setVerticalAlignment(0);
        } else {
            jLabel.setVerticalAlignment(1);
        }
        jLabel.setBounds(n, n2, n3, n4);
        jLabel.setFocusable(false);
        jPanel.add(jLabel);
        return jLabel;
    }

    protected JComboBox addComboBox(JPanel jPanel, ComboBoxModel comboBoxModel, int n, int n2, int n3, int n4) {
        JComboBox jComboBox = new JComboBox();
        if (comboBoxModel != null) {
            jComboBox.setModel(comboBoxModel);
        }
        jPanel.add(jComboBox);
        jComboBox.setBounds(n, n2, n3, n4);
        return jComboBox;
    }

    protected JComboBox addComboBox(JPanel jPanel, String[] stringArray, int n, int n2, int n3, int n4) {
        JComboBox<Object> jComboBox = null;
        jComboBox = stringArray != null ? new JComboBox<String>(stringArray) : new JComboBox();
        jPanel.add(jComboBox);
        jComboBox.setBounds(n, n2, n3, n4);
        return jComboBox;
    }

    protected JComboBox addComboBox(JPanel jPanel, Vector<?> vector, int n, int n2, int n3, int n4) {
        JComboBox<Object> jComboBox = null;
        jComboBox = vector != null ? new JComboBox(vector) : new JComboBox();
        jPanel.add(jComboBox);
        jComboBox.setBounds(n, n2, n3, n4);
        return jComboBox;
    }

    protected CSelectedList addSelectedList(ListModel listModel) {
        CSelectedList cSelectedList = new CSelectedList();
        if (listModel != null) {
            cSelectedList.setModel(listModel);
        }
        this.addToValidationList(cSelectedList);
        return cSelectedList;
    }

    protected JList addList(ListModel listModel) {
        JList jList = new JList();
        if (listModel != null) {
            jList.setModel(listModel);
        }
        return jList;
    }

    protected JList addList(Vector<? extends Object> vector) {
        CSelectedList cSelectedList = null;
        cSelectedList = vector != null ? new CSelectedList((List<?>)vector) : new CSelectedList();
        return cSelectedList;
    }

    protected CSelectedList addSelectedList(List<?> list) {
        CSelectedList cSelectedList = null;
        cSelectedList = list != null ? new CSelectedList(list) : new CSelectedList();
        this.addToValidationList(cSelectedList);
        return cSelectedList;
    }

    protected CNonEmptyList addNonEmptyList(DefaultListModel defaultListModel) {
        CNonEmptyList cNonEmptyList = null;
        cNonEmptyList = defaultListModel != null ? new CNonEmptyList(defaultListModel) : new CNonEmptyList(new DefaultListModel());
        this.addToValidationList(cNonEmptyList);
        return cNonEmptyList;
    }

    protected CURLComboBox addURLComboBox(JPanel jPanel, Vector<URL> vector, JLabel jLabel, int n, int n2, int n3, int n4) {
        return this.addURLComboBox(jPanel, vector, jLabel, n, n2, n3, n4, false);
    }

    protected CURLComboBox addURLComboBox(JPanel jPanel, Vector<URL> vector, JLabel jLabel, int n, int n2, int n3, int n4, boolean bl) {
        CURLComboBox cURLComboBox = new CURLComboBox(vector, bl);
        if (jLabel != null) {
            cURLComboBox.setCorrespondingLabel(jLabel);
        }
        this.addToValidationList(cURLComboBox);
        jPanel.add(cURLComboBox);
        cURLComboBox.setBounds(n, n2, n3, n4);
        return cURLComboBox;
    }

    protected JPanel addBorderedPanel(String string, JPanel jPanel, int n, int n2, int n3, int n4) {
        return this.addBorderedPanel(string, jPanel, null, n, n2, n3, n4);
    }

    protected JPanel addBorderedPanel(String string, JPanel jPanel, LayoutManager layoutManager, int n, int n2, int n3, int n4) {
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = null;
        titledBorder = BorderFactory.createTitledBorder(string);
        jPanel2.setBorder(titledBorder);
        jPanel2.setLayout(layoutManager);
        jPanel2.setBounds(n, n2, n3, n4);
        jPanel.add(jPanel2);
        return jPanel2;
    }

    protected CTimeDurationTextfield addTimeDurationTextfield(JPanel jPanel, int n, int n2, int n3) {
        return this.addTimeDurationTextfield(jPanel, false, n, n2, n3);
    }

    protected CTimeDurationTextfield addTimeDurationTextfield(JPanel jPanel, boolean bl, int n, int n2, int n3) {
        CTimeDurationTextfield cTimeDurationTextfield = new CTimeDurationTextfield(bl);
        this.addToValidationList(cTimeDurationTextfield);
        cTimeDurationTextfield.setBounds(n, n2, n3, cTimeDurationTextfield.getPreferredSize().height);
        jPanel.add((Component)((Object)cTimeDurationTextfield));
        return cTimeDurationTextfield;
    }

    protected CTimeTextfield addTimeTextfield(JPanel jPanel, JLabel jLabel, int n, int n2, int n3) {
        CTimeTextfield cTimeTextfield = new CTimeTextfield(jLabel);
        this.addToValidationList(cTimeTextfield);
        cTimeTextfield.setBounds(n, n2, n3, cTimeTextfield.getPreferredSize().height);
        jPanel.add((Component)((Object)cTimeTextfield));
        return cTimeTextfield;
    }

    protected CDateTextfield addDateTextfield(JPanel jPanel, JLabel jLabel, int n, int n2, int n3) {
        CDateTextfield cDateTextfield = new CDateTextfield(jLabel);
        this.addToValidationList(cDateTextfield);
        cDateTextfield.setBounds(n, n2, n3, cDateTextfield.getPreferredSize().height);
        jPanel.add((Component)((Object)cDateTextfield));
        return cDateTextfield;
    }

    protected CNonEmptyTextfield addNonEmptyTextfield(JPanel jPanel, JLabel jLabel, int n, int n2, int n3, int n4) {
        return this.addNonEmptyTextfield(jPanel, jLabel, 50, n, n2, n3, n4);
    }

    protected CNonEmptyTextfield addNonEmptyTextfield(JPanel jPanel, JLabel jLabel, int n, int n2, int n3, int n4, int n5) {
        CNonEmptyTextfield cNonEmptyTextfield = new CNonEmptyTextfield(jLabel, n);
        this.addToValidationList(cNonEmptyTextfield);
        jPanel.add((Component)((Object)cNonEmptyTextfield));
        cNonEmptyTextfield.setBounds(n2, n3, n4, n5);
        return cNonEmptyTextfield;
    }

    protected CTextFieldEx addMaxLengthTextfield(JPanel jPanel, int n, int n2, int n3, int n4) {
        CTextFieldEx cTextFieldEx = new CTextFieldEx();
        jPanel.add((Component)cTextFieldEx);
        cTextFieldEx.setBounds(n, n2, n3, n4);
        return cTextFieldEx;
    }

    class DiscardListener
    implements ActionListener {
        DiscardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ADialog.this.incomingDiscard();
        }
    }

    class SubmitListener
    implements ActionListener {
        SubmitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ADialog.this.incomingSubmit();
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ADialog.this.incomingAbort();
            ADialog.this.setVisible(false);
            ADialog.this.dispose();
        }
    }

    public static enum EShowButtons {
        NONE,
        OK,
        CANCEL,
        OKCANCEL,
        OKCANCELDISCARD;

    }
}

