/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.effort;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.FredMessageBox;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.mscl.mwt.MessageBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class CDlgEffortSetTaskForAll
extends ADialogEx {
    private static final int DIALOG_HEIGHT = 60;
    private static final int DIALOG_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 350 : 400;
    private DefaultComboBoxModel m_oEmptyModel = new DefaultComboBoxModel();
    private JComboBox m_oProjectComboBox;
    private JComboBox m_oTaskComboBox;
    private ComboBoxModel m_oProjectComboBoxModel;
    private ComboBoxModel m_oTaskComboBoxModel;
    private final CTaskImpl m_oInitialySelectedTask;
    private CProjectImpl m_oCurrentlySelectedProject = null;
    private CTaskImpl m_oCurrentlySelectedTask = null;

    public CDlgEffortSetTaskForAll(CTaskImpl cTaskImpl, int n) {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("Dlg.Effort.SetTaskForAll", new Object[0]), n > 1 ? Labels.get("Dlg.Effort.SetTaskForAll_Subtitle", new Integer(n)) : Labels.get("Dlg.Effort.SetTaskForAll_Subtitle_One", new Object[0]), "images/dialog-icon-task.png", true, ADialogEx.OK_BUTTON_TEXT.toString(), 3, new Dimension(DIALOG_WIDTH, 60));
        this.m_oInitialySelectedTask = cTaskImpl;
        this.getContentPanel().setLayout(null);
        this._insertProjectComboBox();
        this._insertTaskComboBox();
        this.getOkButton().setToolTipText(Labels.get("CDLGEFFORTEDITEFFORTTITLE_OK_TOOLTIP", new Object[0]));
    }

    @Override
    protected Component getDefaultComponent() {
        return this.m_oProjectComboBox;
    }

    private void _insertProjectComboBox() {
        this.addLabel(Labels.get("PROJECT", new Object[0]), this.getContentPanel(), true, 0, 0, 90, 20);
        this.m_oProjectComboBoxModel = ProjectList.getInstance().getProjectComboBoxModel();
        this.m_oCurrentlySelectedProject = this.m_oInitialySelectedTask.getProject();
        this.m_oProjectComboBox = this.addComboBox(this.getContentPanel(), this.m_oProjectComboBoxModel, 100, 0, DIALOG_WIDTH - 100, 20);
        this.m_oProjectComboBox.setSelectedItem(this.m_oCurrentlySelectedProject);
        this.m_oProjectComboBox.addItemListener(new CProjectItemListener());
    }

    private void _insertTaskComboBox() {
        this.addLabel(Labels.get("TASK", new Object[0]), this.getContentPanel(), true, 0, 25, 90, 20);
        this.m_oTaskComboBoxModel = this.m_oCurrentlySelectedProject.getTaskComboBoxModel();
        this.m_oTaskComboBox = this.addComboBox(this.getContentPanel(), this.m_oTaskComboBoxModel, 100, 25, DIALOG_WIDTH - 100, 20);
        this.m_oCurrentlySelectedTask = this.m_oInitialySelectedTask;
        this.m_oTaskComboBox.setSelectedItem(this.m_oCurrentlySelectedTask);
        this.m_oTaskComboBox.addItemListener(new CTaskItemListener());
    }

    public CTaskImpl getSelectedTask() {
        return this.m_oCurrentlySelectedTask;
    }

    @Override
    protected boolean onOK() {
        if (this.m_oCurrentlySelectedProject.getTaskCount() == 0) {
            FredMessageBox.showInfoDlg(Labels.get("INFORMATION_EMPTY_PROJEKT", new Object[0]), Labels.get("TITLE_ERROR", new Object[0]), MessageBox.EIcon.WARNING);
            return false;
        }
        return true;
    }

    private void _handleProjectSelectionChange() {
        this.m_oCurrentlySelectedProject = (CProjectImpl)this.m_oProjectComboBox.getSelectedItem();
        if (this.m_oCurrentlySelectedProject.getTaskCount() == 0) {
            this.m_oTaskComboBox.setEnabled(false);
            this.m_oTaskComboBox.setModel(this.m_oEmptyModel);
            return;
        }
        this.m_oTaskComboBoxModel = this.m_oCurrentlySelectedProject.getTaskComboBoxModel();
        this.m_oTaskComboBox.setModel(this.m_oTaskComboBoxModel);
        this.m_oTaskComboBox.setEnabled(true);
        this._handleTaskSelectionChange();
    }

    private void _handleTaskSelectionChange() {
        this.m_oCurrentlySelectedTask = (CTaskImpl)this.m_oTaskComboBoxModel.getSelectedItem();
    }

    private class CTaskItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                CDlgEffortSetTaskForAll.this._handleTaskSelectionChange();
            }
        }
    }

    private class CProjectItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                CDlgEffortSetTaskForAll.this._handleProjectSelectionChange();
            }
        }
    }
}

