/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.file;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.filehandling.filefilter.CWorkfileFilter;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.FredMessageBox;
import com.mayastudios.fred.client.view.dialogs.textfields.AValidableTextfield;
import com.mayastudios.fred.client.view.dialogs.textfields.CNonEmptyTextfield;
import com.mayastudios.mscl.mwt.MessageBox;
import com.mayastudios.mscl.mwt.widgets.filechooser.FileChooser;
import de.wb.control.IValidable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class CreateWorkFileDlg
extends ADialogEx {
    private String m_firstName = null;
    private String m_lastName = null;
    private String m_paraph = null;
    private File m_workFilePath = null;
    private final CNonEmptyTextfield m_firstNameField;
    private final CNonEmptyTextfield m_lastNameField;
    private final CNonEmptyTextfield m_paraphField;
    private final LocalFilePathTextfield m_workFilePathField;

    public CreateWorkFileDlg() {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("CDLGFILECREATEWORKFILE", new Object[0]), Labels.get("CDLGFILECREATEWORKFILE_SUBTITLE", new Object[0]), "images/dialog-icon-new-workfile.png", true, Labels.get("BUTTON_CREATE", new Object[0]), 3, new Dimension(580, 120));
        JLabel jLabel = this.addLabel(Labels.get("USERFIRSTNAME", new Object[0]), this.getContentPanel(), true, 0, 0, 150, 20);
        this.m_firstNameField = this.addNonEmptyTextfield(this.getContentPanel(), jLabel, 170, 0, 250, 20);
        jLabel = this.addLabel(Labels.get("USERNAME", new Object[0]), this.getContentPanel(), true, 0, 30, 150, 20);
        this.m_lastNameField = this.addNonEmptyTextfield(this.getContentPanel(), jLabel, 170, 30, 250, 20);
        jLabel = this.addLabel(Labels.get("PARAPH", new Object[0]), this.getContentPanel(), true, 0, 60, 150, 20);
        this.m_paraphField = this.addNonEmptyTextfield(this.getContentPanel(), jLabel, 170, 60, 250, 20);
        this.m_paraphField.setMaxTextLength(5);
        jLabel = this.addLabel(Labels.get("WORKFILE_PATH", new Object[0]), this.getContentPanel(), true, 0, 90, 150, 20);
        this.m_workFilePathField = new LocalFilePathTextfield(jLabel);
        this.addToValidationList(this.m_workFilePathField);
        this.getContentPanel().add((Component)((Object)this.m_workFilePathField));
        this.m_workFilePathField.setBounds(170, 90, 250, 20);
        this.addButton(Labels.get("BUTTON_SEARCH", new Object[0]), null, new FileChooserButtonListener(), this.getContentPanel(), 440, 90, 140);
    }

    public String getFirstName() {
        return this.m_firstName;
    }

    public String getLastName() {
        return this.m_lastName;
    }

    public String getParaph() {
        return this.m_paraph;
    }

    public File getWorkFilePath() {
        return this.m_workFilePath;
    }

    @Override
    protected boolean onOK() {
        MessageBox.EButton eButton;
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        File file = new File(this.m_workFilePathField.getText()).getAbsoluteFile();
        if (file.exists()) {
            MessageBox.EButton eButton2 = FredMessageBox.showOptionDlg(Labels.get("Dlg.CreateWorkFile.Overwrite", new Object[0]), Labels.get("TITLE_QUESTION", new Object[0]), MessageBox.EIcon.QUESTION, MessageBox.EOptionButtons.YES_NO);
            if (eButton2 != MessageBox.EButton.YES) {
                return false;
            }
            if (!file.canWrite() && (eButton2 = FredMessageBox.showOptionDlg(Labels.get("Dlg.CreateWorkFile.NotWritable", new Object[0]), Labels.get("TITLE_WARNING", new Object[0]), MessageBox.EIcon.WARNING, MessageBox.EOptionButtons.YES_NO)) != MessageBox.EButton.YES) {
                return false;
            }
        } else if (!file.getParentFile().canWrite() && !file.canWrite() && (eButton = FredMessageBox.showOptionDlg(Labels.get("Dlg.CreateWorkFile.NotWritable", new Object[0]), Labels.get("TITLE_WARNING", new Object[0]), MessageBox.EIcon.WARNING, MessageBox.EOptionButtons.YES_NO)) != MessageBox.EButton.YES) {
            return false;
        }
        this.m_firstName = this.m_firstNameField.getText();
        this.m_lastName = this.m_lastNameField.getText();
        this.m_paraph = this.m_paraphField.getText();
        this.m_workFilePath = file;
        return true;
    }

    @Override
    protected IValidable.EErrorStatus evaluateValidationList(boolean bl, boolean bl2) {
        IValidable.EErrorStatus eErrorStatus = super.evaluateValidationList(bl, bl2);
        if (eErrorStatus == null) {
            return null;
        }
        switch (eErrorStatus) {
            case WRONG_EMPTY_FILEPATH: {
                this.setErrorText(Labels.get("Dlg.CreateWorkFile.EmptyFilename", new Object[0]));
                break;
            }
            case WRONG_INVALID_FILEPATH: {
                this.setErrorText(Labels.get("Dlg.CreateWorkFile.IsDir", new Object[0]));
            }
        }
        return eErrorStatus;
    }

    private class FileChooserButtonListener
    implements ActionListener {
        private FileChooserButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileChooser.showFileChooser((Component)CreateWorkFileDlg.this, (String)Labels.get("CDLGFILECREATEWORKFILE", new Object[0]), (String)Labels.get("Text.OK", new Object[0]), (String)DirectoryUtil.getDefaultFileChooserDir().getAbsolutePath(), (FileFilter[])new FileFilter[]{CWorkfileFilter.INSTANCE});
            if (file != null) {
                String string = file.getAbsolutePath();
                if (!(string = string.trim()).toLowerCase().endsWith(".fred")) {
                    string = string + ".fred";
                }
                CreateWorkFileDlg.this.m_workFilePathField.setText(string);
            }
        }
    }

    private static class LocalFilePathTextfield
    extends AValidableTextfield {
        public LocalFilePathTextfield(JLabel jLabel) {
            super(jLabel, Integer.MAX_VALUE, false);
        }

        @Override
        public boolean evaluateContent() {
            String string = this.getText();
            if (string.length() == 0) {
                this.m_eErrorStatus = IValidable.EErrorStatus.WRONG_EMPTY_FILEPATH;
                return false;
            }
            File file = new File(string).getAbsoluteFile();
            if (file.isDirectory()) {
                this.m_eErrorStatus = IValidable.EErrorStatus.WRONG_INVALID_FILEPATH;
                return false;
            }
            return true;
        }
    }
}

