/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.help;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.mscl.mwt.GUIConstants;
import com.mayastudios.mscl.mwt.widgets.CSmoothLabel;
import com.mayastudios.mscl.mwt.widgets.CTextScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CDlgHelpQuickStart
extends ADialogEx {
    private static final int MAX_STEPS = 10;
    private static final String TITLE_FORMATTER = Labels.get("CDLGHELPQUICKSTART_TITLE_FORMATTER", new Object[0]);
    private static CDlgHelpQuickStart s_oInstance = new CDlgHelpQuickStart();
    private int m_iCurStep = 0;
    private CSmoothLabel m_oStepTitle = new CSmoothLabel();
    private CTextScrollPane m_oInstructionsLabel = new CTextScrollPane(true, false);
    JButton m_oNextButton;
    JButton m_oPrevButton;
    JButton m_oToStartButton;

    private CDlgHelpQuickStart() {
        super((JFrame)MainController.getInstance().getMainWindow(), false, Labels.get("CDLGHELPQUICKSTART", new Object[0]), Labels.get("CDLGHELPQUICKSTART_SUBTITLE", new Object[0]), "images/dialog-icon-quickstart.png", true, "", 2, new Dimension(740, 245));
        super.setCancelButtonText(Labels.get("BUTTON_HIDE_WINDOW", new Object[0]));
        this.m_oStepTitle.setBounds(0, 0, 600, 25);
        this.m_oStepTitle.setFont(GUIConstants.DEFAULT_LABEL_FONT.deriveFont(1, GUIConstants.DEFAULT_LABEL_FONT.getSize2D() + 5.0f));
        super.getContentPanel().add((Component)this.m_oStepTitle);
        JPanel jPanel = super.addBorderedPanel(Labels.get("CDLGHELPQUICKSTART_PANELTITLE", new Object[0]), super.getContentPanel(), 0, 35, 550, 210);
        this.m_oInstructionsLabel.setBounds(20, 30, 510, 160);
        jPanel.add((Component)this.m_oInstructionsLabel);
        this.m_oNextButton = super.addButtonWithIcon("images/arrow-right-short.png", "", new CButtonListener(), this.getContentPanel(), 570, 35, 170);
        this.m_oNextButton.setText(Labels.get("CDLGHELPQUICKSTART_NEXT", new Object[0]));
        this.m_oPrevButton = super.addButtonWithIcon("images/arrow-left-short.png", "", new CButtonListener(), this.getContentPanel(), 570, 65, 170);
        this.m_oPrevButton.setText(Labels.get("CDLGHELPQUICKSTART_PREV", new Object[0]));
        this.m_oToStartButton = super.addButton(Labels.get("CDLGHELPQUICKSTART_TO_START", new Object[0]), null, new CButtonListener(), this.getContentPanel(), 570, 95, 170);
        this._refreshContent(0);
        this.addWindowListener(new CWindowListener());
    }

    public static void showQuickstartDlg() {
        s_oInstance.showDialog();
    }

    public void nextStep() {
        this._refreshContent(this.m_iCurStep + 1);
    }

    public void prevStep() {
        this._refreshContent(this.m_iCurStep - 1);
    }

    private void _refreshContent(int n) {
        if (n < 0 || n >= 10) {
            return;
        }
        String string = Labels.get("CDLGHELPQUICKSTART_INSTRUCT_TITLE_" + n, new Object[0]);
        this.m_oStepTitle.setText(String.format(TITLE_FORMATTER, new Integer(n + 1), new Integer(10), string.replace("\n", "<br>")));
        String string2 = Labels.get("CDLGHELPQUICKSTART_INSTRUCT_" + n, new Object[0]);
        string2 = string2.replace("\n", "<br>");
        this.m_oInstructionsLabel.setText("<html>" + string2, true);
        this.m_oPrevButton.setEnabled(n != 0);
        this.m_oToStartButton.setEnabled(n != 0);
        this.m_oNextButton.setEnabled(n != 9);
        this.m_iCurStep = n;
    }

    @Override
    protected boolean onOK() {
        return false;
    }

    class CButtonListener
    implements ActionListener {
        CButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CDlgHelpQuickStart.this.m_oNextButton) {
                CDlgHelpQuickStart.this.nextStep();
            } else if (actionEvent.getSource() == CDlgHelpQuickStart.this.m_oPrevButton) {
                CDlgHelpQuickStart.this.prevStep();
            } else if (actionEvent.getSource() == CDlgHelpQuickStart.this.m_oToStartButton) {
                CDlgHelpQuickStart.this._refreshContent(0);
            }
        }
    }

    class CWindowListener
    extends WindowAdapter {
        CWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            CDlgHelpQuickStart.this.removeWindowListener(this);
            CDlgHelpQuickStart.this.setLocation(10, 10);
            CDlgHelpQuickStart.this.setSize(CDlgHelpQuickStart.this.getPreferredSize());
        }
    }
}

