/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SimplifiedSAXParser {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private final SAXParser mf_oSAXParser;

    public SimplifiedSAXParser() {
        this(null);
    }

    public SimplifiedSAXParser(URL p_oSchemaURL) {
        block11: {
            SAXParserFactory oParserFactory = SAXParserFactory.newInstance();
            oParserFactory.setNamespaceAware(false);
            oParserFactory.setValidating(false);
            boolean bUseAlternativeSchemaWay = false;
            try {
                if (p_oSchemaURL != null) {
                    SchemaFactory oSchemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    try {
                        oParserFactory.setSchema(oSchemaFactory.newSchema(p_oSchemaURL));
                    }
                    catch (SAXException oException) {
                        throw new ExceptionInInitializerError(oException);
                    }
                    catch (Exception oException) {
                        oParserFactory.setValidating(true);
                        bUseAlternativeSchemaWay = true;
                    }
                }
                this.mf_oSAXParser = oParserFactory.newSAXParser();
                if (p_oSchemaURL == null || !bUseAlternativeSchemaWay) break block11;
                try {
                    this.mf_oSAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
                    this.mf_oSAXParser.setProperty(JAXP_SCHEMA_SOURCE, p_oSchemaURL.toString());
                }
                catch (SAXNotRecognizedException oException) {
                    throw new IllegalStateException(oException);
                }
                catch (SAXNotSupportedException oException) {
                    throw new IllegalStateException(oException);
                }
            }
            catch (UnsupportedOperationException oException) {
                throw new IllegalStateException(oException);
            }
            catch (ParserConfigurationException oException) {
                throw new IllegalStateException(oException);
            }
            catch (SAXException oException) {
                throw new ExceptionInInitializerError(oException);
            }
        }
    }

    public SAXParser getParser() {
        return this.mf_oSAXParser;
    }

    public synchronized void parse(InputStream p_oXMLDataStream, DefaultHandler p_oSAXHandler) throws SAXException, IOException {
        if (p_oXMLDataStream == null || p_oSAXHandler == null) {
            throw new IllegalArgumentException("Neither p_oXMLDataStream nor p_oSAXHandler must be null.");
        }
        this.mf_oSAXParser.parse(p_oXMLDataStream, p_oSAXHandler);
    }

    public static class SAXError
    extends SAXException {
        public SAXError(SAXParseException p_oException) {
            super(SAXError._formatMessage(p_oException), p_oException);
        }

        private static String _formatMessage(SAXParseException p_oException) {
            String strFormatString = p_oException.getPublicId() == null ? "%s  [in line %d|%d]" : "%s  [in line %d|%d: %s]";
            return String.format(strFormatString, p_oException.getMessage(), p_oException.getLineNumber(), p_oException.getColumnNumber(), p_oException.getPublicId());
        }
    }

    public static abstract class SimplifiedDefaultHandler
    extends DefaultHandler {
        public void startElement(String p_strTagName, Attributes p_oAttributes) throws SAXException {
        }

        public final void startElement(String p_strUri, String p_strLocalName, String p_strName, Attributes p_oAttributes) throws SAXException {
            this.startElement(p_strName.toLowerCase(), p_oAttributes);
        }

        public void endElement(String p_strTagName) throws SAXException {
        }

        public final void endElement(String p_strUri, String p_strLocalName, String p_strName) throws SAXException {
            this.endElement(p_strName.toLowerCase());
        }

        public void fatalError(SAXParseException p_oException) throws SAXException {
            throw new SAXError(p_oException);
        }

        public void error(SAXParseException p_oException) throws SAXException {
            throw new SAXError(p_oException);
        }
    }
}

