/*
 * Decompiled with CFR 0.152.
 */
package de.sopra06.replication;

import de.sopra06.domainmodel.Effort;
import de.sopra06.domainmodel.ObjectFactory;
import de.sopra06.domainmodel.Person;
import de.sopra06.domainmodel.Project;
import de.sopra06.domainmodel.Task;
import de.sopra06.replication.IReplicationService;
import de.sopra06.replication.exceptions.ReplicationException;
import de.sopra06.transfer.XmlEffort;
import de.sopra06.transfer.XmlPerson;
import de.sopra06.transfer.XmlProject;
import de.sopra06.transfer.XmlTask;
import de.sopra06.transfer.XmlTransferDocument;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class ReplicationService
implements IReplicationService {
    private static ObjectFactory objectFactory;
    private static URL url;
    public static final String MARSHALLER_ENCODING = "UTF-8";
    public static final SimpleDateFormat XML_DATE_FORMAT;
    public static final int JOB_SEND_NEW_PROJECT = 1;
    public static final int JOB_SEND_NEW_TASKS = 2;
    public static final int JOB_SEND_NEW_EFFORTS = 3;
    public static final int JOB_RECEIVE_PROJECTS = 4;
    public static final int JOB_RECEIVE_TASKS = 5;
    public static final int JOB_RECEIVE_EFFORTS = 6;
    public static final int JOB_CLOSE_PROJECT = 7;
    private static final String ERRORMSG_PROJECT_COUNT = "No or more than one projects where given!";
    private static final String ERRORMSG_PROJECT_SECURITYID = "Project has no SecurityID set!";
    private static final String ERRORMSG_PROJECT_CLOSED = "Project can't be send, because it's closed!";
    private static final String ERRORMSG_PERSON_COUNT = "No or more than one persons where given!";
    private static final String ERRORMSG_PERSON_SECURITYID = "Person has no SecurityID set!";
    private static final String ERRORMSG_TASK_COUNT = "You have to send at least one task!";
    private static final String ERRORMSG_EFFORT_COUNT = "You have to send at least one effort!";
    private int status = 100;
    private Vector sendPersons = null;
    private Vector sendEfforts = null;
    private Vector sendTasks = null;
    private Vector sendProjects = null;
    private Vector receivedPersons = new Vector();
    private Vector receivedEfforts = new Vector();
    private Vector receivedTasks = new Vector();
    private Vector receivedProjects = new Vector();

    public ObjectFactory getObjectFactory() {
        return objectFactory;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        ReplicationService.objectFactory = objectFactory;
    }

    public URL getURL() {
        return url;
    }

    public void setURL(URL uRL) {
        url = uRL;
    }

    public void sendNewProject() throws ReplicationException {
        XmlTransferDocument xmlTransferDocument = new XmlTransferDocument();
        xmlTransferDocument.setStatusCode(this.getStatus());
        XmlTransferDocument xmlTransferDocument2 = null;
        xmlTransferDocument.setJobID(1);
        this.addPerson(xmlTransferDocument, true);
        this.addProject(xmlTransferDocument);
        xmlTransferDocument2 = this.replicate(xmlTransferDocument);
    }

    public void sendNewTasks() throws ReplicationException {
        XmlTransferDocument xmlTransferDocument = new XmlTransferDocument();
        xmlTransferDocument.setStatusCode(this.getStatus());
        XmlTransferDocument xmlTransferDocument2 = null;
        xmlTransferDocument.setJobID(2);
        this.addPerson(xmlTransferDocument, true);
        this.addProject(xmlTransferDocument);
        this.addTasks(xmlTransferDocument);
        xmlTransferDocument2 = this.replicate(xmlTransferDocument);
    }

    public void sendNewEfforts() throws ReplicationException {
        XmlTransferDocument xmlTransferDocument = new XmlTransferDocument();
        xmlTransferDocument.setStatusCode(this.getStatus());
        XmlTransferDocument xmlTransferDocument2 = null;
        xmlTransferDocument.setJobID(3);
        this.addPerson(xmlTransferDocument, false);
        this.addProject(xmlTransferDocument);
        this.addTasks(xmlTransferDocument);
        this.addEfforts(xmlTransferDocument);
        xmlTransferDocument2 = this.replicate(xmlTransferDocument);
    }

    public void receiveProjects() throws ReplicationException {
        XmlTransferDocument xmlTransferDocument = new XmlTransferDocument();
        xmlTransferDocument.setStatusCode(this.getStatus());
        XmlTransferDocument xmlTransferDocument2 = null;
        xmlTransferDocument.setJobID(4);
        xmlTransferDocument2 = this.replicate(xmlTransferDocument);
        if (this.getStatus() == 200) {
            for (int i = 0; i < xmlTransferDocument2.getXmlProjectCount(); ++i) {
                this.receivedProjects.add(ReplicationService.createProject(xmlTransferDocument2.getXmlProject(i)));
            }
        }
    }

    public void receiveTasks() throws ReplicationException {
        XmlTransferDocument xmlTransferDocument = new XmlTransferDocument();
        xmlTransferDocument.setStatusCode(this.getStatus());
        XmlTransferDocument xmlTransferDocument2 = null;
        xmlTransferDocument.setJobID(5);
        this.addProject(xmlTransferDocument);
        xmlTransferDocument2 = this.replicate(xmlTransferDocument);
        if (this.getStatus() == 200) {
            for (int i = 0; i < xmlTransferDocument2.getXmlTaskCount(); ++i) {
                this.receivedTasks.add(ReplicationService.createTask(xmlTransferDocument2.getXmlTask(i)));
            }
        }
    }

    public void receiveEfforts() throws ReplicationException {
        XmlTransferDocument xmlTransferDocument = new XmlTransferDocument();
        xmlTransferDocument.setStatusCode(this.getStatus());
        XmlTransferDocument xmlTransferDocument2 = null;
        xmlTransferDocument.setJobID(6);
        this.addProject(xmlTransferDocument);
        this.addPerson(xmlTransferDocument, true);
        xmlTransferDocument2 = this.replicate(xmlTransferDocument);
        if (this.getStatus() == 200) {
            int n;
            for (n = 0; n < xmlTransferDocument2.getXmlPersonCount(); ++n) {
                this.receivedPersons.add(ReplicationService.createPerson(xmlTransferDocument2.getXmlPerson(n)));
            }
            for (n = 0; n < xmlTransferDocument2.getXmlEffortCount(); ++n) {
                this.receivedEfforts.add(ReplicationService.createEffort(xmlTransferDocument2.getXmlEffort(n)));
            }
        }
    }

    public void closeProject() throws ReplicationException {
        XmlTransferDocument xmlTransferDocument = new XmlTransferDocument();
        xmlTransferDocument.setStatusCode(this.getStatus());
        XmlTransferDocument xmlTransferDocument2 = null;
        xmlTransferDocument.setJobID(7);
        this.addPerson(xmlTransferDocument, true);
        this.addProject(xmlTransferDocument);
        xmlTransferDocument2 = this.replicate(xmlTransferDocument);
    }

    private XmlTransferDocument replicate(XmlTransferDocument xmlTransferDocument) throws ReplicationException {
        try {
            URLConnection uRLConnection = this.getURL().openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setAllowUserInteraction(false);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream(), MARSHALLER_ENCODING);
            Marshaller marshaller = new Marshaller((Writer)outputStreamWriter);
            marshaller.setEncoding(MARSHALLER_ENCODING);
            marshaller.marshal((Object)xmlTransferDocument);
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream(), MARSHALLER_ENCODING);
            XmlTransferDocument xmlTransferDocument2 = XmlTransferDocument.unmarshal(inputStreamReader);
            this.setStatus(xmlTransferDocument2.getStatusCode());
            return xmlTransferDocument2;
        }
        catch (MarshalException marshalException) {
            throw new ReplicationException("A MarshalException occured!\n" + marshalException.toString());
        }
        catch (ValidationException validationException) {
            throw new ReplicationException("A ValidationException occured!\n" + validationException.toString());
        }
        catch (IOException iOException) {
            throw new ReplicationException("An IOException occured!\n" + iOException.toString());
        }
    }

    private static XmlProject createXmlProject(Project project) {
        XmlProject xmlProject = new XmlProject();
        xmlProject.setId(project.getID());
        xmlProject.setName(project.getName());
        xmlProject.setDescription(project.getDescription());
        xmlProject.setClosed(project.isClosed() ? 1 : 0);
        return xmlProject;
    }

    private static XmlTask createXmlTask(Task task) {
        XmlTask xmlTask = new XmlTask();
        xmlTask.setId(task.getID());
        xmlTask.setName(task.getName());
        xmlTask.setShortName(task.getShortName());
        xmlTask.setDescription(task.getDescription());
        xmlTask.setDefaultCategory(task.getDefaultCategory());
        xmlTask.setProjectID(task.getProject().getID());
        return xmlTask;
    }

    private static XmlEffort createXmlEffort(Effort effort) {
        XmlEffort xmlEffort = new XmlEffort();
        xmlEffort.setId(effort.getID());
        xmlEffort.setDescription(effort.getDescription());
        xmlEffort.setBegin(XML_DATE_FORMAT.format(effort.getBegin().getTime()));
        xmlEffort.setDuration(effort.getDuration());
        xmlEffort.setCategory(effort.getCategory());
        xmlEffort.setPersonID(effort.getPerson().getID());
        xmlEffort.setTaskID(effort.getTask().getID());
        return xmlEffort;
    }

    private static XmlPerson createXmlPerson(Person person) {
        XmlPerson xmlPerson = new XmlPerson();
        xmlPerson.setId(person.getID());
        xmlPerson.setFirstName(person.getFirstName());
        xmlPerson.setName(person.getName());
        xmlPerson.setInitials(person.getInitials());
        return xmlPerson;
    }

    private static Project createProject(XmlProject xmlProject) {
        Project project = objectFactory.createProject(xmlProject.getId());
        if (project.getName() == null || project.getName().equals("")) {
            project.setName(xmlProject.getName());
        }
        if (project.getDescription() == null || project.getDescription().equals("")) {
            project.setDescription(xmlProject.getDescription());
        }
        project.setClosed(xmlProject.getClosed() == 1);
        return project;
    }

    private static Task createTask(XmlTask xmlTask) {
        Task task = objectFactory.createTask(xmlTask.getId());
        if (task.getName() == null || task.getName().equals("")) {
            task.setName(xmlTask.getName());
        }
        if (task.getShortName() == null || task.getShortName().equals("")) {
            task.setShortName(xmlTask.getShortName());
        }
        if (task.getDescription() == null || task.getDescription().equals("")) {
            task.setDescription(xmlTask.getDescription());
        }
        task.setDefaultCategory(xmlTask.getDefaultCategory());
        if (task.getProject() == null) {
            task.setProject(objectFactory.createProject(xmlTask.getProjectID()));
        }
        return task;
    }

    private static Effort createEffort(XmlEffort xmlEffort) throws ReplicationException {
        Effort effort = objectFactory.createEffort(xmlEffort.getId());
        if (effort.getDescription().equals("")) {
            effort.setDescription(xmlEffort.getDescription());
        }
        if (effort.getBegin() == null) {
            try {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(XML_DATE_FORMAT.parse(xmlEffort.getBegin()));
                effort.setBegin(calendar);
            }
            catch (ParseException parseException) {
                throw new ReplicationException("Date could not be parsed! \n" + parseException.toString());
            }
        }
        if (effort.getDuration() <= 0) {
            effort.setDuration(xmlEffort.getDuration());
        }
        effort.setCategory(xmlEffort.getCategory());
        effort.setPerson(objectFactory.createPerson(xmlEffort.getPersonID()));
        effort.setTask(objectFactory.createTask(xmlEffort.getTaskID()));
        return effort;
    }

    private static Person createPerson(XmlPerson xmlPerson) {
        Person person = objectFactory.createPerson(xmlPerson.getId());
        if (person.getFirstName().equals("")) {
            person.setFirstName(xmlPerson.getFirstName());
        }
        if (person.getName().equals("")) {
            person.setName(xmlPerson.getName());
        }
        if (person.getInitials().equals("")) {
            person.setInitials(xmlPerson.getInitials());
        }
        return person;
    }

    public void setPersons(Vector vector) {
        this.sendPersons = vector;
    }

    public Vector getPersons() {
        return this.receivedPersons;
    }

    public void setEfforts(Vector vector) {
        this.sendEfforts = vector;
    }

    public Vector getEfforts() {
        return this.receivedEfforts;
    }

    public void setTasks(Vector vector) {
        this.sendTasks = vector;
    }

    public Vector getTasks() {
        return this.receivedTasks;
    }

    public void setProjects(Vector vector) {
        this.sendProjects = vector;
    }

    public Vector getProjects() {
        return this.receivedProjects;
    }

    public int getStatus() {
        return this.status;
    }

    private void setStatus(int n) {
        this.status = n;
    }

    private void addProject(XmlTransferDocument xmlTransferDocument) throws ReplicationException {
        Project project = null;
        if (this.sendProjects.size() != 1) {
            throw new ReplicationException(ERRORMSG_PROJECT_COUNT);
        }
        project = (Project)this.sendProjects.firstElement();
        if (project.isClosed()) {
            throw new ReplicationException(ERRORMSG_PROJECT_CLOSED);
        }
        xmlTransferDocument.addXmlProject(ReplicationService.createXmlProject(project));
    }

    private void addPerson(XmlTransferDocument xmlTransferDocument, boolean bl) throws ReplicationException {
        Person person = null;
        if (this.sendPersons.size() != 1) {
            throw new ReplicationException(ERRORMSG_PERSON_COUNT);
        }
        person = (Person)this.sendPersons.firstElement();
        XmlPerson xmlPerson = ReplicationService.createXmlPerson(person);
        if (bl) {
            if (!person.getSecurityID().equals("")) {
                xmlPerson.setSecurityID(person.getSecurityID());
            } else {
                throw new ReplicationException(ERRORMSG_PERSON_SECURITYID);
            }
        }
        xmlTransferDocument.addXmlPerson(xmlPerson);
    }

    private void addTasks(XmlTransferDocument xmlTransferDocument) throws ReplicationException {
        if (this.sendTasks.size() < 1) {
            throw new ReplicationException(ERRORMSG_TASK_COUNT);
        }
        for (int i = 0; i < this.sendTasks.size(); ++i) {
            Task task = (Task)this.sendTasks.get(i);
            xmlTransferDocument.addXmlTask(ReplicationService.createXmlTask(task));
        }
    }

    private void addEfforts(XmlTransferDocument xmlTransferDocument) throws ReplicationException {
        if (this.sendEfforts.size() < 1) {
            throw new ReplicationException(ERRORMSG_EFFORT_COUNT);
        }
        for (int i = 0; i < this.sendEfforts.size(); ++i) {
            Effort effort = (Effort)this.sendEfforts.get(i);
            xmlTransferDocument.addXmlEffort(ReplicationService.createXmlEffort(effort));
        }
    }

    static {
        url = null;
        XML_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    }
}

