/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpp;

import com.tapsterrock.mpp.FixedMeta;
import com.tapsterrock.mpp.MPPComponent;
import com.tapsterrock.mpp.MPPUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

final class FixedData
extends MPPComponent {
    private Object[] m_array;
    private int[] m_offset;

    FixedData(FixedMeta meta, InputStream is) throws IOException {
        byte[] buffer = new byte[is.available()];
        is.read(buffer);
        int itemCount = meta.getItemCount();
        this.m_array = new Object[itemCount];
        this.m_offset = new int[itemCount];
        for (int loop = 0; loop < itemCount; ++loop) {
            byte[] metaData = meta.getByteArrayValue(loop);
            int itemSize = MPPUtility.getInt(metaData, 0);
            int itemOffset = MPPUtility.getInt(metaData, 4);
            if (itemOffset > buffer.length) continue;
            int available = buffer.length - itemOffset;
            if (itemSize < 0) {
                itemSize = available;
            } else if (itemSize > available) {
                itemSize = available;
            }
            this.m_array[loop] = MPPUtility.cloneSubArray(buffer, itemOffset, itemSize);
            this.m_offset[loop] = itemOffset;
        }
    }

    FixedData(int itemSize, InputStream is) throws IOException {
        int offset = 0;
        int itemCount = is.available() / itemSize;
        this.m_array = new Object[itemCount];
        this.m_offset = new int[itemCount];
        for (int loop = 0; loop < itemCount; ++loop) {
            this.m_offset[loop] = offset;
            this.m_array[loop] = this.readByteArray(is, itemSize);
            offset += itemSize;
        }
    }

    public byte[] getByteArrayValue(int index) {
        byte[] result = null;
        if (index >= 0 && index < this.m_array.length && this.m_array[index] != null) {
            result = (byte[])this.m_array[index];
        }
        return result;
    }

    public int getItemCount() {
        return this.m_array.length;
    }

    public boolean isValidOffset(Integer offset) {
        return offset == null ? false : this.isValidOffset((int)offset);
    }

    public boolean isValidOffset(int offset) {
        return offset >= 0 && offset < this.m_array.length;
    }

    public int getIndexFromOffset(int offset) {
        int result = -1;
        for (int loop = 0; loop < this.m_offset.length; ++loop) {
            if (this.m_offset[loop] != offset) continue;
            result = loop;
            break;
        }
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN FixedData");
        for (int loop = 0; loop < this.m_array.length; ++loop) {
            pw.println("   Data at index: " + loop + " offset: " + this.m_offset[loop]);
            pw.println("  " + MPPUtility.hexdump((byte[])this.m_array[loop], true));
        }
        pw.println("END FixedData");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

