/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXNumberFormat;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mpx.ToStringRequiresFile;
import java.util.Locale;

public final class MPXRate
implements ToStringRequiresFile {
    private double m_amount;
    private TimeUnit m_units;

    MPXRate(MPXNumberFormat format, String rate, Locale locale) throws MPXException {
        int index = rate.indexOf(47);
        if (index == -1) {
            this.m_amount = format.parse(rate).doubleValue();
            this.m_units = TimeUnit.HOURS;
        } else {
            this.m_amount = format.parse(rate.substring(0, index)).doubleValue();
            this.m_units = TimeUnit.parse(rate.substring(index + 1), locale);
        }
    }

    public MPXRate(Number amount, TimeUnit time) {
        this.m_amount = amount == null ? 0.0 : amount.doubleValue();
        this.m_units = time;
    }

    public MPXRate(double amount, TimeUnit time) {
        this.m_amount = amount;
        this.m_units = time;
    }

    public double getAmount() {
        return this.m_amount;
    }

    public TimeUnit getUnits() {
        return this.m_units;
    }

    public String toString(MPXFile mpx) {
        MPXNumberFormat format = mpx.getCurrencyFormat();
        Locale locale = mpx.getLocale();
        StringBuffer buffer = new StringBuffer(format.format(this.m_amount));
        buffer.append("/");
        buffer.append(TimeUnit.format(this.m_units, locale));
        return buffer.toString();
    }
}

