/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mspdi;

import com.tapsterrock.mpx.AccrueType;
import com.tapsterrock.mpx.BookingType;
import com.tapsterrock.mpx.ConstraintType;
import com.tapsterrock.mpx.CurrencySymbolPosition;
import com.tapsterrock.mpx.Day;
import com.tapsterrock.mpx.EarnedValueMethod;
import com.tapsterrock.mpx.ExtendedAttributeContainer;
import com.tapsterrock.mpx.MPXCurrency;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXRate;
import com.tapsterrock.mpx.NumberUtility;
import com.tapsterrock.mpx.Priority;
import com.tapsterrock.mpx.ResourceType;
import com.tapsterrock.mpx.TaskType;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mpx.WorkContour;
import com.tapsterrock.mpx.WorkGroup;
import com.tapsterrock.mspdi.MSPDIFile;
import com.tapsterrock.mspdi.XsdDuration;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DatatypeConverter {
    private static final ThreadLocal DATE_FORMAT = new ThreadLocal();
    private static final ThreadLocal NUMBER_FORMAT = new ThreadLocal();
    private static final String ZERO_DURATION = "PT0H0M0S";
    private static final BigDecimal BIGDECIMAL_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDECIMAL_ONE = BigDecimal.valueOf(1L);

    private static final String printExtendedAttributeCurrency(Number value) {
        return DatatypeConverter.getNumberFormat().format(value.doubleValue() * 100.0);
    }

    private static final Number parseExtendedAttributeCurrency(String value) {
        return NumberUtility.getDouble(Double.parseDouble(value) / 100.0);
    }

    private static final String printExtendedAttributeNumber(Number value) {
        return DatatypeConverter.getNumberFormat().format(value.doubleValue());
    }

    private static final Number parseExtendedAttributeNumber(String value) {
        return new Double(value);
    }

    private static final String printExtendedAttributeBoolean(Boolean value) {
        return value != false ? "1" : "0";
    }

    private static final Boolean parseExtendedAttributeBoolean(String value) {
        return value.equals("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    private static final String printExtendedAttributeDate(Date value) {
        return DatatypeConverter.getDateFormat().format(value);
    }

    private static final Date parseExtendedAttributeDate(String value) {
        Date result;
        try {
            result = DatatypeConverter.getDateFormat().parse(value);
        }
        catch (ParseException ex) {
            result = null;
        }
        return result;
    }

    public static final String printExtendedAttribute(MSPDIFile file, Object value) {
        String result = value instanceof Date ? DatatypeConverter.printExtendedAttributeDate((Date)value) : (value instanceof Boolean ? DatatypeConverter.printExtendedAttributeBoolean((Boolean)value) : (value instanceof MPXDuration ? DatatypeConverter.printDuration(file, (MPXDuration)value) : (value instanceof MPXCurrency ? DatatypeConverter.printExtendedAttributeCurrency((MPXCurrency)value) : (value instanceof Number ? DatatypeConverter.printExtendedAttributeNumber((Number)value) : value.toString()))));
        return result;
    }

    public static final void parseExtendedAttribute(MSPDIFile file, ExtendedAttributeContainer mpx, String value, Integer mpxFieldID, int dataType) {
        switch (dataType) {
            case 1: {
                mpx.set(mpxFieldID, value);
                break;
            }
            case 2: {
                mpx.setDate(mpxFieldID, DatatypeConverter.parseExtendedAttributeDate(value));
                break;
            }
            case 3: {
                mpx.setCurrency(mpxFieldID, DatatypeConverter.parseExtendedAttributeCurrency(value));
                break;
            }
            case 4: {
                mpx.set(mpxFieldID, DatatypeConverter.parseExtendedAttributeBoolean(value));
                break;
            }
            case 5: {
                mpx.set(mpxFieldID, DatatypeConverter.parseExtendedAttributeNumber(value));
                break;
            }
            case 6: {
                mpx.set(mpxFieldID, DatatypeConverter.parseDuration(file, null, value));
            }
        }
    }

    public static final String printCurrencySymbolPosition(CurrencySymbolPosition value) {
        String result;
        switch (value.getValue()) {
            default: {
                result = "0";
                break;
            }
            case 0: {
                result = "1";
                break;
            }
            case 3: {
                result = "2";
                break;
            }
            case 2: {
                result = "3";
            }
        }
        return result;
    }

    public static final CurrencySymbolPosition parseCurrencySymbolPosition(String value) {
        CurrencySymbolPosition result = CurrencySymbolPosition.BEFORE;
        switch (NumberUtility.getInt(value)) {
            case 0: {
                result = CurrencySymbolPosition.BEFORE;
                break;
            }
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
            }
        }
        return result;
    }

    public static final String printAccrueType(AccrueType value) {
        return Integer.toString(value == null ? 3 : value.getType());
    }

    public static final AccrueType parseAccrueType(String value) {
        return AccrueType.getInstance(NumberUtility.getInt(value));
    }

    public static final String printResourceType(ResourceType value) {
        return Integer.toString(value == null ? 1 : value.getValue());
    }

    public static final ResourceType parseResourceType(String value) {
        return ResourceType.getInstance(NumberUtility.getInt(value));
    }

    public static final String printWorkGroup(WorkGroup value) {
        return Integer.toString(value == null ? 0 : value.getValue());
    }

    public static final WorkGroup parseWorkGroup(String value) {
        return WorkGroup.getInstance(NumberUtility.getInt(value));
    }

    public static final String printWorkContour(WorkContour value) {
        return Integer.toString(value == null ? 0 : value.getValue());
    }

    public static final WorkContour parseWorkContour(String value) {
        return WorkContour.getInstance(NumberUtility.getInt(value));
    }

    public static final String printBookingType(BookingType value) {
        return Integer.toString(value == null ? 0 : value.getValue());
    }

    public static final BookingType parseBookingType(String value) {
        return BookingType.getInstance(NumberUtility.getInt(value));
    }

    public static final String printTaskType(TaskType value) {
        return Integer.toString(value == null ? 0 : value.getValue());
    }

    public static final TaskType parseTaskType(String value) {
        return TaskType.getInstance(NumberUtility.getInt(value));
    }

    public static final BigInteger printEarnedValueMethod(EarnedValueMethod value) {
        return value == null ? BigInteger.valueOf(0L) : BigInteger.valueOf(value.getValue());
    }

    public static final EarnedValueMethod parseEarnedValueMethod(Number value) {
        return EarnedValueMethod.getInstance(NumberUtility.getInt(value));
    }

    public static final BigDecimal printUnits(Number value) {
        return value == null ? BIGDECIMAL_ONE : new BigDecimal(value.doubleValue() / 100.0);
    }

    public static final Number parseUnits(Number value) {
        return value == null ? null : NumberUtility.getDouble(value.doubleValue() * 100.0);
    }

    public static final BigInteger printTimeUnit(TimeUnit value) {
        return BigInteger.valueOf(value == null ? 3L : (long)(value.getValue() + 1));
    }

    public static final TimeUnit parseTimeUnit(Number value) {
        return TimeUnit.getInstance(NumberUtility.getInt(value) - 1);
    }

    public static final Calendar printDate(Date value) {
        Calendar cal = null;
        if (value != null) {
            cal = Calendar.getInstance();
            cal.setTime(value);
        }
        return cal;
    }

    public static final Date parseDate(Calendar value) {
        Date result = null;
        if (value != null) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, value.get(1));
            cal.set(2, value.get(2));
            cal.set(5, value.get(5));
            cal.set(11, value.get(11));
            cal.set(12, value.get(12));
            cal.set(13, value.get(13));
            cal.set(14, value.get(14));
            result = cal.getTime();
        }
        return result;
    }

    public static final Calendar printTime(Date value) {
        Calendar cal = null;
        if (value != null) {
            cal = Calendar.getInstance();
            cal.setTime(value);
        }
        return cal;
    }

    public static final Date parseTime(Calendar value) {
        Date result = null;
        if (value != null) {
            Calendar cal = Calendar.getInstance();
            cal.set(11, value.get(11));
            cal.set(12, value.get(12));
            cal.set(13, value.get(13));
            cal.set(14, value.get(14));
            result = cal.getTime();
        }
        return result;
    }

    public static final TimeUnit parseWorkUnits(BigInteger value) {
        TimeUnit result = TimeUnit.HOURS;
        if (value != null) {
            switch (value.intValue()) {
                case 1: {
                    result = TimeUnit.MINUTES;
                    break;
                }
                case 3: {
                    result = TimeUnit.DAYS;
                    break;
                }
                case 4: {
                    result = TimeUnit.WEEKS;
                    break;
                }
                case 5: {
                    result = TimeUnit.MONTHS;
                    break;
                }
                case 7: {
                    result = TimeUnit.YEARS;
                    break;
                }
                default: {
                    result = TimeUnit.HOURS;
                }
            }
        }
        return result;
    }

    public static final BigInteger printWorkUnits(TimeUnit value) {
        int result;
        if (value == null) {
            value = TimeUnit.HOURS;
        }
        switch (value.getValue()) {
            case 0: {
                result = 1;
                break;
            }
            case 2: {
                result = 3;
                break;
            }
            case 3: {
                result = 4;
                break;
            }
            case 4: {
                result = 5;
                break;
            }
            case 5: {
                result = 7;
                break;
            }
            default: {
                result = 2;
            }
        }
        return BigInteger.valueOf(result);
    }

    public static final MPXDuration parseDuration(MSPDIFile file, TimeUnit defaultUnits, String value) {
        MPXDuration result = null;
        if (value != null && value.length() != 0) {
            XsdDuration xsd = new XsdDuration(value);
            TimeUnit units = TimeUnit.DAYS;
            if (xsd.getSeconds() != 0.0 || xsd.getMinutes() != 0) {
                units = TimeUnit.MINUTES;
            }
            if (xsd.getHours() != 0) {
                units = TimeUnit.HOURS;
            }
            if (xsd.getDays() != 0) {
                units = TimeUnit.DAYS;
            }
            if (xsd.getMonths() != 0) {
                units = TimeUnit.MONTHS;
            }
            if (xsd.getYears() != 0) {
                units = TimeUnit.YEARS;
            }
            double duration = 0.0;
            switch (units.getValue()) {
                case 5: {
                    duration += (double)xsd.getYears();
                    duration += (double)(xsd.getMonths() / 12);
                    duration += (double)(xsd.getDays() / 365);
                    duration += (double)(xsd.getHours() / 8760);
                    duration += (double)(xsd.getMinutes() / 525600);
                    duration += xsd.getSeconds() / 3.1536E7;
                    duration *= (double)(file.getDefaultHoursPerWeek() * 52.0f);
                    break;
                }
                case 12: {
                    duration += (double)xsd.getYears();
                    duration += (double)(xsd.getMonths() / 12);
                    duration += (double)(xsd.getDays() / 365);
                    duration += (double)(xsd.getHours() / 8760);
                    duration += (double)(xsd.getMinutes() / 525600);
                    duration += xsd.getSeconds() / 3.1536E7;
                    duration *= 8736.0;
                    break;
                }
                case 4: {
                    duration += (double)(xsd.getYears() * 12);
                    duration += (double)xsd.getMonths();
                    duration += (double)(xsd.getDays() / 30);
                    duration += (double)(xsd.getHours() / 720);
                    duration += (double)(xsd.getMinutes() / 43200);
                    duration += xsd.getSeconds() / 2592000.0;
                    duration *= (double)(file.getDefaultHoursPerWeek() * 4.0f);
                    break;
                }
                case 11: {
                    duration += (double)(xsd.getYears() * 12);
                    duration += (double)xsd.getMonths();
                    duration += (double)(xsd.getDays() / 30);
                    duration += (double)(xsd.getHours() / 720);
                    duration += (double)(xsd.getMinutes() / 43200);
                    duration += xsd.getSeconds() / 2592000.0;
                    duration *= 672.0;
                    break;
                }
                case 3: {
                    duration += (double)(xsd.getYears() * 52);
                    duration += (double)(xsd.getMonths() * 4);
                    duration += (double)(xsd.getDays() / 7);
                    duration += (double)(xsd.getHours() / 168);
                    duration += (double)(xsd.getMinutes() / 10080);
                    duration += xsd.getSeconds() / 604800.0;
                    duration *= (double)file.getDefaultHoursPerWeek();
                    break;
                }
                case 10: {
                    duration += (double)(xsd.getYears() * 52);
                    duration += (double)(xsd.getMonths() * 4);
                    duration += (double)(xsd.getDays() / 7);
                    duration += (double)(xsd.getHours() / 168);
                    duration += (double)(xsd.getMinutes() / 10080);
                    duration += xsd.getSeconds() / 604800.0;
                    duration *= 168.0;
                    break;
                }
                case 2: {
                    duration += (double)(xsd.getYears() * 365);
                    duration += (double)(xsd.getMonths() * 30);
                    duration += (double)xsd.getDays();
                    duration += (double)(xsd.getHours() / 24);
                    duration += (double)(xsd.getMinutes() / 1440);
                    duration += xsd.getSeconds() / 86400.0;
                    duration *= (double)file.getDefaultHoursPerDay();
                    break;
                }
                case 9: {
                    duration += (double)(xsd.getYears() * 365);
                    duration += (double)(xsd.getMonths() * 30);
                    duration += (double)xsd.getDays();
                    duration += (double)(xsd.getHours() / 24);
                    duration += (double)(xsd.getMinutes() / 1440);
                    duration += xsd.getSeconds() / 86400.0;
                    duration *= 24.0;
                    break;
                }
                case 1: 
                case 8: {
                    duration += (double)(xsd.getYears() * 8760);
                    duration += (double)(xsd.getMonths() * 720);
                    duration += (double)(xsd.getDays() * 24);
                    duration += (double)xsd.getHours();
                    duration += (double)(xsd.getMinutes() / 60);
                    duration += xsd.getSeconds() / 3600.0;
                    break;
                }
                case 0: 
                case 7: {
                    duration += (double)(xsd.getYears() * 525600);
                    duration += (double)(xsd.getMonths() * 43200);
                    duration += (double)(xsd.getDays() * 1440);
                    duration += (double)(xsd.getHours() * 60);
                    duration += (double)xsd.getMinutes();
                    duration += xsd.getSeconds() / 60.0;
                    duration /= 60.0;
                }
            }
            units = defaultUnits == null ? file.getDefaultDurationUnits() : defaultUnits;
            if (units != TimeUnit.HOURS && units != TimeUnit.ELAPSED_HOURS) {
                switch (units.getValue()) {
                    case 0: 
                    case 7: {
                        duration *= 60.0;
                        break;
                    }
                    case 2: {
                        duration /= (double)file.getDefaultHoursPerDay();
                        break;
                    }
                    case 9: {
                        duration /= 24.0;
                        break;
                    }
                    case 3: {
                        duration /= (double)file.getDefaultHoursPerWeek();
                        break;
                    }
                    case 10: {
                        duration /= 168.0;
                        break;
                    }
                    case 4: {
                        duration /= (double)(file.getDefaultHoursPerWeek() * 4.0f);
                        break;
                    }
                    case 11: {
                        duration /= 672.0;
                        break;
                    }
                    case 5: {
                        duration /= (double)(file.getDefaultHoursPerWeek() * 52.0f);
                        break;
                    }
                    case 12: {
                        duration /= 8736.0;
                    }
                }
            }
            result = MPXDuration.getInstance(duration, units);
        }
        return result;
    }

    public static final String printDuration(MSPDIFile file, MPXDuration duration) {
        String result = null;
        if (duration == null) {
            result = ZERO_DURATION;
        } else {
            TimeUnit durationType = duration.getUnits();
            if (!file.getMicrosoftProjectCompatibleOutput() || durationType.getValue() == 1 || durationType.getValue() == 8) {
                result = new XsdDuration(duration).toString();
            } else {
                double hours = duration.getDuration();
                switch (durationType.getValue()) {
                    case 0: 
                    case 7: {
                        hours = duration.getDuration() / 60.0;
                        break;
                    }
                    case 2: {
                        hours *= (double)file.getDefaultHoursPerDay();
                        break;
                    }
                    case 9: {
                        hours *= 24.0;
                        break;
                    }
                    case 3: {
                        hours *= (double)file.getDefaultHoursPerWeek();
                        break;
                    }
                    case 10: {
                        hours *= 168.0;
                        break;
                    }
                    case 4: {
                        hours *= (double)(file.getDefaultHoursPerWeek() * 4.0f);
                        break;
                    }
                    case 11: {
                        hours *= 672.0;
                        break;
                    }
                    case 5: {
                        hours *= (double)(file.getDefaultHoursPerWeek() * 52.0f);
                        break;
                    }
                    case 12: {
                        hours *= 8736.0;
                    }
                }
                result = new XsdDuration(MPXDuration.getInstance(hours, TimeUnit.HOURS)).toString();
            }
        }
        return result;
    }

    public static final BigInteger printDurationTimeUnits(MPXDuration duration) {
        BigInteger result = null;
        if (duration != null) {
            result = DatatypeConverter.printDurationTimeUnits(duration.getUnits());
        }
        return result;
    }

    public static final Number parseCurrency(Number value) {
        return value == null ? null : NumberUtility.getDouble(value.doubleValue() / 100.0);
    }

    public static final BigDecimal printCurrency(Number value) {
        return value == null ? BIGDECIMAL_ZERO : new BigDecimal(value.doubleValue() * 100.0);
    }

    public static final TimeUnit parseDurationTimeUnits(BigInteger value) {
        TimeUnit result = TimeUnit.HOURS;
        if (value != null) {
            switch (value.intValue()) {
                case 3: 
                case 35: {
                    result = TimeUnit.MINUTES;
                    break;
                }
                case 4: 
                case 36: {
                    result = TimeUnit.ELAPSED_MINUTES;
                    break;
                }
                case 5: 
                case 37: {
                    result = TimeUnit.HOURS;
                    break;
                }
                case 6: 
                case 38: {
                    result = TimeUnit.ELAPSED_HOURS;
                    break;
                }
                case 7: 
                case 39: {
                    result = TimeUnit.DAYS;
                    break;
                }
                case 8: 
                case 40: {
                    result = TimeUnit.ELAPSED_DAYS;
                    break;
                }
                case 9: 
                case 41: {
                    result = TimeUnit.WEEKS;
                    break;
                }
                case 10: 
                case 42: {
                    result = TimeUnit.ELAPSED_WEEKS;
                    break;
                }
                case 11: 
                case 43: {
                    result = TimeUnit.MONTHS;
                    break;
                }
                case 12: 
                case 44: {
                    result = TimeUnit.ELAPSED_MONTHS;
                    break;
                }
                case 19: 
                case 51: {
                    result = TimeUnit.PERCENT;
                    break;
                }
                case 20: 
                case 52: {
                    result = TimeUnit.ELAPSED_PERCENT;
                }
            }
        }
        return result;
    }

    public static final BigInteger printDurationTimeUnits(TimeUnit value) {
        int result;
        if (value == null) {
            value = TimeUnit.HOURS;
        }
        switch (value.getValue()) {
            case 0: {
                result = 3;
                break;
            }
            case 7: {
                result = 4;
                break;
            }
            case 8: {
                result = 6;
                break;
            }
            case 2: {
                result = 7;
                break;
            }
            case 9: {
                result = 8;
                break;
            }
            case 3: {
                result = 9;
                break;
            }
            case 10: {
                result = 10;
                break;
            }
            case 4: {
                result = 11;
                break;
            }
            case 11: {
                result = 12;
                break;
            }
            case 6: {
                result = 19;
                break;
            }
            case 13: {
                result = 20;
                break;
            }
            default: {
                result = 5;
            }
        }
        return BigInteger.valueOf(result);
    }

    public static final Priority parsePriority(BigInteger priority) {
        return Priority.getInstance(priority.intValue());
    }

    public static final BigInteger printPriority(Priority priority) {
        int result = 500;
        if (priority != null) {
            result = priority.getValue();
        }
        return BigInteger.valueOf(result);
    }

    public static final MPXDuration parseDurationInMinutes(Number value) {
        MPXDuration result = null;
        if (value != null) {
            result = MPXDuration.getInstance(value.intValue() / 1000, TimeUnit.MINUTES);
        }
        return result;
    }

    public static final double printDurationInMinutes(MPXDuration duration) {
        double result = 0.0;
        if (duration != null) {
            result = duration.getDuration();
            switch (duration.getUnits().getValue()) {
                case 1: 
                case 8: {
                    result *= 60.0;
                    break;
                }
                case 2: 
                case 9: {
                    result *= 480.0;
                    break;
                }
                case 3: 
                case 10: {
                    result *= 2400.0;
                    break;
                }
                case 4: 
                case 11: {
                    result *= 9600.0;
                    break;
                }
                case 5: 
                case 12: {
                    result *= 124800.0;
                }
            }
        }
        return result;
    }

    public static final BigDecimal printRate(MPXRate rate) {
        return rate == null ? null : new BigDecimal(rate.getAmount());
    }

    public static final MPXRate parseRate(BigDecimal value) {
        MPXRate result = null;
        if (value != null) {
            result = new MPXRate(value, TimeUnit.HOURS);
        }
        return result;
    }

    public static final BigInteger printDay(Day day) {
        return day == null ? null : BigInteger.valueOf(day.getValue() - 1);
    }

    public static final Day parseDay(Number value) {
        return Day.getInstance(NumberUtility.getInt(value) + 1);
    }

    public static final ConstraintType parseConstraintType(Number value) {
        return ConstraintType.getInstance(value);
    }

    public static final BigInteger printConstraintType(ConstraintType value) {
        return value == null ? null : BigInteger.valueOf(value.getType());
    }

    private static final NumberFormat getNumberFormat() {
        NumberFormat format = (NumberFormat)NUMBER_FORMAT.get();
        if (format == null) {
            format = new DecimalFormat("#.##");
            NUMBER_FORMAT.set(format);
        }
        return format;
    }

    private static final DateFormat getDateFormat() {
        DateFormat df = (DateFormat)DATE_FORMAT.get();
        if (df == null) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            df.setLenient(false);
        }
        return df;
    }
}

