/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.msproject;

import java.io.File;
import java.util.Arrays;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.export.ExportFinalizationJob;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.DefaultEnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.language.GanttLanguage;
import org.ganttproject.impex.msproject.GanttMPXSaver;
import org.ganttproject.impex.msproject.GanttMSPDISaver;
import org.ganttproject.impex.msproject.LocaleOption;

public class ExporterToMsProjectFile
implements Exporter {
    private static final String[] FILE_FORMAT_IDS = new String[]{"impex.msproject.fileformat.mpx", "impex.msproject.fileformat.mspdi"};
    private static final String[] FILE_EXTENSIONS = new String[]{"mpx", "xml"};
    private String myFileFormat = FILE_FORMAT_IDS[0];
    private EnumerationOption myFileFormatOption = new DefaultEnumerationOption("impex.msproject.fileformat", FILE_FORMAT_IDS){

        public void commit() {
            super.commit();
            ExporterToMsProjectFile.this.myFileFormat = this.getValue();
        }
    };
    private LocaleOption myLanguageOption = new LocaleOption();
    private GPOptionGroup myOptions = new GPOptionGroup("exporter.msproject", new GPOption[]{this.myFileFormatOption});
    private GPOptionGroup myMPXOptions = new GPOptionGroup("exporter.msproject.mpx", new GPOption[]{this.myLanguageOption});
    private IGanttProject myProject;
    private UIFacade myUIFacade;

    public ExporterToMsProjectFile() {
        this.myOptions.setTitled(false);
        this.myMPXOptions.setTitled(false);
        this.myFileFormatOption.lock();
        this.myFileFormatOption.setValue(FILE_FORMAT_IDS[0]);
        this.myFileFormatOption.commit();
    }

    public String getFileTypeDescription() {
        return GanttLanguage.getInstance().getText("impex.msproject.description");
    }

    public GPOptionGroup getOptions() {
        return this.myOptions;
    }

    public GPOptionGroup[] getSecondaryOptions() {
        GPOptionGroup[] gPOptionGroupArray;
        if (FILE_FORMAT_IDS[0].equals(this.myFileFormat)) {
            GPOptionGroup[] gPOptionGroupArray2 = new GPOptionGroup[1];
            gPOptionGroupArray = gPOptionGroupArray2;
            gPOptionGroupArray2[0] = this.myMPXOptions;
        } else {
            gPOptionGroupArray = null;
        }
        return gPOptionGroupArray;
    }

    public String getFileNamePattern() {
        return this.myFileFormat;
    }

    public void setContext(IGanttProject project, UIFacade uiFacade) {
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.myLanguageOption = new LocaleOption();
        this.myMPXOptions = new GPOptionGroup("exporter.msproject.mpx", new GPOption[]{this.myLanguageOption});
        this.myLanguageOption.lock();
        this.myLanguageOption.setSelectedLocale(GanttLanguage.getInstance().getLocale());
        this.myLanguageOption.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(File outputFile, ExportFinalizationJob finalizationJob) throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.myUIFacade.setStatusText("msproject-export");
            if (FILE_FORMAT_IDS[0].equals(this.myFileFormat)) {
                if (this.myLanguageOption.getSelectedLocale() != null) {
                    GanttMPXSaver saver = new GanttMPXSaver(this.myProject, this.myLanguageOption.getSelectedLocale());
                    saver.save(outputFile);
                }
            } else if (FILE_FORMAT_IDS[1].equals(this.myFileFormat)) {
                GanttMSPDISaver saver = new GanttMSPDISaver(this.myProject);
                saver.save(outputFile);
            }
            finalizationJob.run(new File[]{outputFile});
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public String proposeFileExtension() {
        return this.getSelectedFormatExtension();
    }

    private String getSelectedFormatExtension() {
        for (int i = 0; i < FILE_FORMAT_IDS.length; ++i) {
            if (!this.myFileFormat.equals(FILE_FORMAT_IDS[i])) continue;
            return FILE_EXTENSIONS[i];
        }
        throw new IllegalStateException("Selected format=" + this.myFileFormat + " has not been found in known formats:" + Arrays.asList(FILE_FORMAT_IDS));
    }

    public String[] getFileExtensions() {
        return FILE_EXTENSIONS;
    }
}

