/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.msproject;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import net.sourceforge.ganttproject.gui.options.TopPanel;
import net.sourceforge.ganttproject.language.GanttLanguage;

class LocaleChooserPanel
extends JPanel {
    private LocalePanel localePanel = null;
    private static GanttLanguage lang = GanttLanguage.getInstance();

    public LocaleChooserPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(new EmptyBorder(0, 5, 0, 5));
        TopPanel topPanel = new TopPanel(lang.getText("mpxLanguageSettings"), lang.getText("mpxLanguageSettingsComment"));
        topPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)topPanel, "North");
        this.localePanel = new LocalePanel();
        result.add((Component)((Object)this.localePanel), "Center");
        this.add(result);
    }

    public Locale getSelectedLocale() {
        return this.localePanel.getSelectedLocale();
    }

    static class LocalePanel
    extends GeneralOptionPanel {
        private static final String LOCALE_FR = "Fran\u0413ais";
        private static final String LOCALE_EN = "English";
        private static Map mapLocales = null;
        private JComboBox combo = new JComboBox(new Vector(mapLocales.keySet()));

        public LocalePanel() {
            super("", "");
            this.vb.add(this.combo);
            Locale currentLocale = GanttLanguage.getInstance().getLocale();
            try {
                this.combo.setSelectedItem(LocalePanel.getString(currentLocale));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean applyChanges(boolean askForApply) {
            return false;
        }

        public void initialize() {
        }

        Locale getSelectedLocale() {
            return (Locale)mapLocales.get(this.combo.getSelectedItem());
        }

        private static Locale getLocale(String locale) {
            return (Locale)mapLocales.get(locale);
        }

        private static String getString(Locale locale) {
            String res = null;
            Iterator it = mapLocales.keySet().iterator();
            while (it.hasNext() && !mapLocales.get(res = (String)it.next()).equals(locale)) {
            }
            return res;
        }

        static {
            mapLocales = new HashMap();
            mapLocales.put(LOCALE_EN, Locale.US);
            mapLocales.put(LOCALE_FR, Locale.FRANCE);
        }
    }
}

