/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.sourceforge.ganttproject.GanttImagePanel;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.action.task.LinkTasksAction;
import net.sourceforge.ganttproject.action.task.UnlinkTasksAction;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.gui.TaskTreeUIFacade;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;
import org.eclipse.core.runtime.IAdaptable;

class GanttChartTabContentPanel
implements IAdaptable {
    private JSplitPane mySplitPane;
    private Component myTaskTree;
    private Component myGanttChart;
    private final TaskTreeUIFacade myTreeFacade;
    private JPanel myTabContentPanel;
    private final IGanttProject myProject;
    private final UIFacade myWorkbenchFacade;

    GanttChartTabContentPanel(IGanttProject project, UIFacade workbenchFacade, TaskTreeUIFacade treeFacade, Component ganttChart) {
        this.myProject = project;
        this.myWorkbenchFacade = workbenchFacade;
        this.myTreeFacade = treeFacade;
        this.myTaskTree = treeFacade.getTreeComponent();
        this.myGanttChart = ganttChart;
    }

    Component getComponent() {
        if (this.myTabContentPanel == null) {
            JPanel left = new JPanel(new BorderLayout());
            Box treeHeader = Box.createVerticalBox();
            GanttImagePanel but = new GanttImagePanel("big.png", 300, 42);
            treeHeader.add(but);
            left.add((Component)treeHeader, "North");
            left.add(this.myTaskTree, "Center");
            left.setPreferredSize(new Dimension(315, 600));
            left.setBackground(new Color(102, 153, 153));
            JPanel right = new JPanel(new BorderLayout());
            right.add(this.myGanttChart, "Center");
            this.mySplitPane = new JSplitPane(1);
            if (GanttLanguage.getInstance().getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                this.mySplitPane.setLeftComponent(left);
                this.mySplitPane.setRightComponent(right);
                this.mySplitPane.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                this.mySplitPane.setRightComponent(left);
                this.mySplitPane.setLeftComponent(right);
                this.mySplitPane.setDividerLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - left.getPreferredSize().getWidth()));
                this.mySplitPane.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            this.mySplitPane.setOneTouchExpandable(true);
            this.mySplitPane.setPreferredSize(new Dimension(800, 500));
            this.myTabContentPanel = new JPanel(new BorderLayout());
            this.myTabContentPanel.add(this.createButtonPanel(), "North");
            this.myTabContentPanel.add((Component)this.mySplitPane, "Center");
        }
        return this.myTabContentPanel;
    }

    private Component createButtonPanel() {
        Box buttonBar = Box.createHorizontalBox();
        TestGanttRolloverButton unindentButton = new TestGanttRolloverButton(this.myTreeFacade.getUnindentAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add(unindentButton);
        TestGanttRolloverButton indentButton = new TestGanttRolloverButton(this.myTreeFacade.getIndentAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add(indentButton);
        buttonBar.add(Box.createHorizontalStrut(3));
        TestGanttRolloverButton upButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveUpAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add(upButton);
        TestGanttRolloverButton downButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveDownAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add(downButton);
        buttonBar.add(Box.createHorizontalStrut(8));
        LinkTasksAction linkAction = new LinkTasksAction(this.myProject.getTaskManager(), Mediator.getTaskSelectionManager(), this.myWorkbenchFacade);
        this.myTreeFacade.setLinkTasksAction(linkAction);
        TestGanttRolloverButton linkButton = new TestGanttRolloverButton(linkAction){

            public String getText() {
                return null;
            }
        };
        buttonBar.add(linkButton);
        UnlinkTasksAction unlinkAction = new UnlinkTasksAction(this.myProject.getTaskManager(), Mediator.getTaskSelectionManager(), this.myWorkbenchFacade);
        this.myTreeFacade.setUnlinkTasksAction(unlinkAction);
        TestGanttRolloverButton unlinkButton = new TestGanttRolloverButton(unlinkAction){

            public String getText() {
                return null;
            }
        };
        buttonBar.add(unlinkButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)buttonBar, "West");
        return buttonPanel;
    }

    int getDividerLocation() {
        return this.mySplitPane.getDividerLocation();
    }

    void setDividerLocation(int location) {
        this.mySplitPane.setDividerLocation(location);
    }

    public Object getAdapter(Class adapter) {
        if (Container.class.equals(adapter)) {
            return this.getComponent();
        }
        if (Chart.class.equals(adapter)) {
            return this.myGanttChart;
        }
        return null;
    }
}

