/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.ganttproject.GanttImagePanel;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.ProjectEventListener;
import net.sourceforge.ganttproject.ResourceLoadGraphicArea;
import net.sourceforge.ganttproject.ResourceTreeTable;
import net.sourceforge.ganttproject.ResourceTreeTableModel;
import net.sourceforge.ganttproject.action.DeleteAssignmentAction;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.action.ResourceActionSet;
import net.sourceforge.ganttproject.action.resource.ResourcePropertiesAction;
import net.sourceforge.ganttproject.gui.GanttDialogInfo;
import net.sourceforge.ganttproject.gui.ResourceTreeUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.resource.AssignmentContext;
import net.sourceforge.ganttproject.resource.AssignmentNode;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceContext;
import net.sourceforge.ganttproject.resource.ResourceEvent;
import net.sourceforge.ganttproject.resource.ResourceNode;
import net.sourceforge.ganttproject.resource.ResourceView;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.util.BrowserControl;
import org.jdesktop.swing.treetable.TreeTableModel;

public class GanttResourcePanel
extends JPanel
implements ResourceView,
ResourceContext,
AssignmentContext,
ProjectEventListener,
ResourceTreeUIFacade {
    private final ResourceTreeTableModel model;
    private final ResourceTreeTable table;
    public final GanttProject appli;
    private GanttLanguage lang = GanttLanguage.getInstance();
    private JScrollBar vbar;
    private ResourceActionSet myResourceActionSet;
    public ResourceLoadGraphicArea area;
    private JScrollPane scrollpane;
    private JPanel left;
    private JPanel myImagePanel;
    private final ResourceContext myContext = this;
    private JSplitPane mySplitPane = null;
    private ProjectResource[] clipboard = null;
    private boolean isCut = false;
    private final GPAction myMoveUpAction = new GPAction(){

        protected String getIconFilePrefix() {
            return "up_";
        }

        public void actionPerformed(ActionEvent e) {
            GanttResourcePanel.this.upResource();
        }

        protected String getLocalizedName() {
            return this.getI18n("upTask");
        }
    };
    private GPAction myMoveDownAction = new GPAction(){

        protected String getIconFilePrefix() {
            return "down_";
        }

        public void actionPerformed(ActionEvent e) {
            GanttResourcePanel.this.downResource();
        }

        protected String getLocalizedName() {
            return this.getI18n("downTask");
        }
    };
    private GPAction myPropertiesAction = new GPAction(){

        protected String getIconFilePrefix() {
            return "";
        }

        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode[] selectedNodes = GanttResourcePanel.this.table.getSelectedNodes();
            if (selectedNodes.length != 1) {
                return;
            }
            if (selectedNodes[0] instanceof ResourceNode) {
                GanttResourcePanel.this.getResourcePropertiesAction().actionPerformed(null);
            } else if (selectedNodes[0] instanceof AssignmentNode) {
                AssignmentNode assignmentNode = (AssignmentNode)selectedNodes[0];
                Mediator.getTaskSelectionManager().clear();
                Mediator.getTaskSelectionManager().addTask(assignmentNode.getTask());
                GanttResourcePanel.this.getTaskPropertiesAction().actionPerformed(null);
            }
        }

        protected String getLocalizedName() {
            return "";
        }
    };
    private final ListSelectionListener myContextListener;
    private final ResourcePropertiesAction myResourcePropertiesAction;
    private Action myTaskPropertiesAction;
    private final UIFacade myUIFacade;
    private final DeleteAssignmentAction myDeleteAssignmentAction;

    public GanttResourcePanel(final GanttProject prj, GanttTree2 tree, UIFacade uiFacade) {
        this.myUIFacade = uiFacade;
        this.myDeleteAssignmentAction = new DeleteAssignmentAction(prj.getProject().getHumanResourceManager(), this, prj);
        prj.addProjectEventListener(this);
        this.appli = prj;
        this.model = new ResourceTreeTableModel(this.appli.getHumanResourceManager());
        this.table = new ResourceTreeTable((TreeTableModel)this.model);
        this.setLayout(new BorderLayout());
        GanttImagePanel but = new GanttImagePanel("big.png", 300, 42);
        this.myImagePanel = but;
        this.left = new JPanel(new BorderLayout());
        this.table.setRowHeight(20);
        this.left.add((Component)but, "North");
        this.left.setBackground(new Color(102, 153, 153));
        this.scrollpane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollpane, "Center");
        this.scrollpane.getViewport().add((Component)((Object)this.table));
        this.scrollpane.setVerticalScrollBarPolicy(21);
        this.vbar = this.table.getVerticalScrollBar();
        final JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)this.vbar, "Center");
        jp.setBorder(BorderFactory.createEtchedBorder(1));
        jp.setVisible(false);
        this.vbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (GanttResourcePanel.this.table.getSize().getHeight() - 20.0 < (double)e.getAdjustable().getMaximum()) {
                    jp.setVisible(true);
                } else {
                    jp.setVisible(false);
                }
                GanttResourcePanel.this.repaint();
            }
        });
        this.left.add((Component)jp, "West");
        this.vbar.addAdjustmentListener(new GanttAdjustmentListener());
        this.left.add((Component)this.scrollpane, "Center");
        this.mySplitPane = new JSplitPane(1);
        this.area = new ResourceLoadGraphicArea(prj, prj.getZoomManager()){

            protected int getHeaderHeight() {
                return GanttResourcePanel.this.myImagePanel.getHeight() + GanttResourcePanel.this.table.getTable().getTableHeader().getHeight();
            }

            public boolean isExpanded(ProjectResource pr) {
                return GanttResourcePanel.this.getResourceTreeTable().isExpanded(pr);
            }
        };
        prj.getZoomManager().addZoomListener(this.area.getZoomListener());
        this.area.getChartModel().setRowHeight(this.table.getRowHeight());
        if (this.lang.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
            this.mySplitPane.setLeftComponent(this.left);
            this.mySplitPane.setRightComponent(this.area);
        } else {
            this.mySplitPane.setRightComponent(this.left);
            this.mySplitPane.setLeftComponent(this.area);
            this.mySplitPane.setDividerLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - this.left.getPreferredSize().getWidth()));
        }
        this.mySplitPane.setOneTouchExpandable(true);
        this.mySplitPane.setPreferredSize(new Dimension(800, 500));
        this.add((Component)this.mySplitPane, "Center");
        this.scrollpane.getViewport().setBackground(new Color(1.0f, 1.0f, 1.0f));
        this.left.setBackground(new Color(1.0f, 1.0f, 1.0f));
        this.table.setBackground(new Color(1.0f, 1.0f, 1.0f));
        this.table.setSelectionMode(0);
        this.setBackground(new Color(0.0f, 0.0f, 0.0f));
        this.applyComponentOrientation(this.lang.getComponentOrientation());
        this.table.addKeyListener(prj);
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                GanttResourcePanel.this.handlePopupTrigger(e);
            }

            public void mouseReleased(MouseEvent e) {
                GanttResourcePanel.this.handlePopupTrigger(e);
            }

            public void mouseClicked(MouseEvent e) {
                e.consume();
                TreePath selPath = GanttResourcePanel.this.table.getTreeTable().getPathForLocation(e.getX(), e.getY());
                if (selPath != null) {
                    GanttResourcePanel.this.table.getTreeTable().getTree().setSelectionPath(selPath);
                }
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    GanttResourcePanel.this.handleDoubleClick(e);
                } else {
                    GanttResourcePanel.this.handlePopupTrigger(e);
                }
            }
        };
        this.table.getInputMap(2).put(KeyStroke.getKeyStroke(10, 512), "properties");
        this.table.getActionMap().put("properties", this.myPropertiesAction);
        this.table.getInputMap(2).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.table.getActionMap().put("delete", this.myDeleteAssignmentAction);
        this.table.getInputMap(2).put(GPAction.getKeyStroke("newArtifact.shortcut"), "newHuman");
        this.table.getActionMap().put("newHuman", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                prj.newHumanResource();
            }
        });
        if (!prj.isOnlyViewer) {
            this.table.addMouseListener(ml);
            this.table.getTreeTable().getParent().addMouseListener(ml);
        }
        this.myResourcePropertiesAction = new ResourcePropertiesAction(prj.getProject(), prj.getUIFacade());
        this.myContextListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GanttResourcePanel.this.myResourcePropertiesAction.setContext(GanttResourcePanel.this.getContext());
            }
        };
        this.table.getTable().getSelectionModel().addListSelectionListener(this.myContextListener);
    }

    public void setActions() {
        this.table.setAction(this.appli.getCopyAction());
        this.table.setAction(this.appli.getPasteAction());
        this.table.setAction(this.appli.getCutAction());
    }

    private void handlePopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            DefaultMutableTreeNode[] selectedNodes = this.table.getSelectedNodes();
            if (selectedNodes.length == 0) {
                return;
            }
            if (selectedNodes.length == 1 && selectedNodes[0] instanceof AssignmentNode) {
                AssignmentNode assignmentNode = (AssignmentNode)selectedNodes[0];
                Mediator.getTaskSelectionManager().clear();
                Mediator.getTaskSelectionManager().addTask(assignmentNode.getTask());
                Point popupPoint = this.getPopupMenuPoint(e);
                this.getUIFacade().showPopupMenu(this, new Action[]{this.getTaskPropertiesAction(), this.myDeleteAssignmentAction}, popupPoint.x, popupPoint.y);
            } else {
                this.createPopupMenu(e);
            }
        }
    }

    private void handleDoubleClick(MouseEvent e) {
        this.myPropertiesAction.actionPerformed(null);
    }

    private Point getPopupMenuPoint(MouseEvent popupTriggerEvent) {
        int x = popupTriggerEvent.getX() - this.scrollpane.getHorizontalScrollBar().getValue() + (this.vbar.isVisible() ? this.vbar.getWidth() : 0);
        int y = popupTriggerEvent.getY() + this.table.getRowHeight() + this.myImagePanel.getHeight();
        return new Point(x, y);
    }

    private void createPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        AbstractAction[] resourceActions = this.myResourceActionSet.getActions();
        menu.add(this.myResourcePropertiesAction);
        for (int i = 0; i < resourceActions.length; ++i) {
            menu.add(resourceActions[i]);
        }
        menu.add(this.appli.createNewItem(GanttProject.correctLabel(this.lang.getText("sendMail")), "/icons/send_mail_16.gif"));
        menu.addSeparator();
        menu.add(this.myMoveUpAction);
        menu.add(this.myMoveDownAction);
        menu.addSeparator();
        menu.add(this.appli.getCutAction());
        menu.add(this.appli.getCopyAction());
        menu.add(this.appli.getPasteAction());
        menu.applyComponentOrientation(this.lang.getComponentOrientation());
        Point popupPoint = this.getPopupMenuPoint(e);
        menu.show(this, popupPoint.x, popupPoint.y);
    }

    public void refresh(GanttLanguage language) {
        this.lang = language;
        this.model.changeLanguage(this.lang);
    }

    public void resourceAdded(ResourceEvent event) {
        this.newHuman((HumanResource)event.getResource());
    }

    public void resourcesRemoved(ResourceEvent event) {
        this.model.deleteResources(event.getResources());
    }

    public void resourceChanged(ResourceEvent e) {
        this.model.resourceChanged(e.getResource());
    }

    public void resourceAssignmentsChanged(ResourceEvent e) {
        this.model.resourceAssignmentsChanged(e.getResources());
    }

    public ProjectResource[] getResources() {
        int i;
        DefaultMutableTreeNode[] tNodes = this.table.getSelectedNodes();
        if (tNodes == null) {
            return new ProjectResource[0];
        }
        int nbProjectResource = 0;
        for (i = 0; i < tNodes.length; ++i) {
            if (!(tNodes[i] instanceof ResourceNode)) continue;
            ++nbProjectResource;
        }
        ProjectResource[] res = new ProjectResource[nbProjectResource];
        for (i = 0; i < nbProjectResource; ++i) {
            if (!(tNodes[i] instanceof ResourceNode)) continue;
            res[i] = (ProjectResource)((ResourceNode)tNodes[i]).getUserObject();
        }
        return res;
    }

    public void newHuman(HumanResource people) {
        if (people != null) {
            DefaultMutableTreeNode result = this.model.addResource(people);
            this.table.getTree().scrollPathToVisible(new TreePath(result.getPath()));
        }
    }

    public void sendMail(GanttProject parent) {
        if (this.table != null && this.table.getSelectedNodes() != null && this.table.getSelectedNodes().length > 0) {
            HumanResource people = (HumanResource)this.table.getSelectedNodes()[0].getUserObject();
            if (people != null) {
                try {
                    BrowserControl.displayURL("mailto:" + people.getMail());
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        } else {
            GanttDialogInfo gdi = new GanttDialogInfo(this.appli, 2, GanttDialogInfo.YES_OPTION, GanttLanguage.getInstance().getText("msg26"), GanttLanguage.getInstance().getText("sendMail"));
            gdi.show();
        }
    }

    private void upResource() {
        ResourceNode rn;
        int index;
        DefaultMutableTreeNode[] selectedNodes = this.table.getSelectedNodes();
        if (selectedNodes.length == 0) {
            return;
        }
        DefaultMutableTreeNode selectedNode = selectedNodes[0];
        if (selectedNode instanceof ResourceNode && (index = (rn = (ResourceNode)selectedNode).getParent().getIndex(rn)) > 0) {
            HumanResource people = (HumanResource)selectedNodes[0].getUserObject();
            this.model.moveUp(people);
        }
    }

    private void downResource() {
        ResourceNode rn;
        int index;
        DefaultMutableTreeNode[] selectedNodes = this.table.getSelectedNodes();
        if (selectedNodes.length == 0) {
            return;
        }
        DefaultMutableTreeNode selectedNode = selectedNodes[0];
        if (selectedNode instanceof ResourceNode && (index = (rn = (ResourceNode)selectedNode).getParent().getIndex(rn)) < rn.getParent().getChildCount() - 1) {
            HumanResource people = (HumanResource)selectedNodes[0].getUserObject();
            this.model.moveDown(people);
        }
    }

    public List getPeople() {
        return this.model.getAllResouces();
    }

    public ResourceTreeTable getResourceTreeTable() {
        return this.table;
    }

    public ResourceTreeTableModel getResourceTreeTableModel() {
        return this.model;
    }

    public int nbPeople() {
        return this.model.getAllResouces().size();
    }

    public void reset() {
        this.model.reset();
    }

    public void setResourceActions(ResourceActionSet actionSet) {
        this.myResourceActionSet = actionSet;
    }

    public ResourceContext getContext() {
        return this.myContext;
    }

    public ResourceAssignment[] getResourceAssignments() {
        ResourceAssignment[] res = null;
        DefaultMutableTreeNode[] tNodes = this.table.getSelectedNodes();
        if (tNodes != null) {
            int i;
            int nbAssign = 0;
            for (i = 0; i < tNodes.length; ++i) {
                if (!(tNodes[i] instanceof AssignmentNode)) continue;
                ++nbAssign;
            }
            res = new ResourceAssignment[nbAssign];
            for (i = 0; i < nbAssign; ++i) {
                if (!(tNodes[i] instanceof AssignmentNode)) continue;
                res[i] = (ResourceAssignment)((AssignmentNode)tNodes[i]).getUserObject();
            }
        }
        return res;
    }

    public void setDividerLocation(int location) {
        this.mySplitPane.setDividerLocation(location);
    }

    public int getDividerLocation() {
        return this.mySplitPane.getDividerLocation();
    }

    public void projectModified() {
    }

    public void projectSaved() {
    }

    public void projectClosed() {
        this.area.repaint();
        this.reset();
    }

    public void copySelection() {
        this.saveSelectionToClipboard(false);
        this.isCut = false;
    }

    public void cutSelection() {
        this.saveSelectionToClipboard(true);
        this.isCut = true;
    }

    public void pasteSelection() {
        if (this.clipboard == null) {
            return;
        }
        for (int i = 0; i < this.clipboard.length; ++i) {
            if (this.isCut) {
                this.appli.getHumanResourceManager().add(this.clipboard[i]);
                continue;
            }
            this.appli.getHumanResourceManager().add(this.clipboard[i].unpluggedClone());
        }
        if (this.isCut) {
            this.isCut = false;
        }
    }

    public void saveSelectionToClipboard(boolean cut) {
        DefaultMutableTreeNode[] selectedNodes = this.table.getSelectedNodes();
        if (selectedNodes == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (!(selectedNodes[i] instanceof ResourceNode)) continue;
            ++count;
        }
        this.clipboard = new ProjectResource[count];
        int index = 0;
        for (int i = 0; i < selectedNodes.length; ++i) {
            if (!(selectedNodes[i] instanceof ResourceNode)) continue;
            ResourceNode rn = (ResourceNode)selectedNodes[i];
            this.clipboard[index] = (HumanResource)rn.getUserObject();
            if (cut) {
                this.appli.getHumanResourceManager().remove(this.clipboard[index], this.appli.getUndoManager());
            }
            ++index;
        }
    }

    public Action getMoveUpAction() {
        return this.myMoveUpAction;
    }

    public Action getMoveDownAction() {
        return this.myMoveDownAction;
    }

    public Component getUIComponent() {
        return this;
    }

    public Action getResourcePropertiesAction() {
        return this.myResourcePropertiesAction;
    }

    void setTaskPropertiesAction(Action action) {
        this.myTaskPropertiesAction = action;
    }

    private Action getTaskPropertiesAction() {
        return this.myTaskPropertiesAction;
    }

    private UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    public class GanttAdjustmentListener
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (GanttResourcePanel.this.area != null) {
                GanttResourcePanel.this.area.setScrollBar(e.getValue());
                GanttResourcePanel.this.area.repaint();
            }
        }
    }
}

