/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.io.Serializable;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.task.TaskImpl;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskMutator;

public class GanttTask
extends TaskImpl
implements Serializable {
    public static int LOW = 0;
    public static int NORMAL = 1;
    public static int HIGHT = 2;

    public GanttTask(String name, GanttCalendar start, long length, TaskManager taskManager, int taskID) {
        super(taskManager, taskID);
        TaskMutator mutator = this.createMutator();
        mutator.setName(name);
        mutator.setStart(start);
        mutator.setDuration(taskManager.createLength(length));
        mutator.commit();
        this.enableEvents(true);
    }

    public GanttTask(GanttTask copy) {
        super(copy, false);
        this.enableEvents(true);
    }

    public GanttTask Clone() {
        return new GanttTask(this);
    }

    public int getLength() {
        return (int)this.getDuration().getLength();
    }

    public void setLength(int l) {
        if (l <= 0) {
            throw new IllegalArgumentException("Length of task must be >=0. You've passed length=" + l + " to task=" + this);
        }
        TaskMutator mutator = this.createMutator();
        mutator.setDuration(this.getManager().createLength(this.getDuration().getTimeUnit(), l));
        mutator.commit();
    }

    public void setTaskID(int taskID) {
        this.setTaskIDHack(taskID);
    }
}

