/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.action.ResourceAction;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.resource.ProjectResource;
import net.sourceforge.ganttproject.resource.ResourceContext;
import net.sourceforge.ganttproject.resource.ResourceManager;

public class DeleteHumanAction
extends ResourceAction {
    private final UIFacade myUIFacade;
    private final ResourceContext myContext;
    private static final String ICON_URL = "icons/delete_16.gif";
    private final int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private GanttProject myProjectFrame;

    public DeleteHumanAction(ResourceManager hrManager, ResourceContext context, GanttProject projectFrame, UIFacade uiFacade) {
        super(hrManager);
        this.myUIFacade = uiFacade;
        this.myProjectFrame = projectFrame;
        this.putValue("Name", GanttProject.correctLabel(this.getLanguage().getText("deleteHuman")));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(74, this.MENU_MASK));
        URL iconUrl = this.getClass().getClassLoader().getResource(ICON_URL);
        if (iconUrl != null) {
            this.putValue("SmallIcon", new ImageIcon(iconUrl));
        }
        this.myContext = context;
    }

    public void actionPerformed(ActionEvent event) {
        String title;
        String message;
        UIFacade.Choice choice;
        final ProjectResource[] context = this.getContext().getResources();
        if (context.length > 0 && (choice = this.myUIFacade.showConfirmationDialog(message = this.getLanguage().getText("msg6") + " " + this.getDisplayName(context) + "?", title = this.getLanguage().getText("question"))) == UIFacade.Choice.YES) {
            this.myUIFacade.getUndoManager().undoableEdit("Resource removed", new Runnable(){

                public void run() {
                    DeleteHumanAction.this.deleteResources(context);
                    DeleteHumanAction.this.getProjectFrame().repaint2();
                }
            });
        }
    }

    private GanttProject getProjectFrame() {
        return this.myProjectFrame;
    }

    private void deleteResources(ProjectResource[] context) {
        for (int i = 0; i < context.length; ++i) {
            context[i].delete();
        }
    }

    private String getDisplayName(ProjectResource[] resources) {
        if (resources.length == 1) {
            return resources[0].toString();
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < resources.length; ++i) {
            result.append(resources[i].toString());
            if (i >= resources.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    private ResourceContext getContext() {
        return this.myContext;
    }
}

