/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.gui.OpenFileDialog;
import net.sourceforge.ganttproject.io.GanttXMLOpen;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.parser.DependencyTagHandler;
import net.sourceforge.ganttproject.parser.ResourceTagHandler;
import net.sourceforge.ganttproject.parser.RoleTagHandler;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.task.TaskManager;

public class ImportResources
extends AbstractAction {
    private final TaskManager myTaskManager;
    private final ResourceManager myResourceManager;
    private final GanttProject myproject;
    private final RoleManager myRoleManager;
    private File startFile = null;

    public ImportResources(ResourceManager resourceManager, TaskManager taskManager, RoleManager roleManager, GanttProject project) {
        this.myTaskManager = taskManager;
        this.myRoleManager = roleManager;
        GanttLanguage language = GanttLanguage.getInstance();
        this.putValue("Name", language.getText("importResources"));
        this.myResourceManager = resourceManager;
        URL iconUrl = this.getClass().getClassLoader().getResource("icons/impres_16.gif");
        if (iconUrl != null) {
            this.putValue("SmallIcon", new ImageIcon(iconUrl));
        }
        this.myproject = project;
    }

    public void actionPerformed(ActionEvent event) {
        final File file = this.getResourcesFile();
        if (file != null) {
            Mediator.getUndoManager().undoableEdit("Import Resources", new Runnable(){

                public void run() {
                    GanttXMLOpen loader = new GanttXMLOpen(ImportResources.this.myTaskManager);
                    ResourceTagHandler tagHandler = new ResourceTagHandler(ImportResources.this.myResourceManager, ImportResources.this.myRoleManager);
                    DependencyTagHandler dependencyHandler = new DependencyTagHandler(loader.getContext(), ImportResources.this.myTaskManager, ImportResources.this.myproject.getUIFacade());
                    RoleTagHandler rolesHandler = new RoleTagHandler(RoleManager.Access.getInstance());
                    loader.addTagHandler(tagHandler);
                    loader.addTagHandler(dependencyHandler);
                    loader.addTagHandler(rolesHandler);
                    loader.load(file);
                }
            });
        }
    }

    private File getResourcesFile() {
        OpenFileDialog openDialog = this.startFile != null ? new OpenFileDialog(this.startFile.getPath()) : new OpenFileDialog(this.myproject);
        File result = openDialog.show();
        if (result != null) {
            this.startFile = result;
        }
        return result;
    }
}

