/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action;

import java.awt.event.ActionEvent;
import javax.swing.event.UndoableEditEvent;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.action.GPAction;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.undo.GPUndoListener;
import net.sourceforge.ganttproject.undo.GPUndoManager;

public class UndoAction
extends GPAction
implements GPUndoListener {
    private GPUndoManager myUndoManager;
    private final GanttProject appli;

    public UndoAction(GPUndoManager undoManager, String iconSize, GanttProject appli) {
        super(null, iconSize);
        this.myUndoManager = undoManager;
        this.myUndoManager.addUndoableEditListener(this);
        this.appli = appli;
        this.setEnabled(this.myUndoManager.canUndo());
    }

    public void actionPerformed(ActionEvent e) {
        this.appli.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("undo"));
        this.myUndoManager.undo();
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.setEnabled(this.myUndoManager.canUndo());
    }

    public void undoOrRedoHappened() {
        this.setEnabled(this.myUndoManager.canUndo());
    }

    protected String getIconFilePrefix() {
        return "undo_";
    }

    public void isIconVisible(boolean isNull) {
        this.setIconVisible(isNull);
    }

    protected String getLocalizedName() {
        return GanttProject.correctLabel(GanttLanguage.getInstance().getText("undo"));
    }
}

