/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.calendar;

import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.calendar.AlwaysWorkingTimeCalendarImpl;
import net.sourceforge.ganttproject.calendar.CalendarActivityImpl;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.calendar.GPCalendarBase;
import net.sourceforge.ganttproject.calendar.XMLCalendarOpen;
import net.sourceforge.ganttproject.parser.HolidayTagHandler;
import net.sourceforge.ganttproject.task.TaskLength;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.gregorian.FramerImpl;

public class WeekendCalendarImpl
extends GPCalendarBase
implements GPCalendar {
    private final Calendar myCalendar = (Calendar)Calendar.getInstance().clone();
    private final FramerImpl myFramer = new FramerImpl(7);
    private GPCalendar.DayType[] myTypes = new GPCalendar.DayType[7];
    private int myWeekendDaysCount;
    private Set publicHolidaysArray = new LinkedHashSet();
    private final Set myStableHolidays = new LinkedHashSet();
    private AlwaysWorkingTimeCalendarImpl myRestlessCalendar = new AlwaysWorkingTimeCalendarImpl();

    public WeekendCalendarImpl() {
        for (int i = 0; i < this.myTypes.length; ++i) {
            this.myTypes[i] = GPCalendar.DayType.WORKING;
        }
        this.setWeekDayType(7, GPCalendar.DayType.WEEKEND);
        this.setWeekDayType(1, GPCalendar.DayType.WEEKEND);
    }

    public List getActivities(Date startDate, Date endDate) {
        if (this.myWeekendDaysCount == 0) {
            return this.myRestlessCalendar.getActivities(startDate, endDate);
        }
        ArrayList<CalendarActivityImpl> result = new ArrayList<CalendarActivityImpl>();
        Date curDayStart = this.myFramer.adjustLeft(startDate);
        boolean isWeekendState = this.isNonWorkingDay(curDayStart);
        while (curDayStart.before(endDate)) {
            Date changeStateDayStart = this.getStateChangeDate(curDayStart, !isWeekendState);
            if (changeStateDayStart.before(endDate)) {
                result.add(new CalendarActivityImpl(curDayStart, changeStateDayStart, !isWeekendState));
                curDayStart = changeStateDayStart;
                isWeekendState = !isWeekendState;
                continue;
            }
            result.add(new CalendarActivityImpl(curDayStart, endDate, !isWeekendState));
            break;
        }
        return result;
    }

    public boolean isWeekend(Date curDayStart) {
        this.myCalendar.setTime(curDayStart);
        int dayOfWeek = this.myCalendar.get(7);
        return this.myTypes[dayOfWeek - 1] == GPCalendar.DayType.WEEKEND;
    }

    private Date getStateChangeDate(Date startDate, boolean changeToWeekend) {
        Date nextDayStart = this.myFramer.adjustRight(startDate);
        if (!(changeToWeekend ^ this.isNonWorkingDay(nextDayStart))) {
            return nextDayStart;
        }
        return this.getStateChangeDate(nextDayStart, changeToWeekend);
    }

    private Date getStateChangeDate(Date startDate, TimeUnit timeUnit, boolean changeToWeekend, boolean moveRightNotLeft) {
        Date nextUnitStart;
        Date date = nextUnitStart = moveRightNotLeft ? timeUnit.adjustRight(startDate) : timeUnit.jumpLeft(startDate);
        if (!(changeToWeekend ^ this.isNonWorkingDay(nextUnitStart))) {
            return nextUnitStart;
        }
        return this.getStateChangeDate(nextUnitStart, timeUnit, changeToWeekend, moveRightNotLeft);
    }

    protected List getActivitiesForward(Date startDate, TimeUnit timeUnit, long unitCount) {
        ArrayList<CalendarActivityImpl> result = new ArrayList<CalendarActivityImpl>();
        Date unitStart = timeUnit.adjustLeft(startDate);
        while (unitCount > 0L) {
            boolean isWeekendState = this.isNonWorkingDay(unitStart);
            if (isWeekendState) {
                Date workingUnitStart = this.getStateChangeDate(unitStart, timeUnit, false, true);
                result.add(new CalendarActivityImpl(unitStart, workingUnitStart, false));
                unitStart = workingUnitStart;
                continue;
            }
            Date nextUnitStart = timeUnit.adjustRight(unitStart);
            result.add(new CalendarActivityImpl(unitStart, nextUnitStart, true));
            unitStart = nextUnitStart;
            --unitCount;
        }
        return result;
    }

    protected List getActivitiesBackward(Date startDate, TimeUnit timeUnit, long unitCount) {
        LinkedList<CalendarActivityImpl> result = new LinkedList<CalendarActivityImpl>();
        Date unitStart = timeUnit.adjustLeft(startDate);
        while (unitCount > 0L) {
            Date prevUnitStart = timeUnit.jumpLeft(unitStart);
            boolean isWeekendState = this.isNonWorkingDay(prevUnitStart);
            if (isWeekendState) {
                Date lastWorkingUnitStart = this.getStateChangeDate(prevUnitStart, timeUnit, false, false);
                Date firstWeekendUnitStart = timeUnit.adjustRight(lastWorkingUnitStart);
                Date lastWeekendUnitEnd = unitStart;
                result.add(0, new CalendarActivityImpl(firstWeekendUnitStart, lastWeekendUnitEnd, false));
                unitStart = firstWeekendUnitStart;
                continue;
            }
            result.add(0, new CalendarActivityImpl(prevUnitStart, unitStart, true));
            --unitCount;
            unitStart = prevUnitStart;
        }
        return result;
    }

    public void setWeekDayType(int day, GPCalendar.DayType type) {
        if (type != this.myTypes[day - 1]) {
            this.myWeekendDaysCount += type == GPCalendar.DayType.WEEKEND ? 1 : -1;
        }
        this.myTypes[day - 1] = type;
    }

    public GPCalendar.DayType getWeekDayType(int day) {
        return this.myTypes[day - 1];
    }

    public Date findClosestWorkingTime(Date time) {
        if (this.myWeekendDaysCount == 0) {
            return time;
        }
        if (!this.isNonWorkingDay(time)) {
            return time;
        }
        return this.getStateChangeDate(time, false);
    }

    public void setPublicHoliDayType(int month, int date) {
        this.setPublicHoliDayType(new GanttCalendar(1, month - 1, date).getTime());
        this.myStableHolidays.add(new GanttCalendar(1, month - 1, date).getTime());
    }

    public void setPublicHoliDayType(Date curDayStart) {
        this.publicHolidaysArray.add(curDayStart);
    }

    public boolean isPublicHoliDay(Date curDayStart) {
        boolean result = this.publicHolidaysArray.contains(curDayStart);
        if (!result) {
            result = this.myStableHolidays.contains(new GanttCalendar(1, curDayStart.getMonth(), curDayStart.getDate()).getTime());
        }
        return result;
    }

    public GPCalendar.DayType getDayTypeDate(Date curDayStart) {
        this.myCalendar.setTime(curDayStart);
        int dayOfYear = this.myCalendar.get(6);
        this.myCalendar.setTime(curDayStart);
        int dayOfWeek = this.myCalendar.get(7);
        if (!this.isPublicHoliDay(curDayStart) && this.getWeekDayType(dayOfWeek) == GPCalendar.DayType.WORKING) {
            return GPCalendar.DayType.WORKING;
        }
        if (this.isPublicHoliDay(curDayStart)) {
            return GPCalendar.DayType.HOLIDAY;
        }
        return GPCalendar.DayType.WEEKEND;
    }

    public boolean isNonWorkingDay(Date curDayStart) {
        return this.isWeekend(curDayStart) || this.isPublicHoliDay(curDayStart);
    }

    public void setPublicHolidays(URL calendar, GanttProject gp) {
        this.publicHolidaysArray.clear();
        if (calendar != null) {
            XMLCalendarOpen opener = new XMLCalendarOpen();
            HolidayTagHandler dependencyHandler = new HolidayTagHandler(gp);
            opener.addTagHandler(dependencyHandler);
            opener.addParsingListener(dependencyHandler);
            try {
                opener.load(calendar.openStream());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Collection getPublicHolidays() {
        return this.publicHolidaysArray;
    }

    public List getActivities(Date startingFrom, TaskLength period) {
        return this.getActivities(startingFrom, period.getTimeUnit(), period.getLength());
    }
}

