/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.sourceforge.ganttproject.chart.ChartModel;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.ChartOptionGroup;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import net.sourceforge.ganttproject.chart.Painter;
import net.sourceforge.ganttproject.chart.TaskGridRendererImpl;
import net.sourceforge.ganttproject.chart.TaskRendererImpl;
import net.sourceforge.ganttproject.chart.item.ChartItem;
import net.sourceforge.ganttproject.chart.item.TaskBoundaryChartItem;
import net.sourceforge.ganttproject.chart.item.TaskProgressChartItem;
import net.sourceforge.ganttproject.chart.item.TaskRegularAreaChartItem;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.options.model.ColorOption;
import net.sourceforge.ganttproject.gui.options.model.DefaultColorOption;
import net.sourceforge.ganttproject.gui.options.model.GP1XOptionConverter;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskActivity;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.time.TimeUnitStack;

public class ChartModelImpl
extends ChartModelBase
implements ChartModel {
    private List myVisibleTasks;
    private final TaskRendererImpl myTaskRendererImpl;
    private TaskContainmentHierarchyFacade myTaskContainment;
    private final TaskGridRendererImpl myTaskGridRendererImpl;
    private TaskManager taskManager;
    private boolean isOnlyDown = false;
    private boolean isOnlyUp = false;
    private boolean isPreviousState = false;
    private int rowHeight = 20;
    private final ColorOption myTaskDefaultColorOption;
    private final ChartOptionGroup myDefaultColorOptions;
    private final ColorOption myTaskAheadOfScheduleColor;
    private final ColorOption myTaskBehindScheduleColor;
    private final ColorOption myTaskOnScheduleColor;
    private final ChartOptionGroup myStateDiffOptions;
    private Set myHiddenTasks;

    public ChartModelImpl(TaskManager taskManager, TimeUnitStack timeUnitStack, final UIConfiguration projectConfig) {
        super(taskManager, timeUnitStack, projectConfig);
        this.taskManager = taskManager;
        this.myTaskRendererImpl = new TaskRendererImpl(this);
        this.myTaskGridRendererImpl = new TaskGridRendererImpl(this);
        this.myTimeUnitVisitors.add(this.myTaskGridRendererImpl);
        this.myTimeUnitVisitors.add(this.myTaskRendererImpl);
        class NewTaskColorOption
        extends DefaultColorOption
        implements GP1XOptionConverter {
            private final /* synthetic */ UIConfiguration val$projectConfig;

            NewTaskColorOption(UIConfiguration val$projectConfig) {
                this.val$projectConfig = val$projectConfig;
                super("newTaskDefaultColor");
            }

            public String getTagName() {
                return "colors";
            }

            public String getAttributeName() {
                return "tasks";
            }

            public void loadValue(String legacyValue) {
                this.lock();
                this.loadPersistentValue(legacyValue);
                this.commit();
            }

            public void commit() {
                super.commit();
                this.val$projectConfig.setTaskColor(this.getValue());
            }
        }
        this.myTaskDefaultColorOption = new NewTaskColorOption(projectConfig);
        this.myDefaultColorOptions = new ChartOptionGroup("ganttChartDefaultColors", new GPOption[]{this.myTaskDefaultColorOption, projectConfig.getWeekendAlphaRenderingOption()}, this.getOptionEventDispatcher());
        this.myTaskAheadOfScheduleColor = new DefaultColorOption("ganttChartStateDiffColors.taskAheadOfScheduleColor"){

            public void commit() {
                super.commit();
                projectConfig.setEarlierPreviousTaskColor(this.getValue());
            }
        };
        this.myTaskAheadOfScheduleColor.lock();
        this.myTaskAheadOfScheduleColor.setValue(new Color(50, 229, 50));
        this.myTaskAheadOfScheduleColor.commit();
        this.myTaskBehindScheduleColor = new DefaultColorOption("ganttChartStateDiffColors.taskBehindScheduleColor"){

            public void commit() {
                super.commit();
                projectConfig.setLaterPreviousTaskColor(this.getValue());
            }
        };
        this.myTaskBehindScheduleColor.lock();
        this.myTaskBehindScheduleColor.setValue(new Color(229, 50, 50));
        this.myTaskBehindScheduleColor.commit();
        this.myTaskOnScheduleColor = new DefaultColorOption("ganttChartStateDiffColors.taskOnScheduleColor"){

            public void commit() {
                super.commit();
                projectConfig.setPreviousTaskColor(this.getValue());
            }
        };
        this.myTaskOnScheduleColor.lock();
        this.myTaskOnScheduleColor.setValue(Color.LIGHT_GRAY);
        this.myTaskOnScheduleColor.commit();
        this.myStateDiffOptions = new ChartOptionGroup("ganttChartStateDiffColors", new GPOption[]{this.myTaskOnScheduleColor, this.myTaskAheadOfScheduleColor, this.myTaskBehindScheduleColor}, this.getOptionEventDispatcher());
    }

    protected void enableRenderers1() {
        super.enableRenderers1();
        this.myTaskRendererImpl.setEnabled(true);
    }

    protected void enableRenderers2() {
        super.enableRenderers2();
        this.myTaskRendererImpl.setEnabled(false);
    }

    protected void paintMainArea(Graphics mainArea, Painter p) {
        super.paintMainArea(mainArea, p);
        mainArea.translate(0, -this.getVerticalOffset());
        this.myTaskRendererImpl.getPrimitiveContainer().paint(p, mainArea);
        this.myTaskGridRendererImpl.getPrimitiveContainer().paint(p, mainArea);
        this.myTaskRendererImpl.getPrimitiveContainer().getLayer(1).paint(p, mainArea);
        this.myTaskRendererImpl.getPrimitiveContainer().getLayer(2).paint(p, mainArea);
    }

    public void setVisibleTasks(List visibleTasks) {
        this.myVisibleTasks = visibleTasks;
    }

    public void setExplicitlyHiddenTasks(Set hiddenTasks) {
        this.myHiddenTasks = hiddenTasks;
    }

    public Task findTaskWithCoordinates(int x, int y) {
        GraphicPrimitiveContainer.GraphicPrimitive primitive = this.myTaskRendererImpl.getPrimitiveContainer().getPrimitive(x, y - this.getChartUIConfiguration().getHeaderHeight());
        if (primitive instanceof GraphicPrimitiveContainer.Rectangle) {
            TaskActivity activity = (TaskActivity)primitive.getModelObject();
            return activity == null ? null : activity.getTask();
        }
        return null;
    }

    public ChartItem getChartItemWithCoordinates(int x, int y) {
        ChartItem result = this.findTaskProgressItem(x, y);
        if (result == null) {
            result = this.findTaskBoundaryItem(x, y);
        }
        return result;
    }

    private ChartItem findTaskProgressItem(int x, int y) {
        TaskProgressChartItem result = null;
        GraphicPrimitiveContainer.GraphicPrimitive primitive = this.myTaskRendererImpl.getPrimitiveContainer().getLayer(1).getPrimitive(x, 4, y - this.getChartUIConfiguration().getHeaderHeight(), 0);
        if (primitive instanceof GraphicPrimitiveContainer.Rectangle) {
            GraphicPrimitiveContainer.Rectangle rect = (GraphicPrimitiveContainer.Rectangle)primitive;
            if ("task.progress.end".equals(primitive.getStyle()) && rect.getRightX() >= x - 4 && rect.getRightX() <= x + 4) {
                result = new TaskProgressChartItem(x, this.getBottomUnitWidth(), this.getBottomUnit(), (Task)primitive.getModelObject());
            }
        }
        return result;
    }

    private ChartItem findTaskBoundaryItem(int x, int y) {
        ChartItem result = null;
        GraphicPrimitiveContainer.GraphicPrimitive primitive = this.myTaskRendererImpl.getPrimitiveContainer().getPrimitive(x, y - this.getChartUIConfiguration().getHeaderHeight());
        if (primitive == null) {
            primitive = this.myTaskRendererImpl.getPrimitiveContainer().getLayer(2).getPrimitive(x, y - this.getChartUIConfiguration().getHeaderHeight());
        }
        if (primitive instanceof GraphicPrimitiveContainer.Rectangle) {
            GraphicPrimitiveContainer.Rectangle rect = (GraphicPrimitiveContainer.Rectangle)primitive;
            TaskActivity activity = (TaskActivity)primitive.getModelObject();
            if (activity != null) {
                if (activity.isFirst() && rect.myLeftX - 2 <= x && rect.myLeftX + 2 >= x) {
                    result = new TaskBoundaryChartItem(activity.getTask(), true);
                }
                if (result == null && activity.isLast() && rect.myLeftX + rect.myWidth - 2 <= x && rect.myLeftX + rect.myWidth + 2 >= x) {
                    result = new TaskBoundaryChartItem(activity.getTask(), false);
                }
                if (result == null) {
                    result = new TaskRegularAreaChartItem(activity.getTask());
                }
            }
        }
        return result;
    }

    public Rectangle getBoundingRectangle(Task task) {
        Rectangle result = null;
        TaskActivity[] activities = task.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            GraphicPrimitiveContainer.Rectangle nextRectangle = this.myTaskRendererImpl.getPrimitive(activities[i]);
            if (nextRectangle == null) continue;
            Rectangle nextAwtRectangle = new Rectangle(nextRectangle.myLeftX, nextRectangle.myTopY, nextRectangle.myWidth, nextRectangle.myHeight);
            result = result == null ? nextAwtRectangle : result.union(nextAwtRectangle);
        }
        return result;
    }

    GraphicPrimitiveContainer.Rectangle[] getTaskActivityRectangles(Task task) {
        ArrayList<GraphicPrimitiveContainer.Rectangle> result = new ArrayList<GraphicPrimitiveContainer.Rectangle>();
        TaskActivity[] activities = task.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            GraphicPrimitiveContainer.Rectangle nextRectangle = this.myTaskRendererImpl.getPrimitive(activities[i]);
            if (nextRectangle == null) continue;
            result.add(nextRectangle);
        }
        return result.toArray(new GraphicPrimitiveContainer.Rectangle[0]);
    }

    List getVisibleTasks() {
        return this.myVisibleTasks;
    }

    public void setTaskContainment(TaskContainmentHierarchyFacade taskContainment) {
        this.myTaskContainment = taskContainment;
    }

    TaskContainmentHierarchyFacade getTaskContainment() {
        return this.myTaskContainment;
    }

    public void setTuningOptions(TuningOptions tuningOptions) {
        this.myTaskRendererImpl.setProgressRenderingEnabled(tuningOptions.renderProgress);
        this.myTaskRendererImpl.setDependenciesRenderingEnabled(tuningOptions.renderDependencies);
    }

    public int setRowHeight() {
        boolean textUP = false;
        boolean textDOWN = false;
        this.isOnlyDown = false;
        this.isOnlyUp = false;
        textUP = this.myTaskRendererImpl.isTextUp();
        textDOWN = this.myTaskRendererImpl.isTextDown();
        if (textUP && textDOWN) {
            this.rowHeight = 40;
        } else if (textUP) {
            this.rowHeight = 30;
            this.isOnlyUp = true;
        } else if (textDOWN) {
            this.rowHeight = 30;
            this.isOnlyDown = true;
        } else {
            this.rowHeight = 20;
        }
        if (this.isPreviousState) {
            this.rowHeight += 8;
        }
        return this.rowHeight;
    }

    public boolean isOnlyUp() {
        return this.isOnlyUp;
    }

    public boolean isOnlyDown() {
        return this.isOnlyDown;
    }

    public boolean isSelected(int index) {
        return this.myTaskRendererImpl.isVisible(index);
    }

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public GPOptionGroup[] getChartOptionGroups() {
        GPOptionGroup[] superGroups = super.getChartOptionGroups();
        GPOptionGroup[] rendererGroups = this.myTaskRendererImpl.getOptionGroups();
        ArrayList<GPOptionGroup> result = new ArrayList<GPOptionGroup>();
        result.addAll(Arrays.asList(superGroups));
        result.addAll(Arrays.asList(rendererGroups));
        result.add(this.myDefaultColorOptions);
        result.add(this.myStateDiffOptions);
        return result.toArray(new GPOptionGroup[result.size()]);
    }

    public int setPreviousStateTasks(ArrayList tasks) {
        this.isPreviousState = tasks != null;
        this.myTaskRendererImpl.setPreviousStateTasks(tasks);
        return this.setRowHeight();
    }

    public boolean isPrevious() {
        return this.isPreviousState;
    }

    public ChartModelBase createCopy() {
        return new ChartModelImpl(this.getTaskManager(), this.getTimeUnitStack(), this.getProjectConfig());
    }

    public boolean isExplicitlyHidden(Task task) {
        return this.myHiddenTasks == null ? false : this.myHiddenTasks.contains(task);
    }

    public static class TuningOptions {
        private final boolean renderProgress;
        private final boolean renderDependencies;
        public static final TuningOptions DEFAULT = new TuningOptions(true, true);

        public TuningOptions(boolean renderProgress, boolean renderDependencies) {
            this.renderProgress = renderProgress;
            this.renderDependencies = renderDependencies;
        }
    }
}

