/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.SimpleRenderedImage;

public abstract class RenderedChartImage
extends SimpleRenderedImage {
    private BufferedImage myTaskImage;
    ColorModel myColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
    SampleModel mySampleModel;
    private int myCurrentTile = -1;
    private Raster myCurrentRaster;
    private final ChartModelBase myChartModel;

    public RenderedChartImage(ChartModelBase chartModel, BufferedImage taskImage, int chartWidth, int chartHeight) {
        this.myChartModel = chartModel;
        this.myTaskImage = taskImage;
        this.sampleModel = this.myColorModel.createCompatibleSampleModel(chartWidth, chartHeight);
        this.colorModel = this.myColorModel;
        this.minX = 0;
        this.minY = 0;
        this.width = chartWidth + taskImage.getWidth();
        this.height = chartHeight;
        this.tileWidth = this.width;
        this.tileHeight = 32;
    }

    public BufferedImage getWholeImage() {
        BufferedImage chartImage = this.getChart(0, 0, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        BufferedImage result = new BufferedImage(chartImage.getWidth() + this.myTaskImage.getWidth(), this.getHeight(), 1);
        Graphics g = result.getGraphics();
        g.drawImage(this.myTaskImage, 0, 0, null);
        g.translate(this.myTaskImage.getWidth(), 0);
        g.drawImage(chartImage, 0, 0, null);
        return result;
    }

    public Raster getTile(int tileX, int tileY) {
        if (this.myCurrentTile != tileY) {
            int offsety = tileY * this.getTileHeight();
            BufferedImage tile = this.getChart(this.myTaskImage.getWidth(), offsety, this.getTileWidth(), this.getTileHeight(), this.getWidth(), this.getHeight());
            Graphics g = tile.getGraphics();
            g.translate(0, -offsety);
            g.drawImage(this.myTaskImage, 0, 0, null);
            this.myCurrentRaster = tile.getRaster().createTranslatedChild(0, tileY * this.getTileHeight());
            this.myCurrentTile = tileY;
        }
        return this.myCurrentRaster;
    }

    protected abstract void paintChart(Graphics var1);

    private BufferedImage getChart(int offsetx, int offsety, int width, int height, int chartWidth, int chartHeight) {
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics g2 = result.getGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        g2.translate(offsetx, -offsety);
        g2.clipRect(0, offsety, width, height);
        this.myChartModel.setBounds(new Dimension(chartWidth, chartHeight));
        this.paintChart(g2);
        return result;
    }
}

