/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.export;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.sourceforge.ganttproject.export.ExportFileWizardImpl;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.gui.options.GPOptionChoicePanel;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import net.sourceforge.ganttproject.language.GanttLanguage;

class ExporterChooserPage
implements WizardPage {
    private Exporter[] myExporters;
    private ExportFileWizardImpl.State myState;
    private GanttLanguage language = GanttLanguage.getInstance();

    ExporterChooserPage(Exporter[] exporters, ExportFileWizardImpl.State state) {
        this.myExporters = exporters;
        this.myState = state;
    }

    public String getTitle() {
        return this.language.getText("option.exporter.title");
    }

    public Component getComponent() {
        int selectedGroupIndex = 0;
        Action[] choiceChangeActions = new Action[this.myExporters.length];
        GPOptionGroup[] choiceOptions = new GPOptionGroup[this.myExporters.length];
        for (int i = 0; i < this.myExporters.length; ++i) {
            final Exporter nextExporter = this.myExporters[i];
            if (nextExporter == this.myState.getExporter()) {
                selectedGroupIndex = i;
            }
            AbstractAction nextAction = new AbstractAction(nextExporter.getFileTypeDescription()){

                public void actionPerformed(ActionEvent e) {
                    ExporterChooserPage.this.myState.setExporter(nextExporter);
                }
            };
            GPOptionGroup nextOptions = nextExporter.getOptions();
            if (nextOptions != null) {
                nextOptions.lock();
            }
            choiceChangeActions[i] = nextAction;
            choiceOptions[i] = nextOptions;
        }
        GPOptionChoicePanel choicePanel = new GPOptionChoicePanel();
        return choicePanel.getComponent(choiceChangeActions, choiceOptions, selectedGroupIndex);
    }

    public void setActive(boolean b) {
        if (!b) {
            for (int i = 0; i < this.myExporters.length; ++i) {
                if (this.myExporters[i].getOptions() == null) continue;
                this.myExporters[i].getOptions().commit();
            }
        } else {
            for (int i = 0; i < this.myExporters.length; ++i) {
                if (this.myExporters[i].getOptions() == null) continue;
                this.myExporters[i].getOptions().lock();
            }
        }
    }
}

