/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.awt.Component;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import net.sourceforge.ganttproject.gui.options.OptionsPageBuilder;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.options.model.OptionPageProvider;

public class OptionPageProviderPanel
extends GeneralOptionPanel {
    private OptionPageProvider myProvider;
    private IGanttProject myProject;
    private UIFacade myUIFacade;
    private GPOptionGroup[] myGroups;

    public OptionPageProviderPanel(OptionPageProvider provider, IGanttProject project, UIFacade uiFacade) {
        super("", "", uiFacade.getMainFrame());
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.myProvider = provider;
        this.myGroups = this.myProvider.getOptionGroups(project, uiFacade);
    }

    public Component getComponent() {
        if (this.myProvider.hasCustomComponent()) {
            return this.myProvider.buildPageComponent(this.myProject, this.myUIFacade);
        }
        OptionsPageBuilder builder = new OptionsPageBuilder();
        return builder.buildPage(this.myGroups, this.myProvider.getPageID());
    }

    public boolean applyChanges(boolean askForApply) {
        for (int i = 0; i < this.myGroups.length; ++i) {
            this.myGroups[i].commit();
        }
        return true;
    }

    public void initialize() {
        for (int i = 0; i < this.myGroups.length; ++i) {
            this.myGroups[i].lock();
        }
    }

    public void rollback() {
        for (int i = 0; i < this.myGroups.length; ++i) {
            this.myGroups[i].rollback();
        }
    }
}

