/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options.model;

import java.util.List;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueDispatcher;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import net.sourceforge.ganttproject.gui.options.model.GPAbstractOption;

public class DefaultEnumerationOption
extends GPAbstractOption
implements EnumerationOption,
ChangeValueDispatcher {
    private final String[] myValues;
    private String myValue;
    private String myLockedValue;

    public DefaultEnumerationOption(String id, String[] values) {
        super(id);
        this.myValues = values;
    }

    public DefaultEnumerationOption(String id, List values) {
        super(id);
        this.myValues = values.toArray(new String[0]);
    }

    public String[] getAvailableValues() {
        return this.myValues;
    }

    public void setValue(String value) {
        if (!this.isLocked()) {
            throw new IllegalStateException("Lock option before setting value");
        }
        ChangeValueEvent event = new ChangeValueEvent(this.getID(), this.myLockedValue, value);
        this.myLockedValue = value;
        this.fireChangeValueEvent(event);
    }

    public String getValue() {
        return this.myValue;
    }

    public void commit() {
        super.commit();
        this.myValue = this.myLockedValue;
    }

    public String getPersistentValue() {
        return this.getValue();
    }

    public void loadPersistentValue(String value) {
        this.setValue(value);
    }

    public boolean isChanged() {
        if (this.isLocked() && this.myValue != null) {
            return false == this.myValue.equals(this.myLockedValue);
        }
        return false;
    }
}

