/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.projectwizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.sourceforge.ganttproject.gui.projectwizard.I18N;
import net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleSet;

public class RoleSetPage
implements WizardPage {
    private final I18N myI18N;
    private RoleSetListModel myListModel;

    RoleSetPage(RoleSet[] roleSets, I18N i18n) {
        this.myI18N = i18n;
        this.myListModel = new RoleSetListModel(roleSets, i18n);
    }

    public String getTitle() {
        return this.myI18N.getProjectDomainPageTitle();
    }

    public Component getComponent() {
        Box domainBox = new Box(3);
        JLabel label = new JLabel(GanttLanguage.getInstance().getText("chooseRoleSets"));
        final JList roleSetsList = new JList(this.myListModel);
        roleSetsList.setCellRenderer(this.myListModel.getCellRenderer());
        roleSetsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index = roleSetsList.locationToIndex(e.getPoint());
                RoleSetPage.this.myListModel.toggle(index);
            }
        });
        roleSetsList.setAlignmentX(0.0f);
        label.setLabelFor(roleSetsList);
        label.setAlignmentX(0.0f);
        domainBox.add(label);
        domainBox.add(Box.createVerticalStrut(5));
        domainBox.add(roleSetsList);
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)domainBox, "Center");
        return result;
    }

    public void setActive(boolean active) {
    }

    private static class RoleSetListModel
    extends AbstractListModel
    implements ListCellRenderer {
        private final RoleSet[] myRoleSets;
        private final I18N myI18n;

        RoleSetListModel(RoleSet[] roleSets, I18N i18n) {
            this.myRoleSets = roleSets;
            this.myI18n = i18n;
        }

        public void toggle(int index) {
            if (!this.isTheOnlyEnabled(this.myRoleSets[index])) {
                this.myRoleSets[index].setEnabled(!this.myRoleSets[index].isEnabled());
                this.fireContentsChanged(this, index, index);
            }
        }

        public int getSize() {
            return this.myRoleSets.length;
        }

        public Object getElementAt(int index) {
            return this.myRoleSets[index];
        }

        ListCellRenderer getCellRenderer() {
            return this;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            RoleSet roleSet = (RoleSet)value;
            JCheckBox result = new JCheckBox(this.myI18n.getRoleSetDisplayName(roleSet), roleSet.isEnabled());
            if (this.isTheOnlyEnabled(roleSet)) {
                result.setEnabled(false);
            }
            result.setToolTipText(this.createTooltipText(roleSet));
            return result;
        }

        private boolean isTheOnlyEnabled(RoleSet roleSet) {
            boolean result = true;
            for (int i = 0; i < this.myRoleSets.length; ++i) {
                if (this.myRoleSets[i] == roleSet || !this.myRoleSets[i].isEnabled()) continue;
                result = false;
                break;
            }
            return result;
        }

        private String createTooltipText(RoleSet roleSet) {
            StringBuffer result = new StringBuffer();
            result.append(this.myI18n.getRolesetTooltipHeader(roleSet.getName()));
            Role[] roles = roleSet.getRoles();
            for (int i = 0; i < roles.length; ++i) {
                Role nextRole = roles[i];
                result.append(this.myI18n.formatRoleForTooltip(nextRole));
            }
            result.append(this.myI18n.getRolesetTooltipFooter());
            return result.toString();
        }
    }
}

