/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.ganttproject.GanttTask;
import net.sourceforge.ganttproject.parser.FileFormatException;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.ResourceManager;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.roles.RolePersistentID;
import net.sourceforge.ganttproject.roles.RoleSet;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.TaskManager;
import org.xml.sax.Attributes;

public class AllocationTagHandler
implements TagHandler,
ParsingListener {
    private ResourceManager myResourceManager;
    private TaskManager myTaskManager;
    private RoleManager myRoleManager;
    private final HashMap myLateAssigmnent2roleBinding = new HashMap();

    public AllocationTagHandler(ResourceManager resourceMgr, TaskManager taskMgr, RoleManager roleMgr) {
        this.myResourceManager = resourceMgr;
        this.myTaskManager = taskMgr;
        this.myRoleManager = roleMgr;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws FileFormatException {
        if (qName.equals("allocation")) {
            this.loadAllocation(attrs);
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) {
    }

    private void loadAllocation(Attributes attrs) throws FileFormatException {
        HumanResource human;
        int taskId = 0;
        int resourceId = 0;
        float load = 0.0f;
        boolean coordinator = false;
        String taskIdAsString = attrs.getValue("task-id");
        String resourceIdAsString = attrs.getValue("resource-id");
        String loadAsString = attrs.getValue("load");
        String coordinatorAsString = attrs.getValue("responsible");
        String rolePersistendIDString = attrs.getValue("function");
        if (taskIdAsString == null || resourceIdAsString == null) {
            throw new FileFormatException("Failed to load <allocation> tag: task or resource identifier is missing");
        }
        try {
            taskId = Integer.parseInt(taskIdAsString);
            resourceId = Integer.parseInt(resourceIdAsString);
            if (loadAsString != null) {
                load = Float.parseFloat(loadAsString);
            }
            if (coordinatorAsString != null) {
                coordinator = Boolean.valueOf(coordinatorAsString);
            }
        }
        catch (NumberFormatException e) {
            throw new FileFormatException("Failed to load <allocation> tag: one of attribute values is invalid", e);
        }
        if (load == 0.0f) {
            load = 100.0f;
        }
        if ((human = (HumanResource)this.getResourceManager().getById(resourceId)) == null) {
            throw new FileFormatException("Human resource with id=" + resourceId + " not found");
        }
        GanttTask task = this.getTaskManager().getTask(taskId);
        if (task == null) {
            throw new FileFormatException("Task with id=" + taskId + " not found");
        }
        ResourceAssignment assignment = task.getAssignmentCollection().addAssignment(human);
        try {
            if (rolePersistendIDString != null) {
                this.myLateAssigmnent2roleBinding.put(assignment, rolePersistendIDString);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR in parsing XML File function id is not numeric: " + e.toString());
        }
        assignment.setLoad(load);
        assignment.setCoordinator(coordinator);
    }

    private ResourceManager getResourceManager() {
        return this.myResourceManager;
    }

    private TaskManager getTaskManager() {
        return this.myTaskManager;
    }

    private Role findRole(String persistentIDasString) {
        RoleSet roleSet;
        RolePersistentID persistentID = new RolePersistentID(persistentIDasString);
        String rolesetName = persistentID.getRoleSetID();
        int roleID = persistentID.getRoleID();
        if (rolesetName == null) {
            roleSet = this.myRoleManager.getProjectRoleSet();
            if (roleSet.findRole(roleID) == null) {
                if (roleID <= 10 && roleID > 2) {
                    roleSet = this.myRoleManager.getRoleSet("SoftwareDevelopment");
                    roleSet.setEnabled(true);
                } else if (roleID <= 2) {
                    roleSet = this.myRoleManager.getRoleSet("Default");
                }
            }
        } else {
            roleSet = this.myRoleManager.getRoleSet(rolesetName);
        }
        Role result = roleSet.findRole(roleID);
        return result;
    }

    public void parsingStarted() {
    }

    public void parsingFinished() {
        Iterator lateBindingEntries = this.myLateAssigmnent2roleBinding.entrySet().iterator();
        while (lateBindingEntries.hasNext()) {
            Map.Entry nextEntry = lateBindingEntries.next();
            String persistentID = (String)nextEntry.getValue();
            Role nextRole = this.findRole(persistentID);
            if (nextRole == null) continue;
            lateBindingEntries.remove();
            ((ResourceAssignment)nextEntry.getKey()).setRoleForAssignment(nextRole);
        }
        if (!this.myLateAssigmnent2roleBinding.isEmpty()) {
            System.err.println("[ResourceTagHandler] parsingFinished(): not found roles:\n" + this.myLateAssigmnent2roleBinding);
        }
    }
}

