/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.roles;

public class RolePersistentID {
    private static final String ROLESET_DELIMITER = ":";
    private final String myRoleSetID;
    private final int myRoleID;

    public RolePersistentID(String persistentID) {
        int roleID;
        int posDelimiter = persistentID.lastIndexOf(ROLESET_DELIMITER);
        String rolesetName = posDelimiter == -1 ? null : persistentID.substring(0, posDelimiter);
        String roleIDasString = posDelimiter == -1 ? persistentID : persistentID.substring(posDelimiter + 1);
        try {
            roleID = Integer.parseInt(roleIDasString);
        }
        catch (NumberFormatException e) {
            roleID = 0;
        }
        this.myRoleID = roleID;
        this.myRoleSetID = rolesetName;
    }

    public String getRoleSetID() {
        return this.myRoleSetID;
    }

    public int getRoleID() {
        return this.myRoleID;
    }

    public String asString() {
        return this.myRoleSetID + ROLESET_DELIMITER + this.myRoleID;
    }
}

