/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.roles;

import java.util.ArrayList;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleImpl;
import net.sourceforge.ganttproject.roles.RoleManagerImpl;
import net.sourceforge.ganttproject.roles.RoleSet;

public class RoleSetImpl
implements RoleSet {
    private final String myName;
    private final ArrayList myRoles = new ArrayList();
    private boolean isEnabled;
    private final RoleManagerImpl myRoleManager;

    RoleSetImpl(String name, RoleManagerImpl roleManager) {
        this.myName = name;
        this.myRoleManager = roleManager;
    }

    public String getName() {
        return this.myName;
    }

    public Role[] getRoles() {
        return this.myRoles.toArray(new Role[0]);
    }

    public Role createRole(String name, int persistentID) {
        RoleImpl result = new RoleImpl(persistentID, name, this);
        this.myRoles.add(result);
        this.myRoleManager.fireRolesChanged(this);
        return result;
    }

    public void deleteRole(Role role) {
        this.myRoles.remove(role);
        this.myRoleManager.fireRolesChanged(this);
    }

    public Role findRole(int roleID) {
        Role result = null;
        for (int i = 0; i < this.myRoles.size(); ++i) {
            Role next = (Role)this.myRoles.get(i);
            if (next.getID() != roleID) continue;
            result = next;
            break;
        }
        return result;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return this.getName();
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        this.myRoleManager.fireRolesChanged(this);
    }

    public boolean isEmpty() {
        return this.myRoles.isEmpty();
    }

    public void clear() {
        this.myRoles.clear();
    }

    void importData(RoleSet original) {
        Role[] originalRoles = original.getRoles();
        for (int i = 0; i < originalRoles.length; ++i) {
            Role nextRole = originalRoles[i];
            this.createRole(nextRole.getName(), nextRole.getID());
        }
    }
}

