/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.ganttproject.GanttTreeTable;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.gui.GanttDialogCustomColumn;
import net.sourceforge.ganttproject.task.CustomColumEvent;
import net.sourceforge.ganttproject.task.CustomColumn;
import net.sourceforge.ganttproject.task.CustomColumnsException;
import net.sourceforge.ganttproject.task.CustomColumsListener;

public class CustomColumnsManager {
    private GanttTreeTable ganttTreeTable = null;
    private List myListeners;

    public CustomColumnsManager(GanttTreeTable treetable) {
        this.ganttTreeTable = treetable;
        this.myListeners = new ArrayList();
    }

    public void setGanttTreeTable(GanttTreeTable treetable) {
        this.ganttTreeTable = treetable;
    }

    public void addNewCustomColumn(CustomColumn customColumn) {
        if (customColumn == null) {
            customColumn = new CustomColumn();
            GanttDialogCustomColumn d = new GanttDialogCustomColumn(Mediator.getGanttProjectSingleton().getUIFacade(), customColumn);
            d.setVisible(true);
        }
        this.ganttTreeTable.addNewCustomColumn(customColumn);
        CustomColumEvent event = new CustomColumEvent(0, customColumn.getName());
        this.fireCustomColumnsChange(event);
    }

    public void deleteCustomColumn(String name) {
        this.ganttTreeTable.deleteCustomColumn(name);
        CustomColumEvent event = new CustomColumEvent(1, name);
        this.fireCustomColumnsChange(event);
    }

    public void changeCustomColumnName(String oldName, String newName) {
        this.ganttTreeTable.renameCustomcolumn(oldName, newName);
        Mediator.getCustomColumnsStorage().renameCustomColumn(oldName, newName);
    }

    public void changeCustomColumnDefaultValue(String colName, Object newDefaultValue) throws CustomColumnsException {
        Mediator.getCustomColumnsStorage().changeDefaultValue(colName, newDefaultValue);
    }

    public void addCustomColumnsListener(CustomColumsListener listener) {
        this.myListeners.add(listener);
    }

    private void fireCustomColumnsChange(CustomColumEvent event) {
        Iterator it = this.myListeners.iterator();
        while (it.hasNext()) {
            CustomColumsListener listener = (CustomColumsListener)it.next();
            listener.customColumsChange(event);
        }
    }
}

