/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.task;

import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.dependency.TaskDependency;

public class TaskProperties {
    public static final String ID_TASK_DATES = "taskDates";
    public static final String ID_TASK_NAME = "name";
    public static final String ID_TASK_LENGTH = "length";
    public static final String ID_TASK_ADVANCEMENT = "advancement";
    public static final String ID_TASK_COORDINATOR = "coordinator";
    public static final String ID_TASK_RESOURCES = "resources";
    public static final String ID_TASK_ID = "id";
    public static final String ID_TASK_PREDECESSORS = "predecessors";

    public static Object getProperty(Task task, String propertyID) {
        Object res = null;
        StringBuffer sb = new StringBuffer();
        if (propertyID != null) {
            if (propertyID.equals(ID_TASK_DATES)) {
                sb.append(" [ ");
                sb.append(task.getStart() + " - " + task.getEnd());
                sb.append(" ] ");
                res = sb.toString();
            } else if (propertyID.equals(ID_TASK_NAME)) {
                sb.append(" " + task.getName() + " ");
                res = sb.toString();
            } else if (propertyID.equals(ID_TASK_LENGTH)) {
                sb.append(" [ ");
                sb.append((int)task.getDuration().getLength() + " " + GanttLanguage.getInstance().getText("days"));
                sb.append(" ] ");
                res = sb.toString();
            } else if (propertyID.equals(ID_TASK_ADVANCEMENT)) {
                sb.append(" [ ");
                sb.append(task.getCompletionPercentage() + "%");
                sb.append(" ] ");
                res = sb.toString();
            } else if (propertyID.equals(ID_TASK_COORDINATOR)) {
                ResourceAssignment[] assignments = task.getAssignments();
                if (assignments.length > 0) {
                    boolean first = true;
                    boolean close = false;
                    int j = 0;
                    for (int i = 0; i < assignments.length; ++i) {
                        if (!assignments[i].isCoordinator()) continue;
                        ++j;
                        if (first) {
                            close = true;
                            first = false;
                            sb.append("{");
                        }
                        if (j > 1) {
                            sb.append(", ");
                        }
                        sb.append(assignments[i].getResource().getName());
                    }
                    if (close) {
                        sb.append("}");
                    }
                }
                res = sb.toString();
            } else if (propertyID.equals(ID_TASK_RESOURCES)) {
                ResourceAssignment[] assignments = task.getAssignments();
                if (assignments.length > 0) {
                    sb.append(" ");
                    for (int i = 0; i < assignments.length; ++i) {
                        sb.append(assignments[i].getResource().getName());
                        if (i >= assignments.length - 1) continue;
                        sb.append(",");
                    }
                    sb.append(" ");
                }
                res = sb.toString();
            } else if (propertyID.equals(ID_TASK_ID)) {
                sb.append("# ").append(task.getTaskID());
                res = sb.toString();
            } else if (propertyID.equals(ID_TASK_PREDECESSORS)) {
                TaskDependency[] dep = task.getDependenciesAsDependant().toArray();
                int i = 0;
                if (dep != null && dep.length > 0) {
                    for (i = 0; i < dep.length - 1; ++i) {
                        sb.append(dep[i].getDependee().getTaskID() + ", ");
                    }
                    sb.append(dep[i].getDependee().getTaskID());
                }
                res = sb.toString();
            } else {
                res = task.getCustomValues().getValue(propertyID);
            }
        }
        return res;
    }
}

