/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.time.gregorian;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.time.TextFormatter;
import net.sourceforge.ganttproject.time.TimeUnitText;
import net.sourceforge.ganttproject.time.gregorian.CachingTextFormatter;

public class WeekTextFormatter
extends CachingTextFormatter
implements TextFormatter {
    private Calendar myCalendar = (Calendar)Calendar.getInstance().clone();

    WeekTextFormatter(String formatString) {
    }

    protected TimeUnitText createTimeUnitText(Date startDate) {
        this.myCalendar.setTime(startDate);
        this.myCalendar.setMinimalDaysInFirstWeek(7);
        Integer weekNo = new Integer(this.myCalendar.get(3));
        String shortText = MessageFormat.format("{0}", weekNo);
        String middleText = MessageFormat.format(GanttLanguage.getInstance().getText("week") + " {0}", weekNo);
        return new TimeUnitText(middleText, middleText, shortText);
    }

    public void languageChanged(GanttLanguage.Event event) {
        super.languageChanged(event);
        this.myCalendar = (Calendar)Calendar.getInstance().clone();
    }
}

