/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.undo;

import java.io.IOException;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.parser.ParserFactory;
import net.sourceforge.ganttproject.undo.GPUndoListener;
import net.sourceforge.ganttproject.undo.GPUndoManager;
import net.sourceforge.ganttproject.undo.UndoableEditImpl;

public class UndoManagerImpl
implements GPUndoManager {
    private UndoableEditSupport myUndoEventDispatcher;
    private UndoManager mySwingUndoManager;
    private DocumentManager myDocumentManager;
    private ParserFactory myParserFactory;
    private IGanttProject myProject;
    private UndoableEditImpl swingEditImpl;

    public UndoManagerImpl(IGanttProject project, ParserFactory parserFactory, DocumentManager documentManager) {
        this.myProject = project;
        this.myParserFactory = parserFactory;
        this.myDocumentManager = documentManager;
        this.mySwingUndoManager = new UndoManager();
        this.myUndoEventDispatcher = new UndoableEditSupport();
    }

    public void undoableEdit(String localizedName, Runnable editImpl) {
        try {
            this.swingEditImpl = new UndoableEditImpl(localizedName, editImpl, this);
            this.mySwingUndoManager.addEdit(this.swingEditImpl);
            this.fireUndoableEditHappened(this.swingEditImpl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void fireUndoableEditHappened(UndoableEditImpl swingEditImpl) {
        this.myUndoEventDispatcher.postEdit(swingEditImpl);
    }

    private void fireUndoOrRedoHappened() {
        UndoableEditListener[] listeners = this.myUndoEventDispatcher.getUndoableEditListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((GPUndoListener)listeners[i]).undoOrRedoHappened();
        }
    }

    DocumentManager getDocumentManager() {
        return this.myDocumentManager;
    }

    protected ParserFactory getParserFactory() {
        return this.myParserFactory;
    }

    IGanttProject getProject() {
        return this.myProject;
    }

    public boolean canUndo() {
        return this.mySwingUndoManager.canUndo();
    }

    public boolean canRedo() {
        return this.mySwingUndoManager.canRedo();
    }

    public void undo() throws CannotUndoException {
        this.mySwingUndoManager.undo();
        this.fireUndoOrRedoHappened();
    }

    public void redo() throws CannotRedoException {
        this.mySwingUndoManager.redo();
        this.fireUndoOrRedoHappened();
    }

    public String getUndoPresentationName() {
        return this.mySwingUndoManager.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return this.mySwingUndoManager.getRedoPresentationName();
    }

    public void addUndoableEditListener(GPUndoListener listener) {
        this.myUndoEventDispatcher.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(GPUndoListener listener) {
        this.myUndoEventDispatcher.removeUndoableEditListener(listener);
    }

    public void die() {
        if (this.swingEditImpl != null) {
            this.swingEditImpl.die();
        }
        if (this.mySwingUndoManager != null) {
            this.mySwingUndoManager.discardAllEdits();
        }
    }
}

