/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;

public class Glyph {
    private String unicode;
    private Vector names;
    private String orientation;
    private String arabicForm;
    private String lang;
    private Point2D horizOrigin;
    private Point2D vertOrigin;
    private float horizAdvX;
    private float vertAdvY;
    private int glyphCode;
    private AffineTransform transform;
    private Point2D position;
    private GVTGlyphMetrics metrics;
    private float kernScale;
    private Shape outline;
    private Rectangle2D bounds;
    private Paint fillPaint;
    private Paint strokePaint;
    private Stroke stroke;
    private Shape dShape;
    private GraphicsNode glyphChildrenNode;

    public Glyph(String unicode, Vector names, String orientation, String arabicForm, String lang, Point2D horizOrigin, Point2D vertOrigin, float horizAdvX, float vertAdvY, int glyphCode, float kernScale, Paint fillPaint, Paint strokePaint, Stroke stroke, Shape dShape, GraphicsNode glyphChildrenNode) {
        if (unicode == null) {
            throw new IllegalArgumentException();
        }
        if (horizOrigin == null) {
            throw new IllegalArgumentException();
        }
        if (vertOrigin == null) {
            throw new IllegalArgumentException();
        }
        this.unicode = unicode;
        this.names = names;
        this.orientation = orientation;
        this.arabicForm = arabicForm;
        this.lang = lang;
        this.horizOrigin = horizOrigin;
        this.vertOrigin = vertOrigin;
        this.horizAdvX = horizAdvX;
        this.vertAdvY = vertAdvY;
        if (this.unicode != null && this.unicode.length() > 0 && ArabicTextHandler.arabicCharTransparent(this.unicode.charAt(0))) {
            this.horizAdvX = 0.0f;
            this.vertAdvY = 0.0f;
        }
        this.kernScale = kernScale;
        this.glyphCode = glyphCode;
        this.position = new Point2D.Float(0.0f, 0.0f);
        this.outline = null;
        this.bounds = null;
        this.fillPaint = fillPaint;
        this.strokePaint = strokePaint;
        this.stroke = stroke;
        this.dShape = dShape;
        this.glyphChildrenNode = glyphChildrenNode;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public Vector getNames() {
        return this.names;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public String getArabicForm() {
        return this.arabicForm;
    }

    public String getLang() {
        return this.lang;
    }

    public Point2D getHorizOrigin() {
        return this.horizOrigin;
    }

    public Point2D getVertOrigin() {
        return this.vertOrigin;
    }

    public float getHorizAdvX() {
        return this.horizAdvX;
    }

    public float getVertAdvY() {
        return this.vertAdvY;
    }

    public int getGlyphCode() {
        return this.glyphCode;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
        this.outline = null;
        this.bounds = null;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D position) {
        this.position = position;
        this.outline = null;
        this.bounds = null;
    }

    public GVTGlyphMetrics getGlyphMetrics() {
        if (this.metrics == null) {
            Rectangle2D gb = this.getGeometryBounds();
            this.metrics = new GVTGlyphMetrics(this.getHorizAdvX(), this.getVertAdvY(), new Rectangle2D.Double(gb.getX() - this.position.getX(), gb.getY() - this.position.getY(), gb.getWidth(), gb.getHeight()), 3);
        }
        return this.metrics;
    }

    public GVTGlyphMetrics getGlyphMetrics(float hkern, float vkern) {
        return new GVTGlyphMetrics(this.getHorizAdvX() - hkern * this.kernScale, this.getVertAdvY() - vkern * this.kernScale, this.getGeometryBounds(), 3);
    }

    public Rectangle2D getGeometryBounds() {
        return this.getOutline().getBounds2D();
    }

    public Rectangle2D getBounds2D() {
        if (this.bounds != null) {
            return this.bounds;
        }
        AffineTransform tr = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
        if (this.transform != null) {
            tr.concatenate(this.transform);
        }
        Rectangle2D bounds = null;
        if (this.dShape != null) {
            if (this.fillPaint != null) {
                bounds = tr.createTransformedShape(this.dShape).getBounds2D();
            }
            if (this.stroke != null && this.strokePaint != null) {
                Shape s = this.stroke.createStrokedShape(this.dShape);
                Rectangle2D r = tr.createTransformedShape(s).getBounds2D();
                bounds = bounds == null ? r : r.createUnion(bounds);
            }
        }
        if (this.glyphChildrenNode != null) {
            Rectangle2D r = this.glyphChildrenNode.getTransformedBounds(tr);
            bounds = bounds == null ? r : r.createUnion(bounds);
        }
        if (bounds == null) {
            bounds = new Rectangle2D.Double(this.position.getX(), this.position.getY(), 0.0, 0.0);
        }
        return bounds;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            AffineTransform tr = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
            if (this.transform != null) {
                tr.concatenate(this.transform);
            }
            Shape glyphChildrenOutline = null;
            if (this.glyphChildrenNode != null) {
                glyphChildrenOutline = this.glyphChildrenNode.getOutline();
            }
            GeneralPath glyphOutline = null;
            if (this.dShape != null && glyphChildrenOutline != null) {
                glyphOutline = new GeneralPath(this.dShape);
                glyphOutline.append(glyphChildrenOutline, false);
            } else {
                glyphOutline = this.dShape != null && glyphChildrenOutline == null ? new GeneralPath(this.dShape) : (this.dShape == null && glyphChildrenOutline != null ? new GeneralPath(glyphChildrenOutline) : new GeneralPath());
            }
            this.outline = tr.createTransformedShape(glyphOutline);
        }
        return this.outline;
    }

    public void draw(Graphics2D graphics2D) {
        AffineTransform tr = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
        if (this.transform != null) {
            tr.concatenate(this.transform);
        }
        if (this.dShape != null) {
            Shape tShape = tr.createTransformedShape(this.dShape);
            if (this.fillPaint != null) {
                graphics2D.setPaint(this.fillPaint);
                graphics2D.fill(tShape);
            }
            if (this.stroke != null && this.strokePaint != null) {
                graphics2D.setStroke(this.stroke);
                graphics2D.setPaint(this.strokePaint);
                graphics2D.draw(tShape);
            }
        }
        if (this.glyphChildrenNode != null) {
            this.glyphChildrenNode.setTransform(tr);
            this.glyphChildrenNode.paint(graphics2D);
        }
    }
}

