/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.Glyph;

public final class SVGGVTGlyphVector
implements GVTGlyphVector {
    private GVTFont font;
    private Glyph[] glyphs;
    private FontRenderContext frc;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private Point2D endPos;

    public SVGGVTGlyphVector(GVTFont font, Glyph[] glyphs, FontRenderContext frc) {
        this.font = font;
        this.glyphs = glyphs;
        this.frc = frc;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds = new Shape[glyphs.length];
        this.glyphVisible = new boolean[glyphs.length];
        int i = 0;
        while (i < glyphs.length) {
            this.glyphVisible[i] = true;
            ++i;
        }
        this.endPos = glyphs[glyphs.length - 1].getPosition();
        this.endPos = new Point2D.Float((float)(this.endPos.getX() + (double)glyphs[glyphs.length - 1].getHorizAdvX()), (float)this.endPos.getY());
    }

    public GVTFont getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int glyphIndex) throws IndexOutOfBoundsException {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex " + glyphIndex + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        return this.glyphs[glyphIndex].getGlyphCode();
    }

    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (numEntries < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + numEntries + ", is illegal. It must be > 0.");
        }
        if (beginGlyphIndex < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + beginGlyphIndex + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (beginGlyphIndex + numEntries > this.glyphs.length) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + beginGlyphIndex + "+" + numEntries + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (codeReturn == null) {
            codeReturn = new int[numEntries];
        }
        int i = beginGlyphIndex;
        while (i < beginGlyphIndex + numEntries) {
            codeReturn[i - beginGlyphIndex] = this.glyphs[i].getGlyphCode();
            ++i;
        }
        return codeReturn;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return null;
    }

    public Shape getGlyphLogicalBounds(int glyphIndex) {
        if (this.glyphLogicalBounds[glyphIndex] == null && this.glyphVisible[glyphIndex]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[glyphIndex];
    }

    private void computeGlyphLogicalBounds() {
        GeneralPath gp;
        float y0;
        Rectangle2D nextGlyphBounds;
        Rectangle2D glyphBounds;
        float ascent = 0.0f;
        float descent = 0.0f;
        if (this.font != null) {
            GVTLineMetrics lineMetrics = this.font.getLineMetrics("By", this.frc);
            ascent = lineMetrics.getAscent();
            descent = lineMetrics.getDescent();
            if (descent < 0.0f) {
                descent = -descent;
            }
        }
        if (ascent == 0.0f) {
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            int i = 0;
            while (i < this.getNumGlyphs()) {
                if (this.glyphVisible[i]) {
                    GVTGlyphMetrics glyphMetrics = this.getGlyphMetrics(i);
                    Rectangle2D glyphBounds2 = glyphMetrics.getBounds2D();
                    ascent = (float)(-glyphBounds2.getMinY());
                    descent = (float)(glyphBounds2.getHeight() - (double)ascent);
                    if (ascent > maxAscent) {
                        maxAscent = ascent;
                    }
                    if (descent > maxDescent) {
                        maxDescent = descent;
                    }
                }
                ++i;
            }
            ascent = maxAscent;
            descent = maxDescent;
        }
        Shape[] tempLogicalBounds = new Shape[this.getNumGlyphs()];
        boolean[] rotated = new boolean[this.getNumGlyphs()];
        boolean[] flippedH = new boolean[this.getNumGlyphs()];
        boolean[] flippedV = new boolean[this.getNumGlyphs()];
        double maxWidth = -1.0;
        double maxHeight = -1.0;
        int i = 0;
        while (i < this.getNumGlyphs()) {
            if (!this.glyphVisible[i]) {
                tempLogicalBounds[i] = null;
            } else {
                AffineTransform glyphTransform = this.getGlyphTransform(i);
                GVTGlyphMetrics glyphMetrics = this.getGlyphMetrics(i);
                Rectangle2D.Double glyphBounds3 = new Rectangle2D.Double(0.0, -ascent, glyphMetrics.getHorizontalAdvance(), ascent + descent);
                if (((RectangularShape)glyphBounds3).isEmpty()) {
                    if (i > 0) {
                        rotated[i] = rotated[i - 1];
                        flippedH[i] = flippedH[i - 1];
                        flippedV[i] = flippedV[i - 1];
                    } else {
                        rotated[i] = true;
                        flippedH[i] = false;
                        flippedV[i] = false;
                    }
                } else {
                    Point2D.Double p1 = new Point2D.Double(glyphBounds3.getMinX(), glyphBounds3.getMinY());
                    Point2D.Double p2 = new Point2D.Double(glyphBounds3.getMaxX(), glyphBounds3.getMinY());
                    Point2D.Double p3 = new Point2D.Double(glyphBounds3.getMinX(), glyphBounds3.getMaxY());
                    AffineTransform tr = AffineTransform.getTranslateInstance(this.getGlyphPosition(i).getX(), this.getGlyphPosition(i).getY());
                    if (glyphTransform != null) {
                        tr.concatenate(glyphTransform);
                    }
                    tempLogicalBounds[i] = tr.createTransformedShape(glyphBounds3);
                    Point2D.Double tp1 = new Point2D.Double();
                    Point2D.Double tp2 = new Point2D.Double();
                    Point2D.Double tp3 = new Point2D.Double();
                    tr.transform(p1, tp1);
                    tr.transform(p2, tp2);
                    tr.transform(p3, tp3);
                    double tdx12 = ((Point2D)tp1).getX() - ((Point2D)tp2).getX();
                    double tdx13 = ((Point2D)tp1).getX() - ((Point2D)tp3).getX();
                    double tdy12 = ((Point2D)tp1).getY() - ((Point2D)tp2).getY();
                    double tdy13 = ((Point2D)tp1).getY() - ((Point2D)tp3).getY();
                    if (Math.abs(tdx12) < 0.001 && Math.abs(tdy13) < 0.001) {
                        rotated[i] = false;
                        double dx13 = ((Point2D)p1).getX() - ((Point2D)p3).getX();
                        double dy12 = ((Point2D)p1).getY() - ((Point2D)p2).getY();
                        if (Math.abs(tdx13 + dx13) < 0.001) {
                            flippedH[i] = true;
                        }
                        if (Math.abs(tdy12 + dy12) < 0.001) {
                            flippedV[i] = true;
                        }
                    } else if (Math.abs(tdx13) < 0.001 && Math.abs(tdy12) < 0.001) {
                        rotated[i] = false;
                        double dx12 = ((Point2D)p1).getX() - ((Point2D)p2).getX();
                        double dy13 = ((Point2D)p1).getY() - ((Point2D)p3).getY();
                        if (Math.abs(tdx12 + dx12) < 0.001) {
                            flippedH[i] = true;
                        }
                        if (Math.abs(tdy13 + dy13) < 0.001) {
                            flippedV[i] = true;
                        }
                    } else {
                        rotated[i] = true;
                        flippedH[i] = false;
                        flippedV[i] = false;
                    }
                    Rectangle2D rectBounds = tempLogicalBounds[i].getBounds2D();
                    if (rectBounds.getWidth() > maxWidth) {
                        maxWidth = rectBounds.getWidth();
                    }
                    if (rectBounds.getHeight() > maxHeight) {
                        maxHeight = rectBounds.getHeight();
                    }
                }
            }
            ++i;
        }
        GeneralPath logicalBoundsPath = new GeneralPath();
        int i2 = 0;
        while (i2 < this.getNumGlyphs()) {
            if (tempLogicalBounds[i2] != null) {
                logicalBoundsPath.append(tempLogicalBounds[i2], false);
            }
            ++i2;
        }
        Rectangle2D fullBounds = logicalBoundsPath.getBounds2D();
        if (fullBounds.getHeight() < maxHeight * 1.5) {
            int i3 = 0;
            while (i3 < this.getNumGlyphs()) {
                if (!rotated[i3] && tempLogicalBounds[i3] != null) {
                    glyphBounds = tempLogicalBounds[i3].getBounds2D();
                    double x = glyphBounds.getMinX();
                    double width = glyphBounds.getWidth();
                    if (i3 < this.getNumGlyphs() - 1 && tempLogicalBounds[i3 + 1] != null) {
                        nextGlyphBounds = tempLogicalBounds[i3 + 1].getBounds2D();
                        if (nextGlyphBounds.getX() > x) {
                            width = nextGlyphBounds.getX() - x;
                        } else {
                            double newGlyphX = nextGlyphBounds.getX() + nextGlyphBounds.getWidth();
                            width += x - newGlyphX;
                            x = newGlyphX;
                        }
                    }
                    float x0 = (float)x;
                    float x1 = (float)((double)x0 + width);
                    y0 = (float)fullBounds.getMinY();
                    float y1 = (float)((double)y0 + fullBounds.getHeight());
                    if (flippedH[i3]) {
                        if (flippedV[i3]) {
                            gp = new GeneralPath();
                            gp.moveTo(x1, y1);
                            gp.lineTo(x0, y1);
                            gp.lineTo(x0, y0);
                            gp.lineTo(x1, y0);
                            gp.lineTo(x1, y1);
                            gp.closePath();
                            tempLogicalBounds[i3] = gp;
                        } else {
                            gp = new GeneralPath();
                            gp.moveTo(x1, y0);
                            gp.lineTo(x0, y0);
                            gp.lineTo(x0, y1);
                            gp.lineTo(x1, y1);
                            gp.lineTo(x1, y0);
                            gp.closePath();
                            tempLogicalBounds[i3] = gp;
                        }
                    } else if (flippedV[i3]) {
                        gp = new GeneralPath();
                        gp.moveTo(x0, y1);
                        gp.lineTo(x1, y1);
                        gp.lineTo(x1, y0);
                        gp.lineTo(x0, y0);
                        gp.lineTo(x0, y1);
                        gp.closePath();
                        tempLogicalBounds[i3] = gp;
                    } else {
                        tempLogicalBounds[i3] = new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
                    }
                }
                ++i3;
            }
        } else if (fullBounds.getWidth() < maxWidth * 1.5) {
            int i4 = 0;
            while (i4 < this.getNumGlyphs()) {
                if (!rotated[i4] && tempLogicalBounds[i4] != null) {
                    glyphBounds = tempLogicalBounds[i4].getBounds2D();
                    double y = glyphBounds.getMinY();
                    double height = glyphBounds.getHeight();
                    if (i4 < this.getNumGlyphs() - 1 && tempLogicalBounds[i4 + 1] != null) {
                        nextGlyphBounds = tempLogicalBounds[i4 + 1].getBounds2D();
                        if (nextGlyphBounds.getY() > y) {
                            height = nextGlyphBounds.getY() - y;
                        } else {
                            double newGlyphY = nextGlyphBounds.getY() + nextGlyphBounds.getHeight();
                            height += y - newGlyphY;
                            y = newGlyphY;
                        }
                    }
                    float x0 = (float)fullBounds.getMinX();
                    float x1 = (float)((double)x0 + fullBounds.getWidth());
                    y0 = (float)y;
                    float y1 = (float)((double)y0 + height);
                    if (flippedH[i4]) {
                        if (flippedV[i4]) {
                            gp = new GeneralPath();
                            gp.moveTo(x1, y1);
                            gp.lineTo(x0, y1);
                            gp.lineTo(x0, y0);
                            gp.lineTo(x1, y0);
                            gp.lineTo(x1, y1);
                            gp.closePath();
                            tempLogicalBounds[i4] = gp;
                        } else {
                            gp = new GeneralPath();
                            gp.moveTo(x1, y0);
                            gp.lineTo(x0, y0);
                            gp.lineTo(x0, y1);
                            gp.lineTo(x1, y1);
                            gp.lineTo(x1, y0);
                            gp.closePath();
                            tempLogicalBounds[i4] = gp;
                        }
                    } else if (flippedV[i4]) {
                        gp = new GeneralPath();
                        gp.moveTo(x0, y1);
                        gp.lineTo(x1, y1);
                        gp.lineTo(x1, y0);
                        gp.lineTo(x0, y0);
                        gp.lineTo(x0, y1);
                        gp.closePath();
                        tempLogicalBounds[i4] = gp;
                    } else {
                        tempLogicalBounds[i4] = new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
                    }
                }
                ++i4;
            }
        }
        int i5 = 0;
        while (i5 < this.getNumGlyphs()) {
            this.glyphLogicalBounds[i5] = tempLogicalBounds[i5];
            ++i5;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        if (glyphIndex < this.glyphs.length - 1 && this.font != null) {
            float hkern = this.font.getHKern(this.glyphs[glyphIndex].getGlyphCode(), this.glyphs[glyphIndex + 1].getGlyphCode());
            float vkern = this.font.getVKern(this.glyphs[glyphIndex].getGlyphCode(), this.glyphs[glyphIndex + 1].getGlyphCode());
            return this.glyphs[glyphIndex].getGlyphMetrics(hkern, vkern);
        }
        return this.glyphs[glyphIndex].getGlyphMetrics();
    }

    public Shape getGlyphOutline(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[glyphIndex].getOutline();
    }

    public Point2D getGlyphPosition(int glyphIndex) {
        if (glyphIndex == this.glyphs.length) {
            return this.endPos;
        }
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[glyphIndex].getPosition();
    }

    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
        if (numEntries < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + numEntries + ", is illegal. It must be > 0.");
        }
        if (beginGlyphIndex < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + beginGlyphIndex + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (beginGlyphIndex + numEntries > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + beginGlyphIndex + "+" + numEntries + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (positionReturn == null) {
            positionReturn = new float[numEntries * 2];
        }
        if (beginGlyphIndex + numEntries == this.glyphs.length + 1) {
            positionReturn[--numEntries * 2] = (float)this.endPos.getX();
            positionReturn[numEntries * 2 + 1] = (float)this.endPos.getY();
        }
        int i = beginGlyphIndex;
        while (i < beginGlyphIndex + numEntries) {
            Point2D glyphPos = this.glyphs[i].getPosition();
            positionReturn[(i - beginGlyphIndex) * 2] = (float)glyphPos.getX();
            positionReturn[(i - beginGlyphIndex) * 2 + 1] = (float)glyphPos.getY();
            ++i;
        }
        return positionReturn;
    }

    public AffineTransform getGlyphTransform(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[glyphIndex].getTransform();
    }

    public Shape getGlyphVisualBounds(int glyphIndex) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[glyphIndex].getOutline();
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator aci) {
        if (this.bounds2D != null) {
            return this.bounds2D;
        }
        Rectangle2D b = null;
        int i = 0;
        while (i < this.getNumGlyphs()) {
            Rectangle2D glyphBounds;
            if (this.glyphVisible[i] && (glyphBounds = this.glyphs[i].getBounds2D()) != null) {
                b = b == null ? glyphBounds : glyphBounds.createUnion(b);
            }
            ++i;
        }
        this.bounds2D = b;
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath logicalBoundsPath = new GeneralPath();
            int i = 0;
            while (i < this.getNumGlyphs()) {
                Shape glyphLogicalBounds = this.getGlyphLogicalBounds(i);
                if (glyphLogicalBounds != null) {
                    logicalBoundsPath.append(glyphLogicalBounds, false);
                }
                ++i;
            }
            this.logicalBounds = logicalBoundsPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.length;
        }
        return 0;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            int i = 0;
            while (i < this.glyphs.length) {
                Shape glyphOutline;
                if (this.glyphVisible[i] && (glyphOutline = this.glyphs[i].getOutline()) != null) {
                    this.outline.append(glyphOutline, false);
                }
                ++i;
            }
        }
        return this.outline;
    }

    public Shape getOutline(float x, float y) {
        Shape outline = this.getOutline();
        AffineTransform tr = AffineTransform.getTranslateInstance(x, y);
        Shape translatedOutline = tr.createTransformedShape(outline);
        return translatedOutline;
    }

    public Rectangle2D getGeometricBounds() {
        return this.getOutline().getBounds2D();
    }

    public void performDefaultLayout() {
        float currentX = 0.0f;
        float currentY = 0.0f;
        int i = 0;
        while (i < this.glyphs.length) {
            this.glyphs[i].setPosition(new Point2D.Float(currentX, currentY));
            this.glyphs[i].setTransform(null);
            this.glyphLogicalBounds[i] = null;
            currentX += this.glyphs[i].getHorizAdvX();
            this.logicalBounds = null;
            this.outline = null;
            this.bounds2D = null;
            ++i;
        }
        this.endPos = new Point2D.Float(currentX, currentY);
    }

    public void setGlyphPosition(int glyphIndex, Point2D newPos) throws IndexOutOfBoundsException {
        if (glyphIndex == this.glyphs.length) {
            this.endPos = (Point2D)newPos.clone();
            return;
        }
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[glyphIndex].setPosition(newPos);
        this.glyphLogicalBounds[glyphIndex] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int glyphIndex, AffineTransform newTX) {
        if (glyphIndex < 0 || glyphIndex > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + glyphIndex + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[glyphIndex].setTransform(newTX);
        this.glyphLogicalBounds[glyphIndex] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphVisible(int glyphIndex, boolean visible) {
        if (visible == this.glyphVisible[glyphIndex]) {
            return;
        }
        this.glyphVisible[glyphIndex] = visible;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds[glyphIndex] = null;
    }

    public boolean isGlyphVisible(int glyphIndex) {
        return this.glyphVisible[glyphIndex];
    }

    public int getCharacterCount(int startGlyphIndex, int endGlyphIndex) {
        int numChars = 0;
        if (startGlyphIndex < 0) {
            startGlyphIndex = 0;
        }
        if (endGlyphIndex > this.glyphs.length - 1) {
            endGlyphIndex = this.glyphs.length - 1;
        }
        int i = startGlyphIndex;
        while (i <= endGlyphIndex) {
            String glyphUnicode = this.glyphs[i].getUnicode();
            numChars += glyphUnicode.length();
            ++i;
        }
        return numChars;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator aci) {
        int i = 0;
        while (i < this.glyphs.length) {
            if (this.glyphVisible[i]) {
                this.glyphs[i].draw(graphics2D);
            }
            ++i;
        }
    }
}

