/*
 * $Id: JXListPanel.java,v 1.1 2004/07/28 21:21:11 aim Exp $
 *
 * Copyright 2004 Sun Microsystems, Inc., 4150 Network Circle,
 * Santa Clara, California 95054, U.S.A. All rights reserved.
 */

package org.jdesktop.swing;

import java.awt.*;

import javax.swing.*;

/**
 * A form control to represents arrays or list of items.
 * This will be adapted into some sort of list editor.
 */
public class JXListPanel extends JPanel {

    private static Dimension PREFSIZE = new Dimension(200, 34);
    private JList list;

    public JXListPanel() {
	setLayout(new BorderLayout());

	list = new JList();
	list.setPrototypeCellValue("MondayXXXXXXXXXXX");

	add(new JScrollPane(list));
    }

    public JList getList() {
	return list;
    }

    public Dimension getPreferredSize() {
	return PREFSIZE;
    }

    public Dimension getMaximiumSize() {
	return getPreferredSize();
    }

}
