/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda;

import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.sf.memoranda.HistoryItem;
import net.sf.memoranda.HistoryListener;
import net.sf.memoranda.Project;
import net.sf.memoranda.util.Local;

public class History {
    static Vector _list = new Vector();
    static int p = -1;
    static Vector historyListeners = new Vector();
    static Object next = null;
    static Object prev = null;
    public static HistoryBackAction historyBackAction = new HistoryBackAction();
    public static HistoryForwardAction historyForwardAction = new HistoryForwardAction();
    static /* synthetic */ Class class$net$sf$memoranda$ui$AppFrame;

    public static void add(HistoryItem historyItem) {
        if (prev != null && historyItem.equals(prev)) {
            return;
        }
        if (p < _list.size() - 1) {
            _list.setSize(p + 1);
        }
        _list.add(historyItem);
        p = _list.size() - 1;
        prev = p > 0 ? _list.get(p - 1) : null;
        next = null;
        historyBackAction.update();
        historyForwardAction.update();
        if (_list.size() > 99) {
            _list.remove(0);
        }
    }

    public static HistoryItem rollBack() {
        Object object = prev;
        if (p > 1) {
            prev = _list.get(--p - 1);
        } else if (p > 0) {
            --p;
            prev = null;
        } else {
            prev = null;
        }
        next = p < _list.size() - 1 ? _list.get(p + 1) : null;
        return (HistoryItem)object;
    }

    public static HistoryItem rollForward() {
        Object object = next;
        if (p < _list.size() - 1) {
            if (++p == 1) {
                ++p;
            }
            next = _list.get(p);
        } else {
            next = null;
        }
        prev = p > 0 ? _list.get(p - 1) : null;
        return (HistoryItem)object;
    }

    public static boolean canRollBack() {
        return prev != null;
    }

    public static boolean canRollForward() {
        return next != null;
    }

    public static void addHistoryListener(HistoryListener historyListener) {
        historyListeners.add(historyListener);
    }

    public static void removeProjectHistory(Project project) {
        Vector vector = new Vector();
        for (int i = 0; i < _list.size(); ++i) {
            String string = ((HistoryItem)_list.elementAt(i)).getProject().getID();
            if (!string.equals(project.getID())) continue;
            vector.add(_list.elementAt(i));
            --p;
            if (!_list.elementAt(i).equals(prev)) continue;
            prev = p > 0 ? _list.get(p - 1) : null;
        }
        if (!vector.isEmpty()) {
            _list.removeAll(vector);
            if (p < 0) {
                p = 0;
            }
            _list.setSize(p);
            next = null;
            historyBackAction.update();
            historyForwardAction.update();
        }
    }

    private static void notifyListeners(HistoryItem historyItem) {
        for (int i = 0; i < historyListeners.size(); ++i) {
            ((HistoryListener)historyListeners.get(i)).historyWasRolledTo(historyItem);
        }
    }

    static class HistoryForwardAction
    extends AbstractAction {
        public HistoryForwardAction() {
            super(Local.getString("History forward"), new ImageIcon((class$net$sf$memoranda$ui$AppFrame == null ? (class$net$sf$memoranda$ui$AppFrame = History.class$("net.sf.memoranda.ui.AppFrame")) : class$net$sf$memoranda$ui$AppFrame).getResource("resources/icons/hist_forward.png")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 8));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            History.notifyListeners(History.rollForward());
            this.update();
            historyBackAction.update();
        }

        void update() {
            if (History.canRollForward()) {
                this.setEnabled(true);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
                Date date = ((HistoryItem)next).getDate().getDate();
                this.putValue("ShortDescription", Local.getString("Forward to") + " " + simpleDateFormat.format(date));
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", Local.getString("Forward"));
            }
        }
    }

    static class HistoryBackAction
    extends AbstractAction {
        public HistoryBackAction() {
            super(Local.getString("History back"), new ImageIcon((class$net$sf$memoranda$ui$AppFrame == null ? (class$net$sf$memoranda$ui$AppFrame = History.class$("net.sf.memoranda.ui.AppFrame")) : class$net$sf$memoranda$ui$AppFrame).getResource("resources/icons/hist_back.png")));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 8));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            History.notifyListeners(History.rollBack());
            this.update();
            historyForwardAction.update();
        }

        void update() {
            if (History.canRollBack()) {
                this.setEnabled(true);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
                Date date = ((HistoryItem)prev).getDate().getDate();
                this.putValue("ShortDescription", Local.getString("Back to") + " " + simpleDateFormat.format(date));
            } else {
                this.setEnabled(false);
                this.putValue("ShortDescription", Local.getString("Back"));
            }
        }
    }
}

