/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.date;

import java.util.Calendar;
import java.util.Date;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;

public class CalendarDate {
    private int _year;
    private int _month;
    private int _day;

    public static Calendar dateToCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public CalendarDate() {
        this(Calendar.getInstance());
    }

    public CalendarDate(int n, int n2, int n3) {
        this._year = n3;
        this._month = n2;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this._year);
        calendar.set(2, this._month);
        calendar.getTime();
        int n4 = calendar.getActualMaximum(5);
        this._day = n <= n4 ? n : n4;
    }

    public CalendarDate(Calendar calendar) {
        this._year = calendar.get(1);
        this._day = calendar.get(5);
        this._month = calendar.get(2);
    }

    public CalendarDate(Date date) {
        this(CalendarDate.dateToCalendar(date));
    }

    public CalendarDate(String string) {
        int[] nArray = Util.parseDateStamp(string);
        this._day = nArray[0];
        this._month = nArray[1];
        this._year = nArray[2];
    }

    public static CalendarDate today() {
        return new CalendarDate();
    }

    public static CalendarDate yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.roll(5, false);
        return new CalendarDate(calendar);
    }

    public static CalendarDate tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.roll(5, true);
        return new CalendarDate(calendar);
    }

    public static Calendar toCalendar(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n3);
        calendar.set(2, n2);
        calendar.set(5, n);
        calendar.getTime();
        return calendar;
    }

    public static Date toDate(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n3);
        calendar.set(2, n2);
        calendar.set(5, n);
        return calendar.getTime();
    }

    public Calendar getCalendar() {
        return CalendarDate.toCalendar(this._day, this._month, this._year);
    }

    public Date getDate() {
        return CalendarDate.toDate(this._day, this._month, this._year);
    }

    public int getDay() {
        return this._day;
    }

    public int getMonth() {
        return this._month;
    }

    public int getYear() {
        return this._year;
    }

    public boolean equals(Object object) {
        if (object.getClass().isInstance(CalendarDate.class)) {
            CalendarDate calendarDate = (CalendarDate)object;
            return calendarDate.getDay() == this.getDay() && calendarDate.getMonth() == this.getMonth() && calendarDate.getYear() == this.getYear();
        }
        if (object.getClass().isInstance(Calendar.class)) {
            Calendar calendar = (Calendar)object;
            return this.equals(new CalendarDate(calendar));
        }
        if (object.getClass().isInstance(Date.class)) {
            Date date = (Date)object;
            return this.equals(new CalendarDate(date));
        }
        return super.equals(object);
    }

    public boolean equals(CalendarDate calendarDate) {
        if (calendarDate == null) {
            return false;
        }
        return calendarDate.getDay() == this.getDay() && calendarDate.getMonth() == this.getMonth() && calendarDate.getYear() == this.getYear();
    }

    public boolean before(CalendarDate calendarDate) {
        if (calendarDate == null) {
            return true;
        }
        return this.getCalendar().before(calendarDate.getCalendar());
    }

    public boolean after(CalendarDate calendarDate) {
        if (calendarDate == null) {
            return true;
        }
        return this.getCalendar().after(calendarDate.getCalendar());
    }

    public boolean inPeriod(CalendarDate calendarDate, CalendarDate calendarDate2) {
        return this.after(calendarDate) && this.before(calendarDate2) || this.equals(calendarDate) || this.equals(calendarDate2);
    }

    public String toString() {
        return Util.getDateStamp(this);
    }

    public String getFullDateString() {
        return Local.getDateString(this, 0);
    }

    public String getMediumDateString() {
        return Local.getDateString(this, 2);
    }

    public String getLongDateString() {
        return Local.getDateString(this, 1);
    }

    public String getShortDateString() {
        return Local.getDateString(this, 3);
    }
}

