/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.sf.memoranda.util.Local;

public class AllFilesFilter
extends FileFilter {
    public static final String RTF = "RTF";
    public static final String HTML = "HTML";
    public static final String HTM = "HTM";
    public static final String XHTML = "XHTML";
    public static final String XML = "XML";
    public static final String ZIP = "ZIP";
    public static final String EXE = "EXE";
    public static final String COM = "COM";
    public static final String BAT = "BAT";
    public static final String JAR = "JAR";
    public static final String ICO = "ICO";
    public static final String WAV = "WAV";
    String _type = "";

    public AllFilesFilter(String string) {
        this._type = string;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = AllFilesFilter.getExtension(file);
        if (this._type.equals(RTF)) {
            return string.equals("rtf");
        }
        if (this._type.equals(ZIP)) {
            return string.equals("zip");
        }
        if (this._type.equals(EXE)) {
            return string.equals("exe") || string.equals("com") || string.equals("bat");
        }
        if (this._type.equals(JAR)) {
            return string.equals("jar");
        }
        if (this._type.equals(WAV)) {
            return string.equals("wav") || string.equals("au");
        }
        if (this._type.equals(XHTML)) {
            return string.equals("xhtml") || string.equals("xml");
        }
        if (this._type.equals(ICO)) {
            return string.equals("ico") || string.equals("png");
        }
        return string.startsWith("htm");
    }

    public String getDescription() {
        if (this._type.equals(RTF)) {
            return "Rich Text Format (*.rtf)";
        }
        if (this._type.equals(ZIP)) {
            return "ZIP archives (*.zip)";
        }
        if (this._type.equals(EXE)) {
            return Local.getString("Executable Files") + " (*.exe, *.com, *.bat)";
        }
        if (this._type.equals(JAR)) {
            return "JAR " + Local.getString("Files") + " (*.jar)";
        }
        if (this._type.equals(WAV)) {
            return Local.getString("Sound files") + " (*.wav, *.au)";
        }
        if (this._type.equals(XHTML)) {
            return "XHTML files (*.xhtml, *.xml)";
        }
        if (this._type.equals(ICO)) {
            return Local.getString("Icon") + " " + Local.getString("Files") + " (*.ico, *.png)";
        }
        return "HTML files (*.html, *.htm)";
    }

    private static String getExtension(File file) {
        String string = "";
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }
}

