/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.JNCalendar;
import net.sf.memoranda.util.Local;

public class JNCalendarPanel
extends JPanel {
    CalendarDate _date = CurrentDate.get();
    JToolBar navigationBar = new JToolBar();
    JPanel mntyPanel = new JPanel(new BorderLayout());
    JPanel navbPanel = new JPanel(new BorderLayout());
    JButton dayForwardB = new JButton();
    JPanel dayForwardBPanel = new JPanel();
    JButton todayB = new JButton();
    JPanel todayBPanel = new JPanel();
    JPanel dayBackBPanel = new JPanel();
    JButton dayBackB = new JButton();
    JComboBox monthsCB = new JComboBox<String>(Local.getMonthNames());
    BorderLayout borderLayout4 = new BorderLayout();
    JNCalendar jnCalendar = new JNCalendar(CurrentDate.get());
    JPanel jnCalendarPanel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JSpinner yearSpin = new JSpinner(new SpinnerNumberModel(this.jnCalendar.get().getYear(), 1980, 2999, 1));
    JSpinner.NumberEditor yearSpinner = new JSpinner.NumberEditor(this.yearSpin, "####");
    boolean ignoreChange = false;
    private Vector selectionListeners = new Vector();
    Border border1;
    Border border2;
    public Action dayBackAction = new AbstractAction("Go one day back", new ImageIcon(AppFrame.class.getResource("resources/icons/back16.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            JNCalendarPanel.this.dayBackB_actionPerformed(actionEvent);
        }
    };
    public Action dayForwardAction = new AbstractAction("Go one day forward", new ImageIcon(AppFrame.class.getResource("resources/icons/forward16.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            JNCalendarPanel.this.dayForwardB_actionPerformed(actionEvent);
        }
    };
    public Action todayAction = new AbstractAction("Go to today", new ImageIcon(AppFrame.class.getResource("resources/icons/today16.png"))){

        public void actionPerformed(ActionEvent actionEvent) {
            JNCalendarPanel.this.todayB_actionPerformed(actionEvent);
        }
    };

    public JNCalendarPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.todayAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(36, 8));
        this.monthsCB.setRequestFocusEnabled(false);
        this.monthsCB.setMaximumRowCount(12);
        this.monthsCB.setPreferredSize(new Dimension(50, 20));
        this.border1 = BorderFactory.createEmptyBorder(0, 0, 5, 0);
        this.border2 = BorderFactory.createEmptyBorder();
        this.setLayout(new BorderLayout());
        this.navigationBar.setFloatable(false);
        this.dayForwardB.setAction(this.dayForwardAction);
        this.dayForwardB.setMinimumSize(new Dimension(24, 24));
        this.dayForwardB.setOpaque(false);
        this.dayForwardB.setPreferredSize(new Dimension(24, 24));
        this.dayForwardB.setRequestFocusEnabled(false);
        this.dayForwardB.setBorderPainted(false);
        this.dayForwardB.setFocusPainted(false);
        this.dayForwardB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/forward.png")));
        this.dayForwardB.setText("");
        this.dayForwardB.setToolTipText(Local.getString("One day forward"));
        this.dayForwardBPanel.setAlignmentX(0.0f);
        this.dayForwardBPanel.setMinimumSize(new Dimension(40, 24));
        this.dayForwardBPanel.setOpaque(false);
        this.dayForwardBPanel.setPreferredSize(new Dimension(40, 24));
        this.todayB.setAction(this.todayAction);
        this.todayB.setMinimumSize(new Dimension(24, 24));
        this.todayB.setOpaque(false);
        this.todayB.setPreferredSize(new Dimension(24, 24));
        this.todayB.setRequestFocusEnabled(false);
        this.todayB.setBorderPainted(false);
        this.todayB.setFocusPainted(false);
        this.todayB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/today.png")));
        this.todayB.setText("");
        this.todayB.setToolTipText(Local.getString("To today"));
        this.dayBackBPanel.setAlignmentX(1.5f);
        this.dayBackBPanel.setMinimumSize(new Dimension(40, 24));
        this.dayBackBPanel.setOpaque(false);
        this.dayBackBPanel.setPreferredSize(new Dimension(40, 24));
        this.dayBackB.setAction(this.dayBackAction);
        this.dayBackB.setMinimumSize(new Dimension(24, 24));
        this.dayBackB.setOpaque(false);
        this.dayBackB.setPreferredSize(new Dimension(24, 24));
        this.dayBackB.setRequestFocusEnabled(false);
        this.dayBackB.setToolTipText("");
        this.dayBackB.setBorderPainted(false);
        this.dayBackB.setFocusPainted(false);
        this.dayBackB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/back.png")));
        this.dayBackB.setText("");
        this.dayBackB.setToolTipText(Local.getString("One day back"));
        this.yearSpin.setPreferredSize(new Dimension(70, 20));
        this.yearSpin.setRequestFocusEnabled(false);
        this.yearSpin.setEditor(this.yearSpinner);
        this.navbPanel.setMinimumSize(new Dimension(202, 30));
        this.navbPanel.setOpaque(false);
        this.navbPanel.setPreferredSize(new Dimension(155, 30));
        this.jnCalendar.getTableHeader().setFont(new Font("Dialog", 1, 10));
        this.jnCalendar.setFont(new Font("Dialog", 0, 10));
        this.jnCalendar.setGridColor(Color.lightGray);
        this.jnCalendarPanel.setLayout(this.borderLayout5);
        this.todayBPanel.setMinimumSize(new Dimension(68, 24));
        this.todayBPanel.setOpaque(false);
        this.todayBPanel.setPreferredSize(new Dimension(51, 24));
        this.add((Component)this.navigationBar, "North");
        this.navigationBar.add((Component)this.navbPanel, null);
        this.navbPanel.add((Component)this.dayBackBPanel, "West");
        this.dayBackBPanel.add((Component)this.dayBackB, null);
        this.navbPanel.add((Component)this.todayBPanel, "Center");
        this.todayBPanel.add((Component)this.todayB, null);
        this.navbPanel.add((Component)this.dayForwardBPanel, "East");
        this.dayForwardBPanel.add((Component)this.dayForwardB, null);
        this.add((Component)this.mntyPanel, "South");
        this.mntyPanel.add((Component)this.monthsCB, "Center");
        this.mntyPanel.add((Component)this.yearSpin, "East");
        this.add((Component)this.jnCalendarPanel, "Center");
        this.jnCalendar.getTableHeader().setPreferredSize(new Dimension(200, 15));
        this.jnCalendarPanel.add((Component)this.jnCalendar.getTableHeader(), "North");
        this.jnCalendarPanel.add((Component)this.jnCalendar, "Center");
        this.jnCalendar.addSelectionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JNCalendarPanel.this.setCurrentDateDay(JNCalendarPanel.this.jnCalendar.get(), JNCalendarPanel.this.jnCalendar.get().getDay());
            }
        });
        this.monthsCB.setFont(new Font("Dialog", 0, 11));
        this.monthsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JNCalendarPanel.this.monthsCB_actionPerformed(actionEvent);
            }
        });
        this.yearSpin.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JNCalendarPanel.this.yearSpin_actionPerformed();
            }
        });
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
            }

            public void projectWasChanged() {
                JNCalendarPanel.this.jnCalendar.updateUI();
            }
        });
        this.refreshView();
        this.yearSpin.setBorder(this.border2);
    }

    public void set(CalendarDate calendarDate) {
        this._date = calendarDate;
        this.refreshView();
    }

    public CalendarDate get() {
        return this._date;
    }

    public void addSelectionListener(ActionListener actionListener) {
        this.selectionListeners.add(actionListener);
    }

    private void notifyListeners() {
        Enumeration enumeration = this.selectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ActionListener)enumeration.nextElement()).actionPerformed(new ActionEvent(this, 0, "Calendar event"));
        }
    }

    private void setCurrentDateDay(CalendarDate calendarDate, int n) {
        if (this.ignoreChange) {
            return;
        }
        if (this._date.equals(calendarDate)) {
            return;
        }
        this._date = new CalendarDate(n, this._date.getMonth(), this._date.getYear());
        this.notifyListeners();
    }

    private void refreshView() {
        this.ignoreChange = true;
        this.jnCalendar.set(this._date);
        this.monthsCB.setSelectedIndex(this._date.getMonth());
        this.yearSpin.setValue(new Integer(this._date.getYear()));
        this.ignoreChange = false;
    }

    void monthsCB_actionPerformed(ActionEvent actionEvent) {
        if (this.ignoreChange) {
            return;
        }
        this._date = new CalendarDate(this._date.getDay(), this.monthsCB.getSelectedIndex(), this._date.getYear());
        this.jnCalendar.set(this._date);
        this.notifyListeners();
    }

    void yearSpin_actionPerformed() {
        if (this.ignoreChange) {
            return;
        }
        this._date = new CalendarDate(this._date.getDay(), this._date.getMonth(), (Integer)this.yearSpin.getValue());
        this.jnCalendar.set(this._date);
        this.notifyListeners();
    }

    void dayBackB_actionPerformed(ActionEvent actionEvent) {
        Calendar calendar = this._date.getCalendar();
        calendar.add(5, -1);
        calendar.getTime();
        this._date = new CalendarDate(calendar);
        this.refreshView();
        this.notifyListeners();
    }

    void todayB_actionPerformed(ActionEvent actionEvent) {
        this._date = CalendarDate.today();
        this.refreshView();
        this.notifyListeners();
    }

    void dayForwardB_actionPerformed(ActionEvent actionEvent) {
        Calendar calendar = this._date.getCalendar();
        calendar.add(5, 1);
        calendar.getTime();
        this._date = new CalendarDate(calendar);
        this.refreshView();
        this.notifyListeners();
    }
}

