/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Component;
import java.awt.Font;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import net.sf.memoranda.CurrentNote;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Note;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.NoteListener;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.util.Configuration;

public class NotesList
extends JList {
    public static final int EMPTY = 0;
    public static final int ALL = 1;
    public static final int BOOKMARKS = 2;
    private Vector notes = null;
    boolean sortOrderDesc = false;
    int _type = 1;
    ImageIcon bookmarkIcon = new ImageIcon(AppFrame.class.getResource("resources/icons/star8.png"));

    public NotesList(int n) {
        if (Configuration.get("NOTES_SORT_ORDER").toString().equalsIgnoreCase("true")) {
            this.sortOrderDesc = true;
        }
        this._type = n;
        this.setFont(new Font("Dialog", 0, 11));
        this.setModel(new NotesListModel());
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                NotesList.this.updateUI();
            }
        });
        CurrentNote.addNoteListener(new NoteListener(){

            public void noteChange(Note note, boolean bl) {
                NotesList.this.updateUI();
            }
        });
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
            }

            public void projectWasChanged() {
                NotesList.this.update();
            }
        });
        this.setSelectionMode(2);
    }

    public NotesList() {
        this(1);
    }

    public void update() {
        if (this._type != 0) {
            this.update(CurrentProject.getNoteList());
        } else {
            this.update(new Vector());
        }
    }

    public void update(NoteList noteList) {
        this.notes = this._type == 1 ? (Vector)noteList.getAllNotes() : (Vector)noteList.getMarkedNotes();
        Collections.sort(this.notes);
        if (this.sortOrderDesc) {
            Collections.reverse(this.notes);
        }
        this.updateUI();
    }

    public void update(Vector vector) {
        this.notes = vector;
        Collections.sort(this.notes);
        if (this.sortOrderDesc) {
            Collections.reverse(this.notes);
        }
        this.updateUI();
    }

    public Note getNote(int n) {
        return (Note)this.notes.get(n);
    }

    void invertSortOrder() {
        this.sortOrderDesc = !this.sortOrderDesc;
    }

    public ListCellRenderer getCellRenderer() {
        return new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                String string = object.toString();
                jLabel.setText(string);
                Note note = CurrentNote.get();
                if (note != null && NotesList.this.getNote(n).getId().equals(note.getId())) {
                    jLabel.setFont(jLabel.getFont().deriveFont(1));
                }
                if (NotesList.this.getNote(n).isMarked()) {
                    jLabel.setIcon(NotesList.this.bookmarkIcon);
                }
                jLabel.setToolTipText(string);
                return jLabel;
            }
        };
    }

    public class NotesListModel
    extends AbstractListModel {
        public NotesListModel() {
            NotesList.this.update();
        }

        public Object getElementAt(int n) {
            Note note = (Note)NotesList.this.notes.get(n);
            return note.getDate().getShortDateString() + " " + note.getTitle();
        }

        public int getSize() {
            return NotesList.this.notes.size();
        }
    }
}

