/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.Context;
import net.sf.memoranda.util.Local;

public class StickerDialog
extends JDialog {
    public boolean CANCELLED = true;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton cancelButton = new JButton();
    JButton okButton = new JButton();
    JPanel bottomPanel = new JPanel();
    JPanel topPanel = new JPanel();
    JLabel header = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel1 = new JPanel();
    JTextArea stickerText = new JTextArea();
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout3 = new BorderLayout();
    Border border1;
    Border border2;
    Color[] colors = new Color[]{Color.YELLOW, Color.ORANGE, Color.RED, Color.BLUE, Color.GREEN, Color.CYAN, Color.MAGENTA, Color.PINK};
    String[] colorLabels = new String[]{Local.getString("Yellow"), Local.getString("Orange"), Local.getString("Red"), Local.getString("Blue"), Local.getString("Green"), Local.getString("Cyan"), Local.getString("Magenta"), Local.getString("Pink"), Local.getString("Custom") + "..."};
    JComboBox stickerColor = new JComboBox<String>(this.colorLabels);

    public StickerDialog(Frame frame) {
        super(frame, Local.getString("Sticker"), true);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    public StickerDialog() {
        this((Frame)null);
    }

    void jbInit() throws Exception {
        this.stickerColor.setRenderer(new ComboBoxRenderer());
        this.stickerColor.setMaximumRowCount(9);
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border2 = BorderFactory.createEmptyBorder(5, 0, 5, 0);
        this.panel1.setLayout(this.borderLayout1);
        this.getContentPane().setLayout(this.borderLayout2);
        this.cancelButton.setMaximumSize(new Dimension(100, 25));
        this.cancelButton.setMinimumSize(new Dimension(100, 25));
        this.cancelButton.setPreferredSize(new Dimension(100, 25));
        this.cancelButton.setText(Local.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StickerDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.okButton.setMaximumSize(new Dimension(100, 25));
        this.okButton.setMinimumSize(new Dimension(100, 25));
        this.okButton.setPreferredSize(new Dimension(100, 25));
        this.okButton.setText(Local.getString("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StickerDialog.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.topPanel.setLayout(new FlowLayout(0));
        this.topPanel.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        this.topPanel.setBackground(Color.WHITE);
        this.header.setFont(new Font("Dialog", 0, 20));
        this.header.setForeground(new Color(0, 0, 124));
        this.header.setText(Local.getString("Sticker"));
        this.header.setIcon(new ImageIcon(StickerDialog.class.getResource("resources/icons/sticker48.png")));
        this.jLabel1.setText(Local.getString("Sticker color") + ": ");
        this.jPanel1.setLayout(this.borderLayout3);
        this.panel1.setBorder(this.border1);
        this.jPanel1.setBorder(this.border2);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.stickerText, null);
        this.panel1.add((Component)this.jPanel1, "South");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.bottomPanel.add(this.okButton);
        this.bottomPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.topPanel.add(this.header);
        this.jPanel1.add((Component)this.jLabel1, "West");
        this.jPanel1.add((Component)this.stickerColor, "Center");
        if (Context.get("STICKER_COLOR") != null) {
            Color color = new Color(new Integer(Context.get("STICKER_COLOR").toString()));
            this.stickerText.setBackground(color);
            int n = this.findColorIndex(color);
            if (n > -1) {
                this.stickerColor.setSelectedIndex(n);
            } else {
                this.stickerColor.setSelectedIndex(8);
            }
        } else {
            this.stickerText.setBackground(Color.YELLOW);
        }
        this.stickerText.setWrapStyleWord(true);
        this.stickerText.setText(CalendarDate.today().getLongDateString() + " " + DateFormat.getTimeInstance(3, Local.getCurrentLocale()).format(new Date()) + "\n");
        this.stickerColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StickerDialog.this.stickerColor_actionPerformed(actionEvent);
            }
        });
    }

    int findColorIndex(Color color) {
        for (int i = 0; i < this.colors.length; ++i) {
            if (!color.equals(this.colors[i])) continue;
            return i;
        }
        return -1;
    }

    public String getStickerText() {
        return this.stickerText.getText();
    }

    public String getStickerColor() {
        return "#" + Integer.toHexString(this.stickerText.getBackground().getRGB() - -16777216).toUpperCase();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void okButton_actionPerformed(ActionEvent actionEvent) {
        this.CANCELLED = false;
        this.dispose();
    }

    void stickerColor_actionPerformed(ActionEvent actionEvent) {
        if (this.stickerColor.getSelectedIndex() < this.colors.length) {
            this.stickerText.setBackground(this.colors[this.stickerColor.getSelectedIndex()]);
        } else {
            Color color = JColorChooser.showDialog(this, Local.getString("Sticker color"), this.stickerText.getBackground());
            if (color != null) {
                this.stickerText.setBackground(color);
            }
        }
        Context.put("STICKER_COLOR", new Integer(this.stickerText.getBackground().getRGB()));
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (n > -1 && n < StickerDialog.this.colors.length) {
                this.setBackground(StickerDialog.this.colors[n]);
            } else {
                this.setBackground(jList.getBackground());
            }
            this.setForeground(jList.getForeground());
            this.setText(object.toString());
            return this;
        }
    }
}

