/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Project;
import net.sf.memoranda.Task;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.ui.TaskTable;
import net.sf.memoranda.ui.TaskTableModel;

public class TaskTableSorter
extends TaskTableModel {
    int sorting_column = -1;
    boolean opposite = false;
    Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (TaskTableSorter.this.sorting_column == -1) {
                return 0;
            }
            if (!(object instanceof Task)) {
                return 0;
            }
            if (!(object2 instanceof Task)) {
                return 0;
            }
            Task task = (Task)object;
            Task task2 = (Task)object2;
            switch (TaskTableSorter.this.sorting_column) {
                case 1: {
                    return task.getText().compareTo(task2.getText());
                }
                case 2: {
                    return task.getStartDate().getDate().compareTo(task2.getStartDate().getDate());
                }
                case 3: {
                    return task.getEndDate().getDate().compareTo(task2.getEndDate().getDate());
                }
                case 0: 
                case 4: {
                    return task.getPriority() - task2.getPriority();
                }
                case 5: {
                    return task.getStatus(CurrentDate.get()) - task2.getStatus(CurrentDate.get());
                }
                case 6: {
                    return task.getProgress() - task2.getProgress();
                }
            }
            return 0;
        }
    };

    public TaskTableSorter(TaskTable taskTable) {
        JTableHeader jTableHeader = taskTable.getTableHeader();
        jTableHeader.addMouseListener(new MouseHandler());
        jTableHeader.setDefaultRenderer(new SortableHeaderRenderer());
    }

    public Object getChild(Object object, int n) {
        Object[] objectArray;
        Collection collection = null;
        if (object instanceof Project) {
            collection = this.activeOnly() ? CurrentProject.getTaskList().getActiveSubTasks(null, CurrentDate.get()) : CurrentProject.getTaskList().getTopLevelTasks();
        } else {
            objectArray = (Object[])object;
            collection = this.activeOnly() ? CurrentProject.getTaskList().getActiveSubTasks(objectArray.getID(), CurrentDate.get()) : objectArray.getSubTasks();
        }
        objectArray = collection.toArray();
        Arrays.sort(objectArray, this.comparator);
        if (this.opposite) {
            return objectArray[objectArray.length - n - 1];
        }
        return objectArray[n];
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private SortableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel(object.toString());
            if (n2 == TaskTableSorter.this.sorting_column) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            } else {
                jLabel.setFont(jLabel.getFont().deriveFont(0));
            }
            return jLabel;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
            int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
            if (n2 != -1) {
                TaskTableSorter.this.sorting_column = n2;
                if (n2 == 0) {
                    TaskTableSorter.this.sorting_column = 4;
                }
                if (mouseEvent.isControlDown()) {
                    TaskTableSorter.this.sorting_column = -1;
                } else {
                    TaskTableSorter.this.opposite = !TaskTableSorter.this.opposite;
                }
                TaskTable taskTable = (TaskTable)jTableHeader.getTable();
                taskTable.tableChanged();
                jTableHeader.resizeAndRepaint();
            }
        }
    }
}

