/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui.htmleditor;

import java.awt.Polygon;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Option;
import javax.swing.text.html.StyleSheet;

public class AltHTMLWriter
extends AbstractWriter {
    private Stack blockElementStack = new Stack();
    private boolean inContent = false;
    private boolean inPre = false;
    private int preEndOffset;
    private boolean inTextArea = false;
    private boolean newlineOutputed = false;
    private boolean completeDoc;
    private Vector tags = new Vector(10);
    private Vector tagValues = new Vector(10);
    private Segment segment;
    private Vector tagsToRemove = new Vector(10);
    private boolean wroteHead;
    private boolean replaceEntities;
    private char[] tempChars;
    private String encoding = null;
    boolean _nument = false;
    private boolean indentNext = false;
    private boolean writeCSS = false;
    private MutableAttributeSet convAttr = new SimpleAttributeSet();
    private MutableAttributeSet oConvAttr = new SimpleAttributeSet();
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public AltHTMLWriter(Writer writer, HTMLDocument hTMLDocument) {
        this(writer, hTMLDocument, 0, hTMLDocument.getLength(), null, false);
    }

    public AltHTMLWriter(Writer writer, HTMLDocument hTMLDocument, String string) {
        this(writer, hTMLDocument, 0, hTMLDocument.getLength(), string, false);
    }

    public AltHTMLWriter(Writer writer, HTMLDocument hTMLDocument, String string, boolean bl) {
        this(writer, hTMLDocument, 0, hTMLDocument.getLength(), string, bl);
    }

    public AltHTMLWriter(Writer writer, HTMLDocument hTMLDocument, int n, int n2, String string, boolean bl) {
        super(writer, hTMLDocument, n, n2);
        this.completeDoc = n == 0 && n2 == hTMLDocument.getLength();
        this.setLineLength(80);
        this.encoding = string;
        this._nument = bl;
    }

    public void write() throws IOException, BadLocationException {
        Object object;
        ElementIterator elementIterator = this.getElementIterator();
        Element element = null;
        Element element2 = null;
        this.wroteHead = false;
        this.setCurrentLineLength(0);
        this.replaceEntities = false;
        this.setCanWrapLines(false);
        if (this.segment == null) {
            this.segment = new Segment();
        }
        this.inPre = false;
        boolean bl = false;
        while ((element2 = elementIterator.next()) != null) {
            if (!this.inRange(element2)) {
                if (!this.completeDoc || element2.getAttributes().getAttribute(StyleConstants.NameAttribute) != HTML.Tag.BODY) continue;
                bl = true;
            }
            if (element != null) {
                if (this.indentNeedsIncrementing(element, element2)) {
                    this.incrIndent();
                } else if (element.getParentElement() != element2.getParentElement()) {
                    object = (Element)this.blockElementStack.peek();
                    while (object != element2.getParentElement()) {
                        this.blockElementStack.pop();
                        if (!this.synthesizedElement((Element)object)) {
                            AttributeSet attributeSet = object.getAttributes();
                            if (!this.matchNameAttribute(attributeSet, HTML.Tag.PRE) && !this.isFormElementWithContent(attributeSet)) {
                                this.decrIndent();
                            }
                            this.endTag((Element)object);
                        }
                        object = (Element)this.blockElementStack.peek();
                    }
                } else if (element.getParentElement() == element2.getParentElement() && (object = (Element)this.blockElementStack.peek()) == element) {
                    this.blockElementStack.pop();
                    this.endTag((Element)object);
                }
            }
            if (!element2.isLeaf() || this.isFormElementWithContent(element2.getAttributes())) {
                this.blockElementStack.push(element2);
                this.startTag(element2);
            } else {
                this.emptyTag(element2);
            }
            element = element2;
        }
        this.closeOutUnwantedEmbeddedTags(null);
        if (bl) {
            this.blockElementStack.pop();
            this.endTag(element);
        }
        while (!this.blockElementStack.empty()) {
            element = (Element)this.blockElementStack.pop();
            if (this.synthesizedElement(element)) continue;
            object = element.getAttributes();
            if (!this.matchNameAttribute((AttributeSet)object, HTML.Tag.PRE) && !this.isFormElementWithContent((AttributeSet)object)) {
                this.decrIndent();
            }
            this.endTag(element);
        }
        this.segment.array = null;
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        this.convAttr.removeAttributes(this.convAttr);
        AltHTMLWriter.convertToHTML32(attributeSet, this.convAttr);
        Enumeration<?> enumeration = this.convAttr.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof HTML.Tag || obj instanceof StyleConstants || obj == HTML.Attribute.ENDTAG) continue;
            this.write(" " + obj + "=\"" + this.convAttr.getAttribute(obj) + "\"");
        }
    }

    protected void emptyTag(Element element) throws BadLocationException, IOException {
        if (!this.inContent && !this.inPre) {
            this.indent();
        }
        AttributeSet attributeSet = element.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        this.writeEmbeddedTags(attributeSet);
        if (this.matchNameAttribute(attributeSet, HTML.Tag.CONTENT)) {
            this.inContent = true;
            this.text(element);
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            this.comment(element);
        } else {
            boolean bl = this.isBlockTag(element.getAttributes());
            if (this.inContent && bl) {
                this.writeLineSeparator();
                this.indent();
            }
            Object object = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
            Object object2 = attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.ENDTAG) : null;
            boolean bl2 = false;
            if (object != null && object2 != null && object2 instanceof String && ((String)object2).equals("true")) {
                bl2 = true;
            }
            if (this.completeDoc && this.matchNameAttribute(attributeSet, HTML.Tag.HEAD)) {
                if (bl2) {
                    this.writeStyles(((HTMLDocument)this.getDocument()).getStyleSheet());
                }
                this.wroteHead = true;
            }
            this.write('<');
            if (bl2) {
                this.write('/');
            }
            this.write(element.getName());
            this.writeAttributes(attributeSet);
            this.write('>');
            if (this.matchNameAttribute(attributeSet, HTML.Tag.TITLE) && !bl2) {
                Document document = element.getDocument();
                String string = (String)document.getProperty("title");
                this.write(string);
            } else if (!this.inContent || bl) {
                this.writeLineSeparator();
                if (bl && this.inContent) {
                    this.indent();
                }
            }
        }
    }

    protected boolean isBlockTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag.isBlock();
        }
        return false;
    }

    protected void startTag(Element element) throws IOException, BadLocationException {
        if (this.synthesizedElement(element)) {
            return;
        }
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        HTML.Tag tag = object instanceof HTML.Tag ? (HTML.Tag)object : null;
        if (tag == HTML.Tag.PRE) {
            this.inPre = true;
            this.preEndOffset = element.getEndOffset();
        }
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        if (this.inContent) {
            this.writeLineSeparator();
            this.inContent = false;
            this.newlineOutputed = false;
        }
        if (this.completeDoc && tag == HTML.Tag.BODY && !this.wroteHead) {
            this.wroteHead = true;
            this.indent();
            this.write("<head>");
            this.writeLineSeparator();
            this.incrIndent();
            this.writeAdditionalComments();
            this.writeLineSeparator();
            if (this.encoding != null) {
                this.writeLineSeparator();
                this.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\">");
            }
            this.writeStyles(((HTMLDocument)this.getDocument()).getStyleSheet());
            this.writeLineSeparator();
            this.write("<title>" + this.getDocument().getProperty("title") + "</title>");
            this.decrIndent();
            this.writeLineSeparator();
            this.indent();
            this.write("</head>");
            this.writeLineSeparator();
        }
        this.indent();
        this.write('<');
        this.write(element.getName());
        this.writeAttributes(attributeSet);
        this.write('>');
        if (tag != HTML.Tag.PRE) {
            this.writeLineSeparator();
        }
        if (tag == HTML.Tag.TEXTAREA) {
            this.textAreaContent(element.getAttributes());
        } else if (tag == HTML.Tag.SELECT) {
            this.selectContent(element.getAttributes());
        } else if (tag == HTML.Tag.HEAD) {
            this.indent();
            this.writeAdditionalComments();
            if (this.encoding != null) {
                this.indent();
                this.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\">");
            }
            this.writeLineSeparator();
            this.wroteHead = true;
        }
    }

    protected void textAreaContent(AttributeSet attributeSet) throws BadLocationException, IOException {
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (document != null && document.getLength() > 0) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            document.getText(0, document.getLength(), this.segment);
            if (this.segment.count > 0) {
                this.inTextArea = true;
                this.incrIndent();
                this.indent();
                this.setCanWrapLines(true);
                this.replaceEntities = true;
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.replaceEntities = false;
                this.setCanWrapLines(false);
                this.writeLineSeparator();
                this.inTextArea = false;
                this.decrIndent();
            }
        }
    }

    protected void text(Element element) throws BadLocationException, IOException {
        int n;
        int n2 = Math.max(this.getStartOffset(), element.getStartOffset());
        if (n2 < (n = Math.min(this.getEndOffset(), element.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(n2, n - n2, this.segment);
            this.newlineOutputed = false;
            if (this.segment.count > 0) {
                if (this.segment.array[this.segment.offset + this.segment.count - 1] == '\n') {
                    this.newlineOutputed = true;
                }
                if (this.inPre && n == this.preEndOffset) {
                    if (this.segment.count > 1) {
                        --this.segment.count;
                    } else {
                        return;
                    }
                }
                this.replaceEntities = true;
                this.setCanWrapLines(!this.inPre);
                this.write(this.segment.array, this.segment.offset, this.segment.count);
                this.setCanWrapLines(false);
                this.replaceEntities = false;
            }
        }
    }

    protected void selectContent(AttributeSet attributeSet) throws IOException {
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        this.incrIndent();
        if (object instanceof OptionListModel) {
            OptionListModel optionListModel = (OptionListModel)object;
            int n = optionListModel.getSize();
            for (int i = 0; i < n; ++i) {
                Option option = (Option)optionListModel.getElementAt(i);
                this.writeOption(option);
            }
        } else if (object instanceof OptionComboBoxModel) {
            OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)object;
            int n = optionComboBoxModel.getSize();
            for (int i = 0; i < n; ++i) {
                Option option = (Option)optionComboBoxModel.getElementAt(i);
                this.writeOption(option);
            }
        }
        this.decrIndent();
    }

    protected void writeOption(Option option) throws IOException {
        this.indent();
        this.write('<');
        this.write("option");
        Object object = option.getAttributes().getAttribute(HTML.Attribute.VALUE);
        if (object != null) {
            this.write(" value=" + object);
        }
        if (option.isSelected()) {
            this.write(" selected");
        }
        this.write('>');
        if (option.getLabel() != null) {
            this.write(option.getLabel());
        }
        this.writeLineSeparator();
    }

    protected void endTag(Element element) throws IOException {
        if (this.synthesizedElement(element)) {
            return;
        }
        if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.PRE)) {
            this.inPre = false;
        }
        this.closeOutUnwantedEmbeddedTags(element.getAttributes());
        if (this.inContent) {
            if (!this.newlineOutputed) {
                this.writeLineSeparator();
            }
            this.newlineOutputed = false;
            this.inContent = false;
        }
        this.indent();
        this.write('<');
        this.write('/');
        this.write(element.getName());
        this.write('>');
        this.writeLineSeparator();
    }

    protected void comment(Element element) throws BadLocationException, IOException {
        AttributeSet attributeSet = element.getAttributes();
        if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            Object object = attributeSet.getAttribute(HTML.Attribute.COMMENT);
            if (object instanceof String) {
                this.writeComment((String)object);
            } else {
                this.writeComment(null);
            }
        }
    }

    void writeComment(String string) throws IOException {
        this.write("<!--");
        if (string != null) {
            this.write(string);
        }
        this.write("-->");
        this.writeLineSeparator();
    }

    void writeAdditionalComments() throws IOException {
        Object object = this.getDocument().getProperty("AdditionalComments");
        if (object == null) {
            return;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.writeComment(vector.elementAt(i).toString());
            }
        } else {
            this.writeComment(object.toString());
        }
    }

    protected boolean synthesizedElement(Element element) {
        return this.matchNameAttribute(element.getAttributes(), HTML.Tag.IMPLIED);
    }

    protected boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    protected void writeEmbeddedTags(AttributeSet attributeSet) throws IOException {
        attributeSet = this.convertToHTML(attributeSet, this.oConvAttr);
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            HTML.Tag tag;
            Object obj = enumeration.nextElement();
            if (!(obj instanceof HTML.Tag) || (tag = (HTML.Tag)obj) == HTML.Tag.FORM || this.tags.contains(tag)) continue;
            this.write('<');
            this.write(tag.toString());
            Object object = attributeSet.getAttribute(tag);
            if (object != null && object instanceof AttributeSet) {
                this.writeAttributes((AttributeSet)object);
            }
            this.write('>');
            this.tags.addElement(tag);
            this.tagValues.addElement(object);
        }
    }

    private boolean noMatchForTagInAttributes(AttributeSet attributeSet, HTML.Tag tag, Object object) {
        if (attributeSet != null && attributeSet.isDefined(tag)) {
            Object object2 = attributeSet.getAttribute(tag);
            if (object == null ? object2 == null : object2 != null && object.equals(object2)) {
                return false;
            }
        }
        return true;
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attributeSet) throws IOException {
        HTML.Tag tag;
        int n;
        this.tagsToRemove.removeAllElements();
        attributeSet = this.convertToHTML(attributeSet, null);
        int n2 = -1;
        int n3 = this.tags.size();
        for (n = n3 - 1; n >= 0; --n) {
            tag = (HTML.Tag)this.tags.elementAt(n);
            Object e = this.tagValues.elementAt(n);
            if (attributeSet != null && !this.noMatchForTagInAttributes(attributeSet, tag, e)) continue;
            n2 = n;
            this.tagsToRemove.addElement(tag);
        }
        if (n2 != -1) {
            int n4;
            n = n3 - n2 == this.tagsToRemove.size() ? 1 : 0;
            for (n4 = n3 - 1; n4 >= n2; --n4) {
                tag = (HTML.Tag)this.tags.elementAt(n4);
                if (n != 0 || this.tagsToRemove.contains(tag)) {
                    this.tags.removeElementAt(n4);
                    this.tagValues.removeElementAt(n4);
                }
                this.write('<');
                this.write('/');
                this.write(tag.toString());
                this.write('>');
            }
            n3 = this.tags.size();
            for (n4 = n2; n4 < n3; ++n4) {
                tag = (HTML.Tag)this.tags.elementAt(n4);
                this.write('<');
                this.write(tag.toString());
                Object e = this.tagValues.elementAt(n4);
                if (e != null && e instanceof AttributeSet) {
                    this.writeAttributes((AttributeSet)e);
                }
                this.write('>');
            }
        }
    }

    private boolean isFormElementWithContent(AttributeSet attributeSet) {
        return this.matchNameAttribute(attributeSet, HTML.Tag.TEXTAREA) || this.matchNameAttribute(attributeSet, HTML.Tag.SELECT);
    }

    private boolean indentNeedsIncrementing(Element element, Element element2) {
        if (element2.getParentElement() == element && !this.inPre) {
            if (this.indentNext) {
                this.indentNext = false;
                return true;
            }
            if (this.synthesizedElement(element2)) {
                this.indentNext = true;
            } else if (!this.synthesizedElement(element)) {
                return true;
            }
        }
        return false;
    }

    void writeMaps(Enumeration enumeration) throws IOException {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Map map = (Map)enumeration.nextElement();
                String string = map.getName();
                this.incrIndent();
                this.indent();
                this.write("<map");
                if (string != null) {
                    this.write(" name=\"");
                    this.write(string);
                    this.write("\">");
                } else {
                    this.write('>');
                }
                this.writeLineSeparator();
                this.incrIndent();
                AttributeSet[] attributeSetArray = map.getAreas();
                if (attributeSetArray != null) {
                    int n = attributeSetArray.length;
                    for (int i = 0; i < n; ++i) {
                        this.indent();
                        this.write("<area");
                        this.writeAttributes(attributeSetArray[i]);
                        this.write("></area>");
                        this.writeLineSeparator();
                    }
                }
                this.decrIndent();
                this.indent();
                this.write("</map>");
                this.writeLineSeparator();
                this.decrIndent();
            }
        }
    }

    void writeStyles(StyleSheet styleSheet) throws IOException {
        Enumeration<?> enumeration;
        if (styleSheet != null && (enumeration = styleSheet.getStyleNames()) != null) {
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if ("default".equals(string) || !this.writeStyle(string, styleSheet.getStyle(string), bl)) continue;
                bl = true;
            }
            if (bl) {
                this.writeStyleEndTag();
            }
        }
    }

    boolean writeStyle(String string, Style style, boolean bl) throws IOException {
        boolean bl2 = false;
        Enumeration<?> enumeration = style.getAttributeNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string2;
                Object obj = enumeration.nextElement();
                if (!(obj instanceof CSS.Attribute) || (string2 = style.getAttribute(obj).toString()) == null) continue;
                if (!bl) {
                    this.writeStyleStartTag();
                    bl = true;
                }
                if (!bl2) {
                    bl2 = true;
                    this.indent();
                    this.write(string);
                    this.write(" {");
                } else {
                    this.write(";");
                }
                this.write(' ');
                this.write(obj.toString());
                this.write(": ");
                this.write(string2);
            }
        }
        if (bl2) {
            this.write(" }");
            this.writeLineSeparator();
        }
        return bl2;
    }

    void writeStyleStartTag() throws IOException {
        this.indent();
        this.write("<style type=\"text/css\">");
        this.incrIndent();
        this.writeLineSeparator();
        this.indent();
        this.write("<!--");
        this.incrIndent();
        this.writeLineSeparator();
    }

    void writeStyleEndTag() throws IOException {
        this.decrIndent();
        this.indent();
        this.write("-->");
        this.writeLineSeparator();
        this.decrIndent();
        this.indent();
        this.write("</style>");
        this.writeLineSeparator();
        this.indent();
    }

    AttributeSet convertToHTML(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        if (mutableAttributeSet == null) {
            mutableAttributeSet = this.convAttr;
        }
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        if (this.writeCSS) {
            AltHTMLWriter.convertToHTML40(attributeSet, mutableAttributeSet);
        } else {
            AltHTMLWriter.convertToHTML32(attributeSet, mutableAttributeSet);
        }
        return mutableAttributeSet;
    }

    private static void convertToHTML32(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        if (attributeSet == null) {
            return;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        String string = "";
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof CSS.Attribute) {
                String string2;
                if (obj == CSS.Attribute.FONT_FAMILY || obj == CSS.Attribute.FONT_SIZE || obj == CSS.Attribute.COLOR) {
                    AltHTMLWriter.createFontAttribute((CSS.Attribute)obj, attributeSet, mutableAttributeSet);
                    continue;
                }
                if (obj == CSS.Attribute.FONT_WEIGHT) {
                    int n;
                    string2 = attributeSet.getAttribute(CSS.Attribute.FONT_WEIGHT).toString();
                    if (string2 == null) continue;
                    try {
                        n = new Integer(string2);
                    }
                    catch (Exception exception) {
                        n = -1;
                    }
                    if (!string2.toLowerCase().equals("bold") && n <= 400) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.B, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (obj == CSS.Attribute.FONT_STYLE) {
                    string2 = attributeSet.getAttribute(obj).toString();
                    if (string2.indexOf("italic") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.I, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (obj == CSS.Attribute.TEXT_DECORATION) {
                    string2 = attributeSet.getAttribute(obj).toString();
                    if (string2.indexOf("underline") >= 0) {
                        mutableAttributeSet.addAttribute(HTML.Tag.U, SimpleAttributeSet.EMPTY);
                    }
                    if (string2.indexOf("line-through") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.STRIKE, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (obj == CSS.Attribute.VERTICAL_ALIGN) {
                    string2 = attributeSet.getAttribute(obj).toString();
                    if (string2.indexOf("sup") >= 0) {
                        mutableAttributeSet.addAttribute(HTML.Tag.SUP, SimpleAttributeSet.EMPTY);
                    }
                    if (string2.indexOf("sub") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.SUB, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (obj == CSS.Attribute.TEXT_ALIGN) {
                    mutableAttributeSet.addAttribute(HTML.Attribute.ALIGN, attributeSet.getAttribute(obj).toString());
                    continue;
                }
                if (string.length() > 0) {
                    string = string + "; ";
                }
                string = string + obj + ": " + attributeSet.getAttribute(obj);
                continue;
            }
            mutableAttributeSet.addAttribute(obj, attributeSet.getAttribute(obj));
        }
        if (string.length() > 0) {
            mutableAttributeSet.addAttribute(HTML.Attribute.STYLE, string);
        }
    }

    private static void createFontAttribute(CSS.Attribute attribute, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        MutableAttributeSet mutableAttributeSet2 = (MutableAttributeSet)mutableAttributeSet.getAttribute(HTML.Tag.FONT);
        if (mutableAttributeSet2 == null) {
            mutableAttributeSet2 = new SimpleAttributeSet();
            mutableAttributeSet.addAttribute(HTML.Tag.FONT, mutableAttributeSet2);
        }
        String string = attributeSet.getAttribute(attribute).toString();
        if (attribute == CSS.Attribute.FONT_FAMILY) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.FACE, string);
        } else if (attribute == CSS.Attribute.FONT_SIZE) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.SIZE, string);
        } else if (attribute == CSS.Attribute.COLOR) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.COLOR, string);
        }
    }

    private static void convertToHTML40(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        String string = "";
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (obj instanceof CSS.Attribute) {
                string = string + " " + obj + "=" + attributeSet.getAttribute(obj) + ";";
                continue;
            }
            mutableAttributeSet.addAttribute(obj, attributeSet.getAttribute(obj));
        }
        if (string.length() > 0) {
            mutableAttributeSet.addAttribute(HTML.Attribute.STYLE, string);
        }
    }

    protected void writeLineSeparator() throws IOException {
        boolean bl = this.replaceEntities;
        this.replaceEntities = false;
        super.writeLineSeparator();
        this.replaceEntities = bl;
    }

    protected void output(char[] cArray, int n, int n2) throws IOException {
        if (!this.replaceEntities) {
            super.output(cArray, n, n2);
            return;
        }
        int n3 = n;
        n2 += n;
        block7: for (int i = n; i < n2; ++i) {
            switch (cArray[i]) {
                case '<': {
                    if (i > n3) {
                        super.output(cArray, n3, i - n3);
                    }
                    n3 = i + 1;
                    this.output("&lt;");
                    continue block7;
                }
                case '>': {
                    if (i > n3) {
                        super.output(cArray, n3, i - n3);
                    }
                    n3 = i + 1;
                    this.output("&gt;");
                    continue block7;
                }
                case '&': {
                    if (i > n3) {
                        super.output(cArray, n3, i - n3);
                    }
                    n3 = i + 1;
                    this.output("&amp;");
                    continue block7;
                }
                case '\"': {
                    if (i > n3) {
                        super.output(cArray, n3, i - n3);
                    }
                    n3 = i + 1;
                    this.output("&quot;");
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block7;
                }
                default: {
                    if (cArray[i] >= ' ' && (!this._nument || cArray[i] <= '\u007f')) continue block7;
                    if (i > n3) {
                        super.output(cArray, n3, i - n3);
                    }
                    n3 = i + 1;
                    this.output("&#");
                    this.output(String.valueOf((int)cArray[i]));
                    this.output(";");
                }
            }
        }
        if (n3 < n2) {
            super.output(cArray, n3, n2 - n3);
        }
    }

    private void output(String string) throws IOException {
        int n = string.length();
        if (this.tempChars == null || this.tempChars.length < n) {
            this.tempChars = new char[n];
        }
        string.getChars(0, n, this.tempChars, 0);
        super.output(this.tempChars, 0, n);
    }

    protected static int[] extractCoords(Object object) {
        Object object2;
        if (object == null || !(object instanceof String)) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, ", \t\n\r");
        Object object3 = null;
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            int n2;
            object2 = stringTokenizer.nextToken();
            if (((String)object2).endsWith("%")) {
                n2 = -1;
                object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
            } else {
                n2 = 1;
            }
            try {
                int n3 = Integer.parseInt((String)object2);
                if (object3 == null) {
                    object3 = new int[4];
                } else if (n == ((Object)object3).length) {
                    int[] nArray = new int[((Object)object3).length * 2];
                    System.arraycopy(object3, 0, nArray, 0, ((Object)object3).length);
                    object3 = nArray;
                }
                object3[n++] = n3 * n2;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (n > 0 && n != (object3).length) {
            object2 = new int[n];
            System.arraycopy(object3, 0, object2, 0, n);
            object3 = object2;
        }
        return object3;
    }

    static interface RegionContainment {
        public boolean contains(int var1, int var2, int var3, int var4);
    }

    static class RectangleRegionContainment
    implements RegionContainment {
        float[] percents;
        int lastWidth;
        int lastHeight;
        int x0;
        int y0;
        int x1;
        int y1;

        public RectangleRegionContainment(AttributeSet attributeSet) {
            int[] nArray = AltHTMLWriter.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            this.percents = null;
            if (nArray == null || nArray.length != 4) {
                throw new RuntimeException("Unable to parse rectangular area");
            }
            this.x0 = nArray[0];
            this.y0 = nArray[1];
            this.x1 = nArray[2];
            this.y1 = nArray[3];
            if (this.x0 < 0 || this.y0 < 0 || this.x1 < 0 || this.y1 < 0) {
                this.percents = new float[4];
                this.lastHeight = -1;
                this.lastWidth = -1;
                for (int i = 0; i < 4; ++i) {
                    this.percents[i] = nArray[i] < 0 ? (float)Math.abs(nArray[i]) / 100.0f : -1.0f;
                }
            }
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            if (this.percents == null) {
                return this.contains(n, n2);
            }
            if (this.lastWidth != n3 || this.lastHeight != n4) {
                this.lastWidth = n3;
                this.lastHeight = n4;
                if (this.percents[0] != -1.0f) {
                    this.x0 = (int)(this.percents[0] * (float)n3);
                }
                if (this.percents[1] != -1.0f) {
                    this.y0 = (int)(this.percents[1] * (float)n4);
                }
                if (this.percents[2] != -1.0f) {
                    this.x1 = (int)(this.percents[2] * (float)n3);
                }
                if (this.percents[3] != -1.0f) {
                    this.y1 = (int)(this.percents[3] * (float)n4);
                }
            }
            return this.contains(n, n2);
        }

        public boolean contains(int n, int n2) {
            return n >= this.x0 && n <= this.x1 && n2 >= this.y0 && n2 <= this.y1;
        }
    }

    static class PolygonRegionContainment
    extends Polygon
    implements RegionContainment {
        float[] percentValues;
        int[] percentIndexs;
        int lastWidth;
        int lastHeight;

        public PolygonRegionContainment(AttributeSet attributeSet) {
            int n;
            int[] nArray = AltHTMLWriter.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            if (nArray == null || nArray.length == 0 || nArray.length % 2 != 0) {
                throw new RuntimeException("Unable to parse polygon area");
            }
            int n2 = 0;
            this.lastHeight = -1;
            this.lastWidth = -1;
            for (n = nArray.length - 1; n >= 0; --n) {
                if (nArray[n] >= 0) continue;
                ++n2;
            }
            if (n2 > 0) {
                this.percentIndexs = new int[n2];
                this.percentValues = new float[n2];
                int n3 = 0;
                for (n = nArray.length - 1; n >= 0; --n) {
                    if (nArray[n] >= 0) continue;
                    this.percentValues[n3] = (float)nArray[n] / -100.0f;
                    this.percentIndexs[n3] = n;
                    ++n3;
                }
            } else {
                this.percentIndexs = null;
                this.percentValues = null;
            }
            this.npoints = nArray.length / 2;
            this.xpoints = new int[this.npoints];
            this.ypoints = new int[this.npoints];
            for (n = 0; n < this.npoints; ++n) {
                this.xpoints[n] = nArray[n + n];
                this.ypoints[n] = nArray[n + n + 1];
            }
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            if (this.percentValues == null || this.lastWidth == n3 && this.lastHeight == n4) {
                return this.contains(n, n2);
            }
            this.bounds = null;
            this.lastWidth = n3;
            this.lastHeight = n4;
            float f = n3;
            float f2 = n4;
            for (int i = this.percentValues.length - 1; i >= 0; --i) {
                if (this.percentIndexs[i] % 2 == 0) {
                    this.xpoints[this.percentIndexs[i] / 2] = (int)(this.percentValues[i] * f);
                    continue;
                }
                this.ypoints[this.percentIndexs[i] / 2] = (int)(this.percentValues[i] * f2);
            }
            return this.contains(n, n2);
        }
    }

    static class DefaultRegionContainment
    implements RegionContainment {
        static DefaultRegionContainment si = null;

        DefaultRegionContainment() {
        }

        public static DefaultRegionContainment sharedInstance() {
            if (si == null) {
                si = new DefaultRegionContainment();
            }
            return si;
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            return n <= n3 && n >= 0 && n2 >= 0 && n2 <= n3;
        }
    }

    static class CircleRegionContainment
    implements RegionContainment {
        int x;
        int y;
        int radiusSquared;
        float[] percentValues;
        int lastWidth;
        int lastHeight;

        public CircleRegionContainment(AttributeSet attributeSet) {
            int[] nArray = AltHTMLWriter.extractCoords(attributeSet.getAttribute(HTML.Attribute.COORDS));
            if (nArray == null || nArray.length != 3) {
                throw new RuntimeException("Unable to parse circular area");
            }
            this.x = nArray[0];
            this.y = nArray[1];
            this.radiusSquared = nArray[2] * nArray[2];
            if (nArray[0] < 0 || nArray[1] < 0 || nArray[2] < 0) {
                this.lastHeight = -1;
                this.lastWidth = -1;
                this.percentValues = new float[3];
                for (int i = 0; i < 3; ++i) {
                    this.percentValues[i] = nArray[i] < 0 ? (float)nArray[i] / -100.0f : -1.0f;
                }
            } else {
                this.percentValues = null;
            }
        }

        public boolean contains(int n, int n2, int n3, int n4) {
            if (this.percentValues != null && (this.lastWidth != n3 || this.lastHeight != n4)) {
                this.lastWidth = n3;
                this.lastHeight = n4;
                if (this.percentValues[0] != -1.0f) {
                    this.x = (int)(this.percentValues[0] * (float)n3);
                }
                if (this.percentValues[1] != -1.0f) {
                    this.y = (int)(this.percentValues[1] * (float)n4);
                }
                if (this.percentValues[2] != -1.0f) {
                    this.radiusSquared = (int)(this.percentValues[2] * (float)Math.min(n3, n4));
                    this.radiusSquared *= this.radiusSquared;
                }
            }
            return (n - this.x) * (n - this.x) + (n2 - this.y) * (n2 - this.y) <= this.radiusSquared;
        }
    }

    class Map {
        private String name;
        private Vector areaAttributes;
        private Vector areas;

        public Map() {
        }

        public Map(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void addArea(AttributeSet attributeSet) {
            if (attributeSet == null) {
                return;
            }
            if (this.areaAttributes == null) {
                this.areaAttributes = new Vector(2);
            }
            this.areaAttributes.addElement(attributeSet.copyAttributes());
        }

        public void removeArea(AttributeSet attributeSet) {
            if (attributeSet != null && this.areaAttributes != null) {
                int n = this.areas != null ? this.areas.size() : 0;
                for (int i = this.areaAttributes.size() - 1; i >= 0; --i) {
                    if (!((AttributeSet)this.areaAttributes.elementAt(i)).isEqual(attributeSet)) continue;
                    this.areaAttributes.removeElementAt(i);
                    if (i >= n) continue;
                    this.areas.removeElementAt(i);
                }
            }
        }

        public AttributeSet[] getAreas() {
            int n;
            int n2 = n = this.areaAttributes != null ? this.areaAttributes.size() : 0;
            if (n != 0) {
                Object[] objectArray = new AttributeSet[n];
                this.areaAttributes.copyInto(objectArray);
                return objectArray;
            }
            return null;
        }

        public AttributeSet getArea(int n, int n2, int n3, int n4) {
            int n5;
            int n6 = n5 = this.areaAttributes != null ? this.areaAttributes.size() : 0;
            if (n5 > 0) {
                int n7;
                int n8 = n7 = this.areas != null ? this.areas.size() : 0;
                if (this.areas == null) {
                    this.areas = new Vector(n5);
                }
                for (int i = 0; i < n5; ++i) {
                    RegionContainment regionContainment;
                    if (i >= n7) {
                        this.areas.addElement(this.createRegionContainment((AttributeSet)this.areaAttributes.elementAt(i)));
                    }
                    if ((regionContainment = (RegionContainment)this.areas.elementAt(i)) == null || !regionContainment.contains(n, n2, n3, n4)) continue;
                    return (AttributeSet)this.areaAttributes.elementAt(i);
                }
            }
            return null;
        }

        protected RegionContainment createRegionContainment(AttributeSet attributeSet) {
            Object object = attributeSet.getAttribute(HTML.Attribute.SHAPE);
            if (object == null) {
                object = "rect";
            }
            if (object instanceof String) {
                String string = ((String)object).toLowerCase();
                RegionContainment regionContainment = null;
                try {
                    if (string.equals("rect")) {
                        regionContainment = new RectangleRegionContainment(attributeSet);
                    } else if (string.equals("circle")) {
                        regionContainment = new CircleRegionContainment(attributeSet);
                    } else if (string.equals("poly")) {
                        regionContainment = new PolygonRegionContainment(attributeSet);
                    } else if (string.equals("default")) {
                        regionContainment = DefaultRegionContainment.sharedInstance();
                    }
                }
                catch (RuntimeException runtimeException) {
                    regionContainment = null;
                }
                return regionContainment;
            }
            return null;
        }
    }

    class OptionComboBoxModel
    extends DefaultComboBoxModel
    implements Serializable {
        private Option selectedOption = null;

        OptionComboBoxModel() {
        }

        public void setInitialSelection(Option option) {
            this.selectedOption = option;
        }

        public Option getInitialSelection() {
            return this.selectedOption;
        }
    }

    class OptionListModel
    extends DefaultListModel
    implements ListSelectionModel,
    Serializable {
        private static final int MIN = -1;
        private static final int MAX = Integer.MAX_VALUE;
        private int selectionMode = 0;
        private int minIndex = Integer.MAX_VALUE;
        private int maxIndex = -1;
        private int anchorIndex = -1;
        private int leadIndex = -1;
        private int firstChangedIndex = Integer.MAX_VALUE;
        private int lastChangedIndex = -1;
        private boolean isAdjusting = false;
        private BitSet value = new BitSet(32);
        private BitSet initialValue = new BitSet(32);
        protected EventListenerList listenerList = new EventListenerList();
        protected boolean leadAnchorNotificationEnabled = true;

        OptionListModel() {
        }

        public int getMinSelectionIndex() {
            return this.isSelectionEmpty() ? -1 : this.minIndex;
        }

        public int getMaxSelectionIndex() {
            return this.maxIndex;
        }

        public boolean getValueIsAdjusting() {
            return this.isAdjusting;
        }

        public int getSelectionMode() {
            return this.selectionMode;
        }

        public void setSelectionMode(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this.selectionMode = n;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid selectionMode");
                }
            }
        }

        public boolean isSelectedIndex(int n) {
            return n < this.minIndex || n > this.maxIndex ? false : this.value.get(n);
        }

        public boolean isSelectionEmpty() {
            return this.minIndex > this.maxIndex;
        }

        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.listenerList.add(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = AltHTMLWriter.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
        }

        public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
            this.listenerList.remove(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = AltHTMLWriter.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener, listSelectionListener);
        }

        public ListSelectionListener[] getListSelectionListeners() {
            return (ListSelectionListener[])this.listenerList.getListeners(class$javax$swing$event$ListSelectionListener == null ? (class$javax$swing$event$ListSelectionListener = AltHTMLWriter.class$("javax.swing.event.ListSelectionListener")) : class$javax$swing$event$ListSelectionListener);
        }

        protected void fireValueChanged(boolean bl) {
            this.fireValueChanged(this.getMinSelectionIndex(), this.getMaxSelectionIndex(), bl);
        }

        protected void fireValueChanged(int n, int n2) {
            this.fireValueChanged(n, n2, this.getValueIsAdjusting());
        }

        protected void fireValueChanged(int n, int n2, boolean bl) {
            Object[] objectArray = this.listenerList.getListenerList();
            ListSelectionEvent listSelectionEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$ListSelectionListener == null ? AltHTMLWriter.class$("javax.swing.event.ListSelectionListener") : class$javax$swing$event$ListSelectionListener)) continue;
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[i + 1]).valueChanged(listSelectionEvent);
            }
        }

        private void fireValueChanged() {
            if (this.lastChangedIndex == -1) {
                return;
            }
            int n = this.firstChangedIndex;
            int n2 = this.lastChangedIndex;
            this.firstChangedIndex = Integer.MAX_VALUE;
            this.lastChangedIndex = -1;
            this.fireValueChanged(n, n2);
        }

        private void markAsDirty(int n) {
            this.firstChangedIndex = Math.min(this.firstChangedIndex, n);
            this.lastChangedIndex = Math.max(this.lastChangedIndex, n);
        }

        private void set(int n) {
            if (this.value.get(n)) {
                return;
            }
            this.value.set(n);
            this.markAsDirty(n);
            this.minIndex = Math.min(this.minIndex, n);
            this.maxIndex = Math.max(this.maxIndex, n);
        }

        private void clear(int n) {
            if (!this.value.get(n)) {
                return;
            }
            this.value.clear(n);
            this.markAsDirty(n);
            if (n == this.minIndex) {
                ++this.minIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.minIndex)) {
                    ++this.minIndex;
                }
            }
            if (n == this.maxIndex) {
                --this.maxIndex;
                while (this.minIndex <= this.maxIndex && !this.value.get(this.maxIndex)) {
                    --this.maxIndex;
                }
            }
            if (this.isSelectionEmpty()) {
                this.minIndex = Integer.MAX_VALUE;
                this.maxIndex = -1;
            }
        }

        public void setLeadAnchorNotificationEnabled(boolean bl) {
            this.leadAnchorNotificationEnabled = bl;
        }

        public boolean isLeadAnchorNotificationEnabled() {
            return this.leadAnchorNotificationEnabled;
        }

        private void updateLeadAnchorIndices(int n, int n2) {
            if (this.leadAnchorNotificationEnabled) {
                if (this.anchorIndex != n) {
                    if (this.anchorIndex != -1) {
                        this.markAsDirty(this.anchorIndex);
                    }
                    this.markAsDirty(n);
                }
                if (this.leadIndex != n2) {
                    if (this.leadIndex != -1) {
                        this.markAsDirty(this.leadIndex);
                    }
                    this.markAsDirty(n2);
                }
            }
            this.anchorIndex = n;
            this.leadIndex = n2;
        }

        private boolean contains(int n, int n2, int n3) {
            return n3 >= n && n3 <= n2;
        }

        private void changeSelection(int n, int n2, int n3, int n4, boolean bl) {
            for (int i = Math.min(n3, n); i <= Math.max(n4, n2); ++i) {
                boolean bl2 = this.contains(n, n2, i);
                boolean bl3 = this.contains(n3, n4, i);
                if (bl3 && bl2) {
                    if (bl) {
                        bl2 = false;
                    } else {
                        bl3 = false;
                    }
                }
                if (bl3) {
                    this.set(i);
                }
                if (!bl2) continue;
                this.clear(i);
            }
            this.fireValueChanged();
        }

        private void changeSelection(int n, int n2, int n3, int n4) {
            this.changeSelection(n, n2, n3, n4, true);
        }

        public void clearSelection() {
            this.removeSelectionInterval(this.minIndex, this.maxIndex);
        }

        public void setSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            if (this.getSelectionMode() == 0) {
                n = n2;
            }
            this.updateLeadAnchorIndices(n, n2);
            int n3 = this.minIndex;
            int n4 = this.maxIndex;
            int n5 = Math.min(n, n2);
            int n6 = Math.max(n, n2);
            this.changeSelection(n3, n4, n5, n6);
        }

        public void addSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            if (this.getSelectionMode() != 2) {
                this.setSelectionInterval(n, n2);
                return;
            }
            this.updateLeadAnchorIndices(n, n2);
            int n3 = Integer.MAX_VALUE;
            int n4 = -1;
            int n5 = Math.min(n, n2);
            int n6 = Math.max(n, n2);
            this.changeSelection(n3, n4, n5, n6);
        }

        public void removeSelectionInterval(int n, int n2) {
            if (n == -1 || n2 == -1) {
                return;
            }
            this.updateLeadAnchorIndices(n, n2);
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            int n5 = Integer.MAX_VALUE;
            int n6 = -1;
            this.changeSelection(n3, n4, n5, n6);
        }

        private void setState(int n, boolean bl) {
            if (bl) {
                this.set(n);
            } else {
                this.clear(n);
            }
        }

        public void insertIndexInterval(int n, int n2, boolean bl) {
            int n3;
            int n4 = bl ? n : n + 1;
            int n5 = n4 + n2 - 1;
            for (n3 = this.maxIndex; n3 >= n4; --n3) {
                this.setState(n3 + n2, this.value.get(n3));
            }
            n3 = this.value.get(n) ? 1 : 0;
            for (int i = n4; i <= n5; ++i) {
                this.setState(i, n3 != 0);
            }
        }

        public void removeIndexInterval(int n, int n2) {
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            int n5 = n4 - n3 + 1;
            for (int i = n3; i <= this.maxIndex; ++i) {
                this.setState(i, this.value.get(i + n5));
            }
        }

        public void setValueIsAdjusting(boolean bl) {
            if (bl != this.isAdjusting) {
                this.isAdjusting = bl;
                this.fireValueChanged(bl);
            }
        }

        public String toString() {
            String string = (this.getValueIsAdjusting() ? "~" : "=") + this.value.toString();
            return this.getClass().getName() + " " + Integer.toString(this.hashCode()) + " " + string;
        }

        public Object clone() throws CloneNotSupportedException {
            OptionListModel optionListModel = (OptionListModel)super.clone();
            optionListModel.value = (BitSet)this.value.clone();
            optionListModel.listenerList = new EventListenerList();
            return optionListModel;
        }

        public int getAnchorSelectionIndex() {
            return this.anchorIndex;
        }

        public int getLeadSelectionIndex() {
            return this.leadIndex;
        }

        public void setAnchorSelectionIndex(int n) {
            this.anchorIndex = n;
        }

        public void setLeadSelectionIndex(int n) {
            int n2 = this.anchorIndex;
            if (this.getSelectionMode() == 0) {
                n2 = n;
            }
            int n3 = Math.min(this.anchorIndex, this.leadIndex);
            int n4 = Math.max(this.anchorIndex, this.leadIndex);
            int n5 = Math.min(n2, n);
            int n6 = Math.max(n2, n);
            if (this.value.get(this.anchorIndex)) {
                this.changeSelection(n3, n4, n5, n6);
            } else {
                this.changeSelection(n5, n6, n3, n4, false);
            }
            this.anchorIndex = n2;
            this.leadIndex = n;
        }

        public void setInitialSelection(int n) {
            if (this.initialValue.get(n)) {
                return;
            }
            if (this.selectionMode == 0) {
                this.initialValue.and(new BitSet());
            }
            this.initialValue.set(n);
        }

        public BitSet getInitialSelection() {
            return this.initialValue;
        }
    }
}

